/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.notification;

import oracle.bpm.designer.expression.ExpressionContainerListener;
import oracle.bpm.designer.expression.ExpressionPanel;
import oracle.bpm.designer.identity.LookupDialog;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.notification.MailNotificationAttachmentsTable;
import oracle.bpm.designer.notification.MailNotificationHeadersTable;
import oracle.bpm.designer.notification.NotificationDefinitionPanel;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.notification.MailNotificationDefinition;
import oracle.bpm.project.model.processes.notification.NotificationDefinition;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.TabbedPane;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import org.jetbrains.annotations.NotNull;

class MailNotificationDefinitionPanel
extends NotificationDefinitionPanel {
    private MailNotificationAttachmentsTable attachmentsTable;
    private ExpressionPanel bccExpressionPanel;
    private ExpressionPanel bodyExpressionPanel;
    private ExpressionPanel ccExpressionPanel;
    private ExpressionPanel fromAccountExpressionPanel;
    private MailNotificationHeadersTable headersTable;
    private ExpressionPanel replyToExpressionPanel;
    private ExpressionPanel subjectExpressionPanel;
    private ExpressionPanel toExpressionPanel;

    protected MailNotificationDefinitionPanel(@NotNull UiContainer parent, @NotNull MailNotificationDefinition mailNotificationDefinition) {
        super(parent, (NotificationDefinition)mailNotificationDefinition);
        this.init();
    }

    @Override
    public boolean isValid() {
        return this.ccExpressionPanel.isExpressionValid() && this.bccExpressionPanel.isExpressionValid() && this.fromAccountExpressionPanel.isExpressionValid() && this.toExpressionPanel.isExpressionValid() && this.replyToExpressionPanel.isExpressionValid() && this.subjectExpressionPanel.isExpressionValid() && this.bodyExpressionPanel.isExpressionValid() && this.attachmentsTable.isValid() && this.headersTable.isValid();
    }

    protected MailNotificationDefinition getNotificationDefinition() {
        return (MailNotificationDefinition)super.getNotificationDefinition();
    }

    private void init() {
        this.setLayout((Layout)new BorderLayout());
        TabbedPane tabbedPane = new TabbedPane((UiContainer)this);
        this.add((UiComponent)tabbedPane, "Center");
        Panel generalPanel = new Panel((UiContainer)tabbedPane);
        generalPanel.setLayout((Layout)new MigLayout("ins 10, gap 0, fillx"));
        ExpressionContext formExpressionContext = new ExpressionContext(this.getExpressionContext(), MailNotificationDefinition.ResultType.getFromAccount());
        this.fromAccountExpressionPanel = this.createAndAddExpressionPanel((UiContainer)generalPanel, ProjectModelMsg.FROM_ACCOUNT, formExpressionContext, this.getNotificationDefinition().getFromAccount(), false, null);
        this.fromAccountExpressionPanel.addListener(new ExpressionContainerListener(){

            @Override
            public void expressionChanged() {
                MailNotificationDefinitionPanel.this.getNotificationDefinition().setFromAccount(MailNotificationDefinitionPanel.this.fromAccountExpressionPanel.getExpression());
            }
        });
        ExpressionContext toExpressionContext = new ExpressionContext(this.getExpressionContext(), MailNotificationDefinition.ResultType.getTo());
        this.toExpressionPanel = this.createAndAddExpressionPanel((UiContainer)generalPanel, ProjectModelMsg.TO, toExpressionContext, this.getNotificationDefinition().getTo(), false, LookupDialog.LookupDialogType.EMAIL);
        this.toExpressionPanel.addListener(new ExpressionContainerListener(){

            @Override
            public void expressionChanged() {
                MailNotificationDefinitionPanel.this.getNotificationDefinition().setTo(MailNotificationDefinitionPanel.this.toExpressionPanel.getExpression());
            }
        });
        ExpressionContext ccExpressionContext = new ExpressionContext(this.getExpressionContext(), MailNotificationDefinition.ResultType.getCc());
        this.ccExpressionPanel = this.createAndAddExpressionPanel((UiContainer)generalPanel, ProjectModelMsg.CC, ccExpressionContext, this.getNotificationDefinition().getCc(), false, LookupDialog.LookupDialogType.EMAIL);
        this.ccExpressionPanel.addListener(new ExpressionContainerListener(){

            @Override
            public void expressionChanged() {
                MailNotificationDefinitionPanel.this.getNotificationDefinition().setCc(MailNotificationDefinitionPanel.this.ccExpressionPanel.getExpression());
            }
        });
        ExpressionContext bccExpressionContext = new ExpressionContext(this.getExpressionContext(), MailNotificationDefinition.ResultType.getBcc());
        this.bccExpressionPanel = this.createAndAddExpressionPanel((UiContainer)generalPanel, ProjectModelMsg.BCC, bccExpressionContext, this.getNotificationDefinition().getBcc(), false, LookupDialog.LookupDialogType.EMAIL);
        this.bccExpressionPanel.addListener(new ExpressionContainerListener(){

            @Override
            public void expressionChanged() {
                MailNotificationDefinitionPanel.this.getNotificationDefinition().setBcc(MailNotificationDefinitionPanel.this.bccExpressionPanel.getExpression());
            }
        });
        ExpressionContext replyToExpressionContext = new ExpressionContext(this.getExpressionContext(), MailNotificationDefinition.ResultType.getReplyTo());
        this.replyToExpressionPanel = this.createAndAddExpressionPanel((UiContainer)generalPanel, ProjectModelMsg.REPLY_TO, replyToExpressionContext, this.getNotificationDefinition().getReplyTo(), false, LookupDialog.LookupDialogType.EMAIL);
        this.replyToExpressionPanel.addListener(new ExpressionContainerListener(){

            @Override
            public void expressionChanged() {
                MailNotificationDefinitionPanel.this.getNotificationDefinition().setReplyTo(MailNotificationDefinitionPanel.this.replyToExpressionPanel.getExpression());
            }
        });
        tabbedPane.addTab(DesignerMsg.GENERAL.getString(), (UiComponent)generalPanel);
        Panel contentPanel = new Panel((UiContainer)tabbedPane);
        contentPanel.setLayout((Layout)new MigLayout("ins 10, gap 0, fillx"));
        ExpressionContext subjectExpressionContext = new ExpressionContext(this.getExpressionContext(), MailNotificationDefinition.ResultType.getSubject());
        this.subjectExpressionPanel = this.createAndAddExpressionPanel((UiContainer)contentPanel, ProjectModelMsg.SUBJECT, subjectExpressionContext, this.getNotificationDefinition().getSubject(), false, null);
        this.subjectExpressionPanel.addListener(new ExpressionContainerListener(){

            @Override
            public void expressionChanged() {
                MailNotificationDefinitionPanel.this.getNotificationDefinition().setSubject(MailNotificationDefinitionPanel.this.subjectExpressionPanel.getExpression());
            }
        });
        ExpressionContext bodyExpressionContext = new ExpressionContext(this.getExpressionContext(), MailNotificationDefinition.ResultType.getBody());
        this.bodyExpressionPanel = this.createAndAddExpressionPanel((UiContainer)contentPanel, ProjectModelMsg.BODY, bodyExpressionContext, this.getNotificationDefinition().getBody(), true, null);
        this.bodyExpressionPanel.addListener(new ExpressionContainerListener(){

            @Override
            public void expressionChanged() {
                MailNotificationDefinitionPanel.this.getNotificationDefinition().setBody(MailNotificationDefinitionPanel.this.bodyExpressionPanel.getExpression());
            }
        });
        tabbedPane.addTab(ProjectModelMsg.CONTENT.getString(), (UiComponent)contentPanel);
        Panel attachmentsPanel = new Panel((UiContainer)tabbedPane);
        attachmentsPanel.setLayout((Layout)new MigLayout("ins 0, gap 0, fill"));
        this.attachmentsTable = new MailNotificationAttachmentsTable((UiContainer)attachmentsPanel, this.getNotificationDefinition(), this.getExpressionContext());
        attachmentsPanel.add((UiComponent)this.attachmentsTable, (Object)"grow");
        tabbedPane.addTab(ProjectModelMsg.ATTACHMENTS.getString(), (UiComponent)attachmentsPanel);
        Panel headersPanel = new Panel((UiContainer)tabbedPane);
        headersPanel.setLayout((Layout)new MigLayout("ins 0, gap 0, fill"));
        this.headersTable = new MailNotificationHeadersTable((UiContainer)headersPanel, this.getNotificationDefinition(), this.getExpressionContext());
        headersPanel.add((UiComponent)this.headersTable, (Object)"grow");
        tabbedPane.addTab(ProjectModelMsg.HEADERS.getString(), (UiComponent)headersPanel);
    }
}

