/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.notification;

import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.notification.MailNotificationAttachmentDialog;
import oracle.bpm.draw.Color;
import oracle.bpm.lib.Expression;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.project.compile.process.ExpressionHelper;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.notification.MailNotificationAttachment;
import oracle.bpm.project.model.processes.notification.MailNotificationDefinition;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ColorProvider;
import oracle.bpm.ui.TableColorProvider;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.table.BaseTablePanel;
import oracle.bpm.ui.table.ProviderTableModel;
import oracle.bpm.ui.table.TableModel;
import org.jetbrains.annotations.NotNull;

class MailNotificationAttachmentsTable
extends BaseTablePanel {
    private DataDeclarationContainer context;
    private MailNotificationDefinition mailNotificationDefinition;

    public MailNotificationAttachmentsTable(@NotNull UiContainer parent, @NotNull MailNotificationDefinition mailNotificationDefinition, @NotNull DataDeclarationContainer context) {
        super(parent, Msg.QUOTE(""), ProjectModelMsg.ATTACHMENTS, (TableModel)new MailNotificationAttachmentsTableModel(context), BaseTablePanel.Style.TOOLBAR_TOP);
        this.mailNotificationDefinition = mailNotificationDefinition;
        this.context = context;
        this.setWithColons(true);
        this.init();
    }

    public boolean isValid() {
        for (MailNotificationAttachment attachment : this.getAttachments()) {
            ExpressionContext nameContext = new ExpressionContext(this.context, MailNotificationAttachment.ResultType.getName());
            if (!ExpressionHelper.isExpressionValid((Expression)attachment.getName(), (ExpressionContext)nameContext)) {
                return false;
            }
            ExpressionContext mimeTypeContext = new ExpressionContext(this.context, MailNotificationAttachment.ResultType.getMimeType());
            if (!ExpressionHelper.isExpressionValid((Expression)attachment.getMimeType(), (ExpressionContext)mimeTypeContext)) {
                return false;
            }
            ExpressionContext valueContext = new ExpressionContext(this.context, MailNotificationAttachment.ResultType.getValue());
            if (!ExpressionHelper.isExpressionValid((Expression)attachment.getValue(), (ExpressionContext)valueContext)) {
                return false;
            }
            ExpressionContext encodingContext = new ExpressionContext(this.context, MailNotificationAttachment.ResultType.getEncoding());
            if (ExpressionHelper.isExpressionValid((Expression)attachment.getEncoding(), (ExpressionContext)encodingContext)) continue;
            return false;
        }
        return true;
    }

    protected boolean showEditAction() {
        return true;
    }

    protected void addAction() {
        MailNotificationAttachmentDialog dialog = new MailNotificationAttachmentDialog(this.getOwnerWindow(), null, this.mailNotificationDefinition, this.context);
        if (dialog.display()) {
            MailNotificationAttachment attachment = (MailNotificationAttachment)dialog.getObject();
            this.getModel().addRow(attachment);
            this.updateAttachments();
        }
    }

    protected void editAction() {
        MailNotificationAttachment oldAttachment = (MailNotificationAttachment)this.getModel().getRow(this.getTable().getSelectedRow());
        MailNotificationAttachmentDialog dialog = new MailNotificationAttachmentDialog(this.getOwnerWindow(), oldAttachment, this.mailNotificationDefinition, this.context);
        if (dialog.display()) {
            MailNotificationAttachment newAttachment = (MailNotificationAttachment)dialog.getObject();
            this.getModel().updateRow(this.getTable().getSelectedRow(), newAttachment);
            this.updateAttachments();
        }
    }

    protected void deleteAction() {
        super.deleteAction();
        this.updateAttachments();
    }

    protected MailNotificationAttachmentsTableModel getModel() {
        return (MailNotificationAttachmentsTableModel)super.getModel();
    }

    private Sequence<MailNotificationAttachment> getAttachments() {
        return CollectionUtils.asSequence(this.getModel().getData());
    }

    private void updateAttachments() {
        this.mailNotificationDefinition.clearAttachments();
        for (MailNotificationAttachment attachment : this.getAttachments()) {
            this.mailNotificationDefinition.addAttachment(attachment);
        }
    }

    private void init() {
        this.getTable().getColumn(0).setColorProvider((ColorProvider)new TableColorProvider.Default(){

            public Color getForeground(Object element) {
                return !MailNotificationAttachmentsTable.this.getModel().isValid(0, this.getRow()) ? Color.RED : null;
            }

            public Color getBackground(Object element) {
                return Color.WHITE;
            }
        });
        this.getTable().getColumn(1).setColorProvider((ColorProvider)new TableColorProvider.Default(){

            public Color getForeground(Object element) {
                return !MailNotificationAttachmentsTable.this.getModel().isValid(1, this.getRow()) ? Color.RED : null;
            }

            public Color getBackground(Object element) {
                return Color.WHITE;
            }
        });
        this.getTable().getColumn(2).setColorProvider((ColorProvider)new TableColorProvider.Default(){

            public Color getForeground(Object element) {
                return !MailNotificationAttachmentsTable.this.getModel().isValid(2, this.getRow()) ? Color.RED : null;
            }

            public Color getBackground(Object element) {
                return Color.WHITE;
            }
        });
        this.getTable().getColumn(3).setColorProvider((ColorProvider)new TableColorProvider.Default(){

            public Color getForeground(Object element) {
                return !MailNotificationAttachmentsTable.this.getModel().isValid(3, this.getRow()) ? Color.RED : null;
            }

            public Color getBackground(Object element) {
                return Color.WHITE;
            }
        });
        for (MailNotificationAttachment item : this.mailNotificationDefinition.getAttachments()) {
            this.getModel().addRow(item);
        }
    }

    private static class MailNotificationAttachmentsTableModel
    extends ProviderTableModel<MailNotificationAttachment> {
        private DataDeclarationContainer context;
        private static final MsgList titles = MsgList.create(DesignerMsg.NAME, ProjectModelMsg.MIME_TYPE, ProjectModelMsg.TRANSFER_ENCODING, DesignerMsg.VALUE);

        public MailNotificationAttachmentsTableModel(@NotNull DataDeclarationContainer context) {
            super(titles);
            this.context = context;
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public Object getValueAt(int row, int column) {
            return this.getExpressionText(row, column);
        }

        public boolean isValid(int column, int row) {
            Expression expression = this.getExpression(column, row);
            ExpressionContext expressionContext = this.getExpressionContext(column);
            return ExpressionHelper.isExpressionValid((Expression)expression, (ExpressionContext)expressionContext);
        }

        private Expression getExpression(int column, int row) {
            Expression result = null;
            MailNotificationAttachment attachment = (MailNotificationAttachment)this.getRow(row);
            switch (column) {
                case 0: {
                    result = attachment.getName();
                    break;
                }
                case 1: {
                    result = attachment.getMimeType();
                    break;
                }
                case 2: {
                    result = attachment.getEncoding();
                    break;
                }
                case 3: {
                    result = attachment.getValue();
                }
            }
            return result;
        }

        private String getExpressionText(int row, int column) {
            Expression expression = this.getExpression(column, row);
            ExpressionContext expressionContext = this.getExpressionContext(column);
            return ExpressionHelper.getText((Expression)expression, (ExpressionContext)expressionContext);
        }

        private ExpressionContext getExpressionContext(int column) {
            CatalogType resultType = null;
            switch (column) {
                case 0: {
                    resultType = MailNotificationAttachment.ResultType.getName();
                    break;
                }
                case 1: {
                    resultType = MailNotificationAttachment.ResultType.getMimeType();
                    break;
                }
                case 2: {
                    resultType = MailNotificationAttachment.ResultType.getEncoding();
                    break;
                }
                case 3: {
                    resultType = MailNotificationAttachment.ResultType.getValue();
                }
            }
            return new ExpressionContext(this.context, resultType);
        }
    }
}

