/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.notification;

import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.expression.ExpressionPanel;
import oracle.bpm.designer.expression.ExpressionPanelFactory;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lib.Expression;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.project.compile.process.ExpressionHelper;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.notification.MailNotificationAttachment;
import oracle.bpm.project.model.processes.notification.MailNotificationDefinition;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.ObjectEditorDialog;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MailNotificationAttachmentDialog
extends ObjectEditorDialog<MailNotificationAttachment> {
    private DataDeclarationContainer context;
    private ExpressionPanel encodingExpressionPanel;
    private MailNotificationDefinition mailNotificationDefinition;
    private ExpressionPanel mimeTypeExpressionPanel;
    private ExpressionPanel nameExpressionPanel;
    private ExpressionPanel valueExpressionPanel;
    private static String DEFAULT_MIME_TYPE = "text/html";
    private static String DEFAULT_NAME_SEED = "attachment";

    public MailNotificationAttachmentDialog(@NotNull UiWindow parent, @Nullable MailNotificationAttachment attachment, @NotNull MailNotificationDefinition mailNotificationDefinition, @NotNull DataDeclarationContainer context) {
        super(parent, ProjectModelMsg.ATTACHMENT, (Object)attachment);
        this.mailNotificationDefinition = mailNotificationDefinition;
        this.context = context;
    }

    public Expression getDefaultName() {
        Expression textExpression;
        int count = 0;
        while (this.attachmentNameExists(textExpression = ExpressionHelper.createTextExpression((String)(DEFAULT_NAME_SEED + ++count)))) {
        }
        return textExpression;
    }

    protected void setObjectFromEditor(@NotNull MailNotificationAttachment object) {
        throw new UnsupportedOperationException("Cannot edit an attachment. Must delete and create a new one");
    }

    protected MailNotificationAttachment createObjectFromEditor() {
        return this.mailNotificationDefinition.createAttachment(this.nameExpressionPanel.getExpression(), this.mimeTypeExpressionPanel.getExpression(), this.valueExpressionPanel.getExpression(), this.encodingExpressionPanel.getExpression());
    }

    protected void setEditorFromObject(@NotNull MailNotificationAttachment object) {
        this.nameExpressionPanel.setExpression(object.getName());
        this.mimeTypeExpressionPanel.setExpression(object.getMimeType());
        this.encodingExpressionPanel.setExpression(object.getEncoding());
        this.valueExpressionPanel.setExpression(object.getValue());
    }

    protected void setEditorDefaultValues() {
        Expression defaultName = this.getDefaultName();
        this.nameExpressionPanel.setExpression(defaultName);
        Expression defaultMimeTypeExpression = ExpressionHelper.createTextExpression((String)DEFAULT_MIME_TYPE);
        this.mimeTypeExpressionPanel.setExpression(defaultMimeTypeExpression);
    }

    protected Msg validateInput() {
        if (this.nameExpressionPanel.getExpression() == null) {
            return DesignerMsg.DYNAMIC_NOT_NULL(DesignerMsg.NAME);
        }
        if (!this.nameExpressionPanel.isExpressionValid()) {
            return DesignerMsg.INVALID_ATTRIBUTE_EXPRESSION(DesignerMsg.NAME.getString());
        }
        if (this.mimeTypeExpressionPanel.getExpression() == null) {
            return DesignerMsg.DYNAMIC_NOT_NULL(ProjectModelMsg.MIME_TYPE);
        }
        if (!this.mimeTypeExpressionPanel.isExpressionValid()) {
            return DesignerMsg.INVALID_ATTRIBUTE_EXPRESSION(ProjectModelMsg.MIME_TYPE.getString());
        }
        if (this.valueExpressionPanel.getExpression() == null) {
            return DesignerMsg.DYNAMIC_NOT_NULL(DesignerMsg.VALUE);
        }
        if (!this.valueExpressionPanel.isExpressionValid()) {
            return DesignerMsg.INVALID_ATTRIBUTE_EXPRESSION(DesignerMsg.VALUE.getString());
        }
        if (!this.encodingExpressionPanel.isExpressionValid()) {
            return DesignerMsg.INVALID_ATTRIBUTE_EXPRESSION(ProjectModelMsg.TRANSFER_ENCODING.getString());
        }
        return null;
    }

    protected void layoutControls(@NotNull UiContainer container) {
        container.setLayout((Layout)new MigLayout("ins 5, gap 5, fill"));
        container.add((UiComponent)Label.create((UiContainer)container, (Msg)DesignerMsg.NAME));
        ExpressionContext nameExpressionContext = this.createExpressionContext(this.context, MailNotificationAttachment.ResultType.getName());
        this.nameExpressionPanel = ExpressionPanelFactory.createNotificationPropertyPanel(container, nameExpressionContext, false);
        container.add(this.nameExpressionPanel.getUiComponent(), (Object)"growx, wrap");
        container.add((UiComponent)Label.create((UiContainer)container, (Msg)ProjectModelMsg.MIME_TYPE));
        ExpressionContext mimeTypeExpressionContext = this.createExpressionContext(this.context, MailNotificationAttachment.ResultType.getMimeType());
        this.mimeTypeExpressionPanel = ExpressionPanelFactory.createNotificationPropertyPanel(container, mimeTypeExpressionContext, false);
        container.add(this.mimeTypeExpressionPanel.getUiComponent(), (Object)"growx, wrap");
        container.add((UiComponent)Label.create((UiContainer)container, (Msg)ProjectModelMsg.TRANSFER_ENCODING));
        ExpressionContext encodingExpressionContext = this.createExpressionContext(this.context, MailNotificationAttachment.ResultType.getEncoding());
        this.encodingExpressionPanel = ExpressionPanelFactory.createNotificationPropertyPanel(container, encodingExpressionContext, false);
        container.add(this.encodingExpressionPanel.getUiComponent(), (Object)"growx, wrap");
        container.add((UiComponent)Label.create((UiContainer)container, (Msg)DesignerMsg.VALUE), (Object)"gapy 5, aligny top");
        ExpressionContext valueExpressionContext = this.createExpressionContext(this.context, MailNotificationAttachment.ResultType.getValue());
        this.valueExpressionPanel = ExpressionPanelFactory.createNotificationPropertyPanel(container, valueExpressionContext, true);
        container.add(this.valueExpressionPanel.getUiComponent(), (Object)"grow, wrap");
        this.setSize(400, 200);
        this.setLocationRelativeTo((UiComponent)this.getParent());
    }

    protected boolean mustCreateAlways() {
        return true;
    }

    private ExpressionContext createExpressionContext(@NotNull DataDeclarationContainer context, @NotNull CatalogType resultType) {
        return new ExpressionContext(context, resultType);
    }

    private boolean attachmentNameExists(@NotNull Expression nameExpression) {
        Sequence attachments = this.mailNotificationDefinition.getAttachments();
        for (MailNotificationAttachment attachment : attachments) {
            if (!attachment.getName().equals(nameExpression)) continue;
            return true;
        }
        return false;
    }
}

