/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.notification;

import oracle.bpm.designer.expression.ExpressionContainerListener;
import oracle.bpm.designer.expression.ExpressionPanel;
import oracle.bpm.designer.identity.LookupDialog;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.notification.NotificationDefinitionPanel;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.notification.IMNotificationDefinition;
import oracle.bpm.project.model.processes.notification.NotificationDefinition;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.TabbedPane;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import org.jetbrains.annotations.NotNull;

class IMNotificationDefinitionPanel
extends NotificationDefinitionPanel {
    private ExpressionPanel bodyExpressionPanel;
    private ExpressionPanel toExpressionPanel;

    protected IMNotificationDefinitionPanel(@NotNull UiContainer parent, @NotNull IMNotificationDefinition imNotificationDefinition) {
        super(parent, (NotificationDefinition)imNotificationDefinition);
        this.init();
    }

    @Override
    public boolean isValid() {
        return this.toExpressionPanel.isExpressionValid() && this.bodyExpressionPanel.isExpressionValid();
    }

    protected IMNotificationDefinition getNotificationDefinition() {
        return (IMNotificationDefinition)super.getNotificationDefinition();
    }

    private void init() {
        this.setLayout((Layout)new BorderLayout());
        TabbedPane tabbedPane = new TabbedPane((UiContainer)this);
        this.add((UiComponent)tabbedPane, "Center");
        Panel generalPanel = new Panel((UiContainer)tabbedPane);
        generalPanel.setLayout((Layout)new MigLayout("ins 10, gap 0, fillx"));
        ExpressionContext toExpressionContext = new ExpressionContext(this.getExpressionContext(), IMNotificationDefinition.ResultType.getTo());
        this.toExpressionPanel = this.createAndAddExpressionPanel((UiContainer)generalPanel, ProjectModelMsg.TO, toExpressionContext, this.getNotificationDefinition().getTo(), false, LookupDialog.LookupDialogType.IM_ID);
        this.toExpressionPanel.addListener(new ExpressionContainerListener(){

            @Override
            public void expressionChanged() {
                IMNotificationDefinitionPanel.this.getNotificationDefinition().setTo(IMNotificationDefinitionPanel.this.toExpressionPanel.getExpression());
            }
        });
        ExpressionContext messageExpressionContext = new ExpressionContext(this.getExpressionContext(), IMNotificationDefinition.ResultType.getBody());
        this.bodyExpressionPanel = this.createAndAddExpressionPanel((UiContainer)generalPanel, ProjectModelMsg.BODY, messageExpressionContext, this.getNotificationDefinition().getBody(), true, null);
        this.bodyExpressionPanel.addListener(new ExpressionContainerListener(){

            @Override
            public void expressionChanged() {
                IMNotificationDefinitionPanel.this.getNotificationDefinition().setBody(IMNotificationDefinitionPanel.this.bodyExpressionPanel.getExpression());
            }
        });
        tabbedPane.addTab(DesignerMsg.GENERAL.getString(), (UiComponent)generalPanel);
    }
}

