/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.navigator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.bpm.collections.Predicate;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.navigator.NavigatorActions;
import oracle.bpm.designer.navigator.ProjectNavigatorDialog;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.view.filter.ConfigurableProjectFilter;
import oracle.bpm.project.view.filter.ProjectFilter;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.action.BaseAction;
import org.jetbrains.annotations.NotNull;

public class ProjectNavigatorBuilder {
    private List<BaseAction> actions = new ArrayList<BaseAction>();
    private ProjectNavigatorDialog dialog;
    private ProjectFilter filter;
    private ProjectObject initialSelection;
    private LabelProvider<ProjectObject> navigatorStatusLabelProvider;
    private ProjectObject root;
    private boolean showRoot;
    private Msg title = DesignerMsg.TYPE;

    public ProjectNavigatorBuilder(ProjectObject root, Msg title) {
        this.root = root;
        this.title = title;
    }

    public ProjectNavigatorBuilder addAction(BaseAction action) {
        this.actions.add(action);
        return this;
    }

    public ProjectNavigatorBuilder setNavigatorStatusLabelProvider(@NotNull LabelProvider<ProjectObject> navigatorStatusLabelProvider) {
        this.navigatorStatusLabelProvider = navigatorStatusLabelProvider;
        return this;
    }

    public ProjectNavigatorBuilder showRoot() {
        this.showRoot = true;
        return this;
    }

    public ProjectNavigatorBuilder hideRoot() {
        this.showRoot = false;
        return this;
    }

    public ProjectNavigatorBuilder filter(ProjectFilter filter) {
        if (this.filter != null) {
            throw new IllegalStateException("Filter already defined");
        }
        this.filter = filter;
        return this;
    }

    public ProjectNavigatorBuilder include(Class<? extends ProjectObject> cl) {
        this.configurableFilter().addIncluded(cl);
        return this;
    }

    public ProjectNavigatorBuilder include(Predicate<ProjectObject> predicate) {
        this.configurableFilter().addIncluded(predicate);
        return this;
    }

    public ProjectNavigatorBuilder exclude(Class<? extends ProjectObject> cl) {
        this.configurableFilter().addExcluded(cl);
        return this;
    }

    public ProjectNavigatorBuilder exclude(Predicate<ProjectObject> predicate) {
        this.configurableFilter().addExcluded(predicate);
        return this;
    }

    public ProjectNavigatorBuilder initialSelection(ProjectObject projectObject) {
        this.initialSelection = projectObject;
        return this;
    }

    public <T extends ProjectObject> T selectSingle(Class<T> expectedClass) {
        return this.selectSingle(expectedClass, null);
    }

    public <T extends ProjectObject> T selectSingle(Class<T> expectedClass, Predicate<T> predicate) {
        this.dialog = this.createDialog(Ui.getRoot());
        return this.dialog.selectSingle(expectedClass, predicate);
    }

    public <T extends ProjectObject> Collection<T> selectMultiple(Class<T> expectedClass) {
        return this.selectMultiple(expectedClass, null);
    }

    public <T extends ProjectObject> Collection<T> selectMultiple(Class<T> expectedClass, Predicate<T> predicate) {
        this.dialog = this.createDialog(Ui.getRoot());
        return this.dialog.selectMultiple(expectedClass, predicate);
    }

    public void refresh() {
        if (this.dialog != null) {
            this.dialog.refresh();
        }
    }

    public void selectOnTree(ProjectObject newlyCreated) {
        if (this.dialog != null) {
            this.dialog.select(newlyCreated);
        }
    }

    protected ToolBar buildToolBarPanel(UiContainer parent, List<BaseAction> actions, NavigatorActions navigatorActions) {
        ToolBar toolBar = null;
        if (!actions.isEmpty()) {
            toolBar = new ToolBar(parent);
            for (BaseAction action : actions) {
                toolBar.add(action);
            }
        }
        return toolBar;
    }

    private ConfigurableProjectFilter configurableFilter() {
        if (this.filter == null) {
            this.filter = new ConfigurableProjectFilter();
        }
        return (ConfigurableProjectFilter)this.filter;
    }

    private ProjectNavigatorDialog createDialog(UiWindow parent) {
        LabelProvider<ProjectObject> statusLabelProvider = this.navigatorStatusLabelProvider;
        if (statusLabelProvider == null) {
            statusLabelProvider = this.createDefaultNavigatorStatusLabelProvider();
        }
        ProjectNavigatorDialog dialog = new ProjectNavigatorDialog(parent, this.title, this.root, this.filter, this.showRoot, this.actions, statusLabelProvider){

            @Override
            protected ToolBar buildToolBarPanel(UiContainer parent, List<BaseAction> actions, NavigatorActions navigatorActions) {
                return ProjectNavigatorBuilder.this.buildToolBarPanel(parent, actions, navigatorActions);
            }
        };
        if (this.initialSelection != null) {
            dialog.select(this.initialSelection);
        }
        return dialog;
    }

    private LabelProvider<ProjectObject> createDefaultNavigatorStatusLabelProvider() {
        return new LabelProvider.Default<ProjectObject>(){

            public String getText(ProjectObject po) {
                return po != null ? String.valueOf(po.getPath()) : "";
            }
        };
    }
}

