/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.messageheaders;

import java.util.ArrayList;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.renderers.DataDeclarationRenderer;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.messageheaders.MessageHeader;
import oracle.bpm.project.model.processes.messageheaders.MessageHeaderSet;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.ListPicker;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;

class MessageHeadersPanel
extends Panel {
    private ListPicker<DataDeclaration> listPicker;
    private MessageHeaderSet messageHeaderSet;

    public MessageHeadersPanel(UiContainer parent, MessageHeaderSet messageHeaderSet) {
        super(parent);
        this.messageHeaderSet = messageHeaderSet;
        this.init();
    }

    Msg validateInput() {
        return this.listPicker.hasInvalidSelection() ? DesignerMsg.INVALID_NAME : null;
    }

    void applyChanges() throws ProjectException {
        this.messageHeaderSet.clearMessageHeaders();
        for (DataDeclaration dataDeclaration : this.listPicker.getSelectedItems()) {
            MessageHeader messageHeader = this.messageHeaderSet.createMessageHeader(dataDeclaration.getName());
            this.messageHeaderSet.addMessageHeader(messageHeader);
        }
    }

    private void init() {
        this.setLayout((Layout)new MigLayout("ins 5, gap 5, fill"));
        this.listPicker = new ListPicker((UiContainer)this, DesignerMsg.VALID_VALUES);
        this.listPicker.setItems(CollectionUtils.toList(this.messageHeaderSet.getMessageHeadersDeclarations()));
        this.listPicker.setSelectedItems(this.getSelectedDeclarations());
        this.listPicker.setLabelProvider(this.createDataDeclarationLabelProvider());
        this.add((UiComponent)this.listPicker, "spanx, grow");
    }

    private ArrayList<DataDeclaration> getSelectedDeclarations() {
        ArrayList<DataDeclaration> selectedItems = new ArrayList<DataDeclaration>();
        DataDeclarationContainer context = this.messageHeaderSet.getContext();
        Sequence messageHeaders = this.messageHeaderSet.getMessageHeaders();
        for (MessageHeader messageHeader : messageHeaders) {
            DataDeclaration source = context.findDeclaration(messageHeader.getName());
            if (source == null) continue;
            selectedItems.add(source);
        }
        return selectedItems;
    }

    private LabelProvider<DataDeclaration> createDataDeclarationLabelProvider() {
        return new LabelProvider<DataDeclaration>(){
            private DataDeclarationRenderer renderer = new DataDeclarationRenderer();

            public Image getIcon(DataDeclaration element) {
                return this.renderer.getIcon(element);
            }

            public String getText(DataDeclaration element) {
                return this.renderer.getLabel(element);
            }
        };
    }
}

