/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.messageheaders;

import oracle.bpm.designer.messageheaders.MessageHeadersPanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.messageheaders.InputMessageHeadersEnabled;
import oracle.bpm.project.model.processes.messageheaders.MessageHeadersEnabled;
import oracle.bpm.project.model.processes.messageheaders.OutputMessageHeadersEnabled;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.TabbedPane;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;

public class MessageHeadersDialog
extends OkCancelDialog {
    private MessageHeadersPanel inputMessageHeadersPanel;
    private MessageHeadersEnabled messages;
    private MessageHeadersPanel outputMessageHeadersPanel;

    public MessageHeadersDialog(@NotNull UiWindow parent, @NotNull MessageHeadersEnabled messages) {
        super(parent, DesignerMsg.MESSAGE_HEADERS);
        this.messages = messages;
        this.init();
    }

    public void ok() {
        boolean ok = true;
        if (this.inputMessageHeadersPanel != null) {
            ok = this.isOk(this.inputMessageHeadersPanel);
        }
        if (ok && this.outputMessageHeadersPanel != null) {
            ok = this.isOk(this.outputMessageHeadersPanel);
        }
        if (ok) {
            try {
                if (this.inputMessageHeadersPanel != null) {
                    this.inputMessageHeadersPanel.applyChanges();
                }
                if (this.outputMessageHeadersPanel != null) {
                    this.outputMessageHeadersPanel.applyChanges();
                }
                this.close();
            }
            catch (ProjectException e) {
                MessageDialog.showError((UiContainer)this, (Throwable)e);
            }
        }
    }

    private boolean isOk(MessageHeadersPanel messageHeadersPanel) {
        boolean result = true;
        Msg errorMessage = messageHeadersPanel.validateInput();
        if (errorMessage != null) {
            result = false;
            MessageDialog.showError((UiContainer)this, (Msg)errorMessage);
        }
        return result;
    }

    private void init() {
        UiContainer panel = this.getContentPane();
        panel.setLayout((Layout)new MigLayout("ins 5, gap 5, fill"));
        TabbedPane tabbedPane = new TabbedPane(panel);
        if (this.messages.isInputMessageHeadersEnable()) {
            InputMessageHeadersEnabled input = (InputMessageHeadersEnabled)this.messages.asAnyNode(InputMessageHeadersEnabled.class);
            this.inputMessageHeadersPanel = new MessageHeadersPanel((UiContainer)this, input.getInputMessageHeaderSet());
            tabbedPane.addTab(DesignerMsg.INPUT, (UiComponent)this.inputMessageHeadersPanel);
        }
        if (this.messages.isOutputMessageHeadersEnable()) {
            OutputMessageHeadersEnabled output = (OutputMessageHeadersEnabled)this.messages.asAnyNode(OutputMessageHeadersEnabled.class);
            this.outputMessageHeadersPanel = new MessageHeadersPanel((UiContainer)this, output.getOutputMessageHeaderSet());
            tabbedPane.addTab(DesignerMsg.OUTPUT, (UiComponent)this.outputMessageHeadersPanel);
        }
        panel.add((UiComponent)tabbedPane, (Object)"grow");
        this.setSize(600, 400);
        this.setLocationRelativeTo((UiComponent)this.getParent());
    }
}

