/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.measurementmark;

import java.util.ArrayList;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.variables.BusinessIndicatorsPanel;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.project.kpi.BamActionImpl;
import oracle.bpm.project.kpi.BamAdapterJNDIName;
import oracle.bpm.project.model.kpi.KeyPerformanceIndicatorsContainer;
import oracle.bpm.project.model.kpi.MeasurementAction;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.EditionPanel;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.TabbedPane;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.forms.FormsFactory;
import oracle.bpm.ui.forms.RowForm;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.text.TextField;

public class keyPerformanceIndicatorPropertiesPanel
extends EditionPanel {
    private ComboBox<String> bamAdapterComboBox;
    private TextField dataObjectPathTextField;
    private CheckBox enableBamCheckBox;
    private CheckBox enableCubesCheckBox;
    private CheckBox httpsDeployCheckbox;
    private CheckBox inBatchCheckBox;
    private KeyPerformanceIndicatorsContainer keyPerformanceIndicatorContainer;

    public keyPerformanceIndicatorPropertiesPanel(UiContainer parent, KeyPerformanceIndicatorsContainer keyPerformanceIndicatorsContainer) {
        super(parent, DesignerMsg.PROCESS_ANALYTICS_SUMMARY);
        this.keyPerformanceIndicatorContainer = keyPerformanceIndicatorsContainer;
        this.buildUi();
    }

    public void applyChanges() {
        BamActionImpl bamAction = this.getBamAction();
        bamAction.setEnable(this.enableBamCheckBox.isSelected());
        bamAction.setBamAdapterJNDIName((String)this.bamAdapterComboBox.getSelectedItem());
        bamAction.setInBatch(this.inBatchCheckBox.isSelected());
        bamAction.setDataObjectPath(this.dataObjectPathTextField.getText());
        bamAction.setUseHTTPS(this.httpsDeployCheckbox.isSelected());
        this.getCubeAction().setEnable(this.enableCubesCheckBox.isSelected());
    }

    private void buildUi() {
        this.setLayout((Layout)new BorderLayout());
        TabbedPane kpiPropertiesTabbedPane = new TabbedPane((UiContainer)this, 1);
        kpiPropertiesTabbedPane.addTab(ProjectMsg.BUSINESS_INDICATORS, (UiComponent)new BusinessIndicatorsPanel((UiContainer)kpiPropertiesTabbedPane, this.keyPerformanceIndicatorContainer.getProject()));
        kpiPropertiesTabbedPane.addTab(DesignerMsg.DATA_TARGETS, this.buildDataTargetsPanel((UiContainer)kpiPropertiesTabbedPane));
        this.add((UiComponent)kpiPropertiesTabbedPane, "Center");
    }

    private UiComponent buildDataTargetsPanel(UiContainer parent) {
        Panel dataTargetsPanel = new Panel(parent);
        dataTargetsPanel.setLayout((Layout)new BorderLayout());
        Panel actionsCheckBoxPanel = new Panel((UiContainer)dataTargetsPanel);
        RowForm actionsCheckboxForm = FormsFactory.createRowForm((UiContainer)actionsCheckBoxPanel);
        this.enableCubesCheckBox = CheckBox.create((UiContainer)actionsCheckBoxPanel, (Msg)DesignerMsg.ENABLE_CUBES);
        this.enableCubesCheckBox.setSelected(this.getCubeAction().isEnable());
        this.enableBamCheckBox = CheckBox.create((UiContainer)actionsCheckBoxPanel, (Msg)DesignerMsg.ENABLE_BAM);
        this.enableBamCheckBox.setSelected(this.getBamAction().isEnable());
        this.enableBamCheckBox.addModificationListener(new ModificationListener(){

            public void objectModified(ModificationEvent event) {
                keyPerformanceIndicatorPropertiesPanel.this.enableBamPanel(keyPerformanceIndicatorPropertiesPanel.this.enableBamCheckBox.isSelected());
            }
        });
        actionsCheckboxForm.add((UiComponent)this.enableCubesCheckBox);
        actionsCheckboxForm.add((UiComponent)this.enableBamCheckBox);
        TabbedPane actionsTabbedPane = new TabbedPane((UiContainer)dataTargetsPanel, 1);
        actionsTabbedPane.addTab(DesignerMsg.BAM, this.buildBamPanel((UiContainer)actionsTabbedPane));
        dataTargetsPanel.add((UiComponent)actionsCheckBoxPanel, (Object)"North");
        dataTargetsPanel.add((UiComponent)actionsTabbedPane, (Object)"Center");
        return dataTargetsPanel;
    }

    private UiComponent buildCubesPanel(UiContainer parent) {
        return new Panel(parent);
    }

    private UiComponent buildBamPanel(UiContainer parent) {
        BamAdapterJNDIName[] bamAdapterJNDINames;
        Panel bamPanel = new Panel(parent);
        bamPanel.setLayout((Layout)new MigLayout());
        ArrayList<String> l = new ArrayList<String>();
        for (BamAdapterJNDIName bamAdapterJNDIName : bamAdapterJNDINames = BamAdapterJNDIName.values()) {
            l.add(bamAdapterJNDIName.getDescription());
        }
        String adapter = this.getBamAction().getBamAdapterJNDIName();
        if (!l.contains(adapter)) {
            l.add(adapter);
        }
        this.bamAdapterComboBox = UiFactory.createComboBox((UiContainer)bamPanel, (boolean)true, (Object[])l.toArray(new String[0]));
        this.bamAdapterComboBox.setSelectedItem((Object)adapter);
        this.inBatchCheckBox = CheckBox.create((UiContainer)bamPanel, (Msg)DesignerMsg.IN_BATCH);
        this.inBatchCheckBox.setSelected(this.getBamAction().isInBatch());
        this.dataObjectPathTextField = new TextField((UiContainer)bamPanel);
        this.dataObjectPathTextField.setText(this.getBamAction().getDataObjectPath());
        this.httpsDeployCheckbox = CheckBox.create((UiContainer)bamPanel, (Msg)DesignerMsg.HTTPS_FOR_BAM_DEPLOYMENT);
        this.httpsDeployCheckbox.setSelected(this.getBamAction().isUseHTTPS());
        this.enableBamPanel(this.enableBamCheckBox.isSelected());
        bamPanel.add((UiComponent)Label.create((UiContainer)bamPanel, (Msg)DesignerMsg.BAM_ADAPTER_JNDI_NAME));
        bamPanel.add(this.bamAdapterComboBox, (Object)"grow, wrap");
        bamPanel.add((UiComponent)this.inBatchCheckBox, (Object)"wrap");
        bamPanel.add((UiComponent)Label.create((UiContainer)bamPanel, (Msg)DesignerMsg.DATA_OBJECT_PATH));
        bamPanel.add((UiComponent)this.dataObjectPathTextField, (Object)"width pref+30lp, wrap");
        bamPanel.add((UiComponent)this.httpsDeployCheckbox, (Object)"span 2");
        return bamPanel;
    }

    private void enableBamPanel(boolean isEnable) {
        this.bamAdapterComboBox.setEnabled(isEnable);
        this.inBatchCheckBox.setEnabled(isEnable);
        this.dataObjectPathTextField.setEnabled(isEnable);
        this.httpsDeployCheckbox.setEnabled(isEnable);
    }

    private BamActionImpl getBamAction() {
        return (BamActionImpl)this.keyPerformanceIndicatorContainer.getActionsContainer().findChild(BamActionImpl.class, "BAMCommand");
    }

    private MeasurementAction getCubeAction() {
        return (MeasurementAction)this.keyPerformanceIndicatorContainer.getActionsContainer().findChild(MeasurementAction.class, "CubeCommand");
    }
}

