/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.measurementmark;

import oracle.bpm.designer.measurementmark.CounterPropertiesDialog;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.Counter;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.action.BaseAction;

public class NewCounterAction
extends BaseAction {
    private Activity activity;
    private static final String SUGGESTED_COUNTER_NAME = "Counter";

    public NewCounterAction(Activity activity) {
        super(DesignerMsg.NEW_COUNTER);
        this.requires(Activity.class);
        this.activity = activity;
    }

    public void run() {
        Counter counter = this.activity.getProcess().createCounter(this.getNextId());
        counter.setActivity(this.activity);
        try {
            CounterPropertiesDialog counterPropertiesDialog = new CounterPropertiesDialog(Ui.getRoot(), counter);
            counterPropertiesDialog.setVisible(true);
            if (counterPropertiesDialog.userAccepted()) {
                this.activity.getProcess().addCounter(counter);
            }
            counterPropertiesDialog.setVisible(false);
        }
        catch (ProjectException e) {
            MessageDialog.showError((Throwable)e);
        }
    }

    private String getNextId() {
        int i = 1;
        String suggestedName = SUGGESTED_COUNTER_NAME;
        while (this.isProjectObjectExists(suggestedName)) {
            suggestedName = SUGGESTED_COUNTER_NAME + i;
            ++i;
        }
        return suggestedName;
    }

    private boolean isProjectObjectExists(String suggestedName) {
        for (Counter counter : this.activity.getProcess().getCounters()) {
            if (!counter.getId().equals(suggestedName)) continue;
            return true;
        }
        return false;
    }
}

