/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.measurementmark;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.data.BusinessVariableType;
import oracle.bpm.data.MeasurementType;
import oracle.bpm.designer.DesignerResources;
import oracle.bpm.designer.ProjectObjectEditorPanel;
import oracle.bpm.designer.action.NewBusinessIndicatorAction;
import oracle.bpm.designer.measurementmark.BusinessIndicatorComparator;
import oracle.bpm.designer.measurementmark.BusinessIndicatorsLabelProvider;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.MeasurementImpl;
import oracle.bpm.project.compile.exceptions.MeasurementHasNoStartException;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.events.ProjectListener;
import oracle.bpm.project.model.events.ProjectListenerAdapter;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Measurement;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.AbstractButton;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.ButtonGroup;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.ListSelectionMode;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.RadioButton;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.forms.FormsFactory;
import oracle.bpm.ui.forms.StandardForm;
import oracle.bpm.ui.layout.AttributeConstraint;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.CardLayout;
import oracle.bpm.ui.layout.Constraint;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.RelativeLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.TextArea;
import oracle.bpm.ui.text.TextComponent;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.util.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MeasurementMarkPanel
extends ProjectObjectEditorPanel<Measurement> {
    private Button assignAllBIButton;
    private Button assignBIButton;
    private oracle.bpm.ui.List<ProjectDataObject> assignedBIList;
    private Set<ProjectDataObject> assignedBusinessIndicators;
    private LabelProvider businessIndicatorsLabelProvider = new BusinessIndicatorsLabelProvider();
    private CardLayout cardLayout;
    private Process content;
    private LocaleStringMap description;
    private TextArea descriptionArea;
    private Label idField;
    private ItemListener itemListener;
    private LocaleStringMap label;
    private TextField labelField;
    private Panel nameAndStartMeasurementPanel;
    private Button newBIButton;
    private ProjectListener<ProjectDataObject> projectDataObjectListener;
    private RadioButton startButton;
    private ComboBox<Measurement> startMeasurementsCombo;
    private RadioButton startStopButton;
    private RadioButton stopButton;
    private Button unassignAllBIButton;
    private Button unassignBIButton;
    private oracle.bpm.ui.List<ProjectDataObject> unassignedBIList;
    private Set<ProjectDataObject> unassignedBusinessIndicators;
    private static final int PREFERRED_COLUMNS = 45;
    private static final int PREFERRED_ROWS = 5;

    public MeasurementMarkPanel(UiContainer parent, @NotNull Measurement measurement) {
        super(parent, measurement);
        this.content = measurement.getProcess();
        this.unassignedBusinessIndicators = new TreeSet<ProjectDataObject>(new BusinessIndicatorComparator());
        this.assignedBusinessIndicators = new TreeSet<ProjectDataObject>(new BusinessIndicatorComparator());
        this.loadBusinessIndicatorsLists(measurement);
        this.build();
        this.addProjectDataObjectListener();
    }

    @Override
    public void objectToEditor(Measurement measurement) {
    }

    @Override
    public Measurement editorToObject() throws ProjectException {
        ((Measurement)this.getProjectObject()).getProject().removeListener(this.projectDataObjectListener);
        Measurement measurement = (Measurement)this.getProjectObject();
        measurement.setId(this.idField.getText());
        measurement.setMeasurementType(this.startButton.isSelected() ? MeasurementType.START : (this.stopButton.isSelected() ? MeasurementType.STOP : MeasurementType.START_STOP));
        if (measurement.getMeasurementType() == MeasurementType.STOP) {
            measurement.setRelatedMeasurement((Measurement)this.startMeasurementsCombo.getSelectedItem());
        } else {
            measurement.setDefaultLabel(this.labelField.getText());
        }
        measurement.setDefaultDescription(this.descriptionArea.getText());
        for (ProjectDataObject unnasignedBusinessIndicator : this.unassignedBusinessIndicators) {
            if (!measurement.containsBusinessIndicator(unnasignedBusinessIndicator)) continue;
            measurement.removeBusinessIndicator(unnasignedBusinessIndicator);
        }
        for (ProjectDataObject assignedBusinessIndicator : this.assignedBusinessIndicators) {
            if (measurement.containsBusinessIndicator(assignedBusinessIndicator)) continue;
            measurement.addBusinessIndicator(assignedBusinessIndicator);
        }
        return measurement;
    }

    public Process getContent() {
        return this.content;
    }

    @Override
    public void validateEditor() throws ProjectException {
        if (this.stopButton.isSelected() && this.startMeasurementsCombo.getSelectedItem() == null) {
            throw new MeasurementHasNoStartException((Measurement)this.getProjectObject());
        }
    }

    protected void onDispose() {
        this.removeProjectDataObjectListener();
    }

    Panel buildNamePanel(UiContainer parent) {
        this.backupLocalizables();
        Panel namePanel = new Panel(parent);
        RelativeLayout layout = new RelativeLayout();
        namePanel.setLayout((Layout)layout);
        Label nameLabel = Label.create((UiContainer)namePanel, (Msg)ProjectDrawMsg.NAME);
        this.labelField = new TextField((UiContainer)namePanel);
        this.labelField.setText(((Measurement)this.getProjectObject()).getDefaultLabel());
        if (((Measurement)this.getProjectObject()).getId() != null && !"".equals(((Measurement)this.getProjectObject()).getId())) {
            this.idField.setText(((Measurement)this.getProjectObject()).getId());
        }
        if (((Measurement)this.getProjectObject()).getLabelMap() != null) {
            this.labelField.setText(((Measurement)this.getProjectObject()).getDefaultLabel());
        }
        namePanel.add((UiComponent)nameLabel, (Object)"nameLabel");
        namePanel.add((UiComponent)this.labelField, (Object)"labelField");
        DesignerResources.LocalizationButton localizeLabelButton = DesignerResources.buildLocalizationButton(((Measurement)this.getProjectObject()).getProject(), (UiContainer)namePanel, this.label, (TextComponent)this.labelField, DesignerMsg.LOCALIZE_LABEL.getString());
        namePanel.add((UiComponent)localizeLabelButton, (Object)"localizeButton");
        layout.addConstraint("nameLabel", AttributeType.TOP, (Constraint)new AttributeConstraint("_container", AttributeType.TOP));
        layout.addConstraint("nameLabel", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT));
        layout.addConstraint("labelField", AttributeType.TOP, (Constraint)new AttributeConstraint("_container", AttributeType.TOP, 20));
        layout.addConstraint("labelField", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT));
        layout.addConstraint("labelField", AttributeType.RIGHT, (Constraint)new AttributeConstraint("_container", AttributeType.RIGHT, -35));
        layout.addConstraint("localizeButton", AttributeType.TOP, (Constraint)new AttributeConstraint("_container", AttributeType.TOP, 20));
        layout.addConstraint("localizeButton", AttributeType.LEFT, (Constraint)new AttributeConstraint("labelField", AttributeType.RIGHT, 5));
        layout.addConstraint("localizeButton", AttributeType.RIGHT, (Constraint)new AttributeConstraint("_container", AttributeType.RIGHT));
        return namePanel;
    }

    Panel buildMainPanel(UiContainer parent) {
        Panel centerPanel = new Panel(parent, UIMsg.TO_MSG((String)""));
        StandardForm layout = FormsFactory.createStandardForm((UiContainer)centerPanel);
        Label measurementTypeLabel = Label.create((UiContainer)centerPanel, (Msg)DesignerMsg.MARK_TYPE);
        Panel measurementTypePanel = this.buildMeasurementTypePanel(centerPanel);
        this.idField = Label.createWithNoColon((UiContainer)centerPanel, (Msg)Msg.QUOTE(((Measurement)this.getProjectObject()).getId()));
        this.idField.setFont(this.idField.getFont().italic());
        Panel andInitialPanel = this.buildNameAndInitialPanel(centerPanel);
        Panel descPanel = this.buildDescPanel((UiContainer)centerPanel);
        Label businessIndicatorsLabel = Label.create((UiContainer)centerPanel, (Msg)ProjectMsg.BUSINESS_INDICATORS);
        Panel businessIndicatorPanelPanel = this.buildBusinessIndicatorPanel(centerPanel);
        layout.add((UiComponent)measurementTypeLabel);
        layout.add((UiComponent)measurementTypePanel);
        layout.add((UiComponent)andInitialPanel);
        layout.add(CoreMsg.ID, (UiComponent)this.idField);
        layout.add((UiComponent)descPanel);
        layout.add((UiComponent)businessIndicatorsLabel);
        layout.add((UiComponent)businessIndicatorPanelPanel);
        this.startStopButton.setSelected(((Measurement)this.getProjectObject()).getMeasurementType() == MeasurementType.START_STOP);
        this.startButton.setSelected(((Measurement)this.getProjectObject()).getMeasurementType() == MeasurementType.START);
        this.stopButton.setSelected(((Measurement)this.getProjectObject()).getMeasurementType() == MeasurementType.STOP);
        return centerPanel;
    }

    private void build() {
        this.setLayout((Layout)new BorderLayout());
        Panel centerPanel = this.buildMainPanel((UiContainer)this);
        this.add((UiComponent)centerPanel, "Center");
    }

    private Panel buildMeasurementTypePanel(Panel centerPanel) {
        Panel measurementTypePanel = new Panel((UiContainer)centerPanel);
        StandardForm form = FormsFactory.createStandardForm((UiContainer)measurementTypePanel);
        ButtonGroup group = new ButtonGroup();
        this.startStopButton = new RadioButton((UiContainer)centerPanel, DesignerMsg.START_STOP);
        this.startButton = new RadioButton((UiContainer)centerPanel, DesignerMsg.START);
        this.stopButton = new RadioButton((UiContainer)centerPanel, DesignerMsg.STOP);
        this.startStopButton.addItemListener(this.getMeasurementTypeListener());
        this.startButton.addItemListener(this.getMeasurementTypeListener());
        this.stopButton.addItemListener(this.getMeasurementTypeListener());
        group.add((AbstractButton)this.startButton);
        group.add((AbstractButton)this.stopButton);
        group.add((AbstractButton)this.startStopButton);
        form.add((UiComponent)this.startStopButton);
        form.add((UiComponent)this.startButton);
        form.add((UiComponent)this.stopButton);
        return measurementTypePanel;
    }

    private Panel buildBusinessIndicatorPanel(Panel parent) {
        Panel businessIndicatorsPanel = new Panel((UiContainer)parent);
        RelativeLayout layout = new RelativeLayout();
        businessIndicatorsPanel.setLayout((Layout)layout);
        Label availableBILabel = Label.create((UiContainer)businessIndicatorsPanel, (Msg)DesignerMsg.AVAILABLE);
        this.unassignedBIList = oracle.bpm.ui.List.create((UiContainer)businessIndicatorsPanel, new ArrayList<ProjectDataObject>(this.unassignedBusinessIndicators), (ListSelectionMode)ListSelectionMode.MULTIPLE_INTERVAL_SELECTION);
        this.unassignedBIList.setLabelProvider(this.businessIndicatorsLabelProvider);
        this.assignBIButton = new Button((UiContainer)businessIndicatorsPanel);
        this.assignBIButton.setIcon(DesignerMsg.SHUTTLE_RIGHT);
        this.assignBIButton.addActionListener(this.getAssignBusinessIndicatorActionListener());
        this.assignAllBIButton = new Button((UiContainer)businessIndicatorsPanel);
        this.assignAllBIButton.setIcon(DesignerMsg.SHUTTLE_RIGHT_ALL);
        this.assignAllBIButton.addActionListener(this.getAssignAllBusinessIndicatorActionListener());
        this.unassignBIButton = new Button((UiContainer)businessIndicatorsPanel);
        this.unassignBIButton.setIcon(DesignerMsg.SHUTTLE_LEFT);
        this.unassignBIButton.addActionListener(this.getUnassignBusinessIndicatorActionListener());
        this.unassignAllBIButton = new Button((UiContainer)businessIndicatorsPanel);
        this.unassignAllBIButton.setIcon(DesignerMsg.SHUTTLE_LEFT_ALL);
        this.unassignAllBIButton.addActionListener(this.getUnassignAllBusinessIndicatorActionListener());
        Label selectedBILabel = Label.create((UiContainer)businessIndicatorsPanel, (Msg)DesignerMsg.SELECTED);
        this.assignedBIList = oracle.bpm.ui.List.create((UiContainer)businessIndicatorsPanel, new ArrayList<ProjectDataObject>(this.assignedBusinessIndicators), (ListSelectionMode)ListSelectionMode.MULTIPLE_INTERVAL_SELECTION);
        this.assignedBIList.setLabelProvider(this.businessIndicatorsLabelProvider);
        this.newBIButton = Button.createIconic((UiContainer)businessIndicatorsPanel, (Msg)DesignerMsg.ADD);
        this.newBIButton.addActionListener(this.getNewBIButtonActionListener());
        businessIndicatorsPanel.add((UiComponent)availableBILabel, (Object)"availableBILabel");
        businessIndicatorsPanel.add(this.unassignedBIList, (Object)"unassignedBIList");
        businessIndicatorsPanel.add((UiComponent)this.assignBIButton, (Object)"assignBIButton");
        businessIndicatorsPanel.add((UiComponent)this.assignAllBIButton, (Object)"assignAllBIButton");
        businessIndicatorsPanel.add((UiComponent)this.unassignBIButton, (Object)"unassignBIButton");
        businessIndicatorsPanel.add((UiComponent)this.unassignAllBIButton, (Object)"unassignAllBIButton");
        businessIndicatorsPanel.add((UiComponent)selectedBILabel, (Object)"selectedBILabel");
        businessIndicatorsPanel.add(this.assignedBIList, (Object)"assignedBIList");
        businessIndicatorsPanel.add((UiComponent)this.newBIButton, (Object)"newBIButton");
        layout.addConstraint("availableBILabel", AttributeType.TOP, (Constraint)new AttributeConstraint("_container", AttributeType.TOP));
        layout.addConstraint("availableBILabel", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT));
        layout.addConstraint("unassignedBIList", AttributeType.TOP, (Constraint)new AttributeConstraint("_container", AttributeType.TOP, 20));
        layout.addConstraint("unassignedBIList", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT));
        layout.addConstraint("assignBIButton", AttributeType.TOP, (Constraint)new AttributeConstraint("_container", AttributeType.TOP, 45));
        layout.addConstraint("assignBIButton", AttributeType.LEFT, (Constraint)new AttributeConstraint("unassignedBIList", AttributeType.RIGHT, 5));
        layout.addConstraint("assignAllBIButton", AttributeType.TOP, (Constraint)new AttributeConstraint("assignBIButton", AttributeType.BOTTOM, 5));
        layout.addConstraint("assignAllBIButton", AttributeType.LEFT, (Constraint)new AttributeConstraint("unassignedBIList", AttributeType.RIGHT, 5));
        layout.addConstraint("unassignBIButton", AttributeType.TOP, (Constraint)new AttributeConstraint("assignAllBIButton", AttributeType.BOTTOM, 5));
        layout.addConstraint("unassignBIButton", AttributeType.LEFT, (Constraint)new AttributeConstraint("unassignedBIList", AttributeType.RIGHT, 5));
        layout.addConstraint("unassignAllBIButton", AttributeType.TOP, (Constraint)new AttributeConstraint("unassignBIButton", AttributeType.BOTTOM, 5));
        layout.addConstraint("unassignAllBIButton", AttributeType.LEFT, (Constraint)new AttributeConstraint("unassignedBIList", AttributeType.RIGHT, 5));
        layout.addConstraint("selectedBILabel", AttributeType.TOP, (Constraint)new AttributeConstraint("_container", AttributeType.TOP));
        layout.addConstraint("selectedBILabel", AttributeType.LEFT, (Constraint)new AttributeConstraint("unassignAllBIButton", AttributeType.RIGHT, 5));
        layout.addConstraint("assignedBIList", AttributeType.TOP, (Constraint)new AttributeConstraint("_container", AttributeType.TOP, 20));
        layout.addConstraint("assignedBIList", AttributeType.LEFT, (Constraint)new AttributeConstraint("unassignAllBIButton", AttributeType.RIGHT, 5));
        layout.addConstraint("newBIButton", AttributeType.TOP, (Constraint)new AttributeConstraint("assignedBIList", AttributeType.BOTTOM, 5));
        layout.addConstraint("newBIButton", AttributeType.RIGHT, (Constraint)new AttributeConstraint("_container", AttributeType.RIGHT));
        return businessIndicatorsPanel;
    }

    private ActionListener getAssignBusinessIndicatorActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                for (ProjectDataObject selectedBusinessIndicator : MeasurementMarkPanel.this.unassignedBIList.getSelectedValues()) {
                    MeasurementMarkPanel.this.unassignedBusinessIndicators.remove(selectedBusinessIndicator);
                    MeasurementMarkPanel.this.assignedBusinessIndicators.add(selectedBusinessIndicator);
                }
                MeasurementMarkPanel.this.reloadBusinessIndicatorsLists(null);
            }
        };
    }

    private ActionListener getAssignAllBusinessIndicatorActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MeasurementMarkPanel.this.assignedBusinessIndicators.addAll(MeasurementMarkPanel.this.unassignedBusinessIndicators);
                MeasurementMarkPanel.this.unassignedBusinessIndicators.removeAll(MeasurementMarkPanel.this.unassignedBusinessIndicators);
                MeasurementMarkPanel.this.reloadBusinessIndicatorsLists(null);
            }
        };
    }

    private ActionListener getUnassignBusinessIndicatorActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                for (ProjectDataObject selectedBusinessIndicator : MeasurementMarkPanel.this.assignedBIList.getSelectedValues()) {
                    MeasurementMarkPanel.this.assignedBusinessIndicators.remove(selectedBusinessIndicator);
                    MeasurementMarkPanel.this.unassignedBusinessIndicators.add(selectedBusinessIndicator);
                }
                MeasurementMarkPanel.this.reloadBusinessIndicatorsLists(null);
            }
        };
    }

    private ActionListener getUnassignAllBusinessIndicatorActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MeasurementMarkPanel.this.unassignedBusinessIndicators.addAll(MeasurementMarkPanel.this.assignedBusinessIndicators);
                MeasurementMarkPanel.this.assignedBusinessIndicators.removeAll(MeasurementMarkPanel.this.assignedBusinessIndicators);
                MeasurementMarkPanel.this.reloadBusinessIndicatorsLists(null);
            }
        };
    }

    private ActionListener getNewBIButtonActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewBusinessIndicatorAction newDataObjectAction = NewBusinessIndicatorAction.createForMeasurement();
                newDataObjectAction.runWithSelection(((Measurement)MeasurementMarkPanel.this.getProjectObject()).getProject().getProjectModel());
            }
        };
    }

    private Panel buildNameAndInitialPanel(Panel centerPanel) {
        this.nameAndStartMeasurementPanel = new Panel((UiContainer)centerPanel);
        this.cardLayout = new CardLayout();
        this.nameAndStartMeasurementPanel.setLayout((Layout)this.cardLayout);
        Panel namePanel = this.buildNamePanel((UiContainer)this.nameAndStartMeasurementPanel);
        Panel startMeasurementPanel = this.buildStartMeasurementPanel((UiContainer)this.nameAndStartMeasurementPanel);
        this.nameAndStartMeasurementPanel.add((UiComponent)namePanel, (Object)"name");
        this.nameAndStartMeasurementPanel.add((UiComponent)startMeasurementPanel, (Object)"initial");
        this.cardLayout.addLayoutComponent((UiComponent)namePanel, (Object)"name");
        this.cardLayout.addLayoutComponent((UiComponent)startMeasurementPanel, (Object)"initial");
        this.checkNamePanelVisibility();
        return this.nameAndStartMeasurementPanel;
    }

    private Panel buildStartMeasurementPanel(UiContainer parent) {
        Panel startMeasurementPanel = new Panel(parent);
        RelativeLayout layout = new RelativeLayout();
        startMeasurementPanel.setLayout((Layout)layout);
        Label startMeasurementLabel = Label.create((UiContainer)startMeasurementPanel, (Msg)DesignerMsg.INITIAL_MEASUREMENTS);
        List<Measurement> measurementList = this.findStartMeasurements();
        this.startMeasurementsCombo = UiFactory.createMutableComboBox((UiContainer)startMeasurementPanel, measurementList);
        if (((Measurement)this.getProjectObject()).getRelatedMeasurement() != null) {
            this.startMeasurementsCombo.setSelectedItem((Object)((Measurement)this.getProjectObject()).getRelatedMeasurement());
        } else if (!measurementList.isEmpty()) {
            this.startMeasurementsCombo.setSelectedItem((Object)measurementList.get(0));
        }
        this.startMeasurementsCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                MeasurementImpl measurement = (MeasurementImpl)MeasurementMarkPanel.this.startMeasurementsCombo.getSelectedItem();
                if (measurement != null) {
                    MeasurementMarkPanel.this.reloadBusinessIndicatorsLists((Measurement)measurement);
                }
            }
        });
        startMeasurementPanel.add((UiComponent)startMeasurementLabel, (Object)"startMeasurementLabel");
        startMeasurementPanel.add(this.startMeasurementsCombo, (Object)"startMeasurementsCombo");
        layout.addConstraint("startMeasurementLabel", AttributeType.TOP, (Constraint)new AttributeConstraint("_container", AttributeType.TOP));
        layout.addConstraint("startMeasurementLabel", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT));
        layout.addConstraint("startMeasurementsCombo", AttributeType.TOP, (Constraint)new AttributeConstraint("_container", AttributeType.TOP, 20));
        layout.addConstraint("startMeasurementsCombo", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT, 2));
        layout.addConstraint("startMeasurementsCombo", AttributeType.RIGHT, (Constraint)new AttributeConstraint("_container", AttributeType.RIGHT, -2));
        return startMeasurementPanel;
    }

    private List<Measurement> findStartMeasurements() {
        Sequence<Measurement> measurementSequence = CollectionUtils.select(((Measurement)this.getProjectObject()).getParentObject().getDescendants(Measurement.class), new Predicate<Measurement>(){

            @Override
            public boolean check(@Nullable Measurement measurement) {
                return measurement != null && measurement.getMeasurementType() == MeasurementType.START;
            }
        });
        return ArrayUtils.asList(measurementSequence.toArray(new Measurement[0]));
    }

    private void reloadBusinessIndicatorsLists(Measurement measurement) {
        if (measurement != null) {
            this.assignedBusinessIndicators.clear();
            this.unassignedBusinessIndicators.clear();
            this.loadBusinessIndicatorsLists(measurement);
        }
        this.unassignedBIList.setListData((Object[])this.unassignedBusinessIndicators.toArray(new ProjectDataObject[this.unassignedBusinessIndicators.size()]));
        this.assignedBIList.setListData((Object[])this.assignedBusinessIndicators.toArray(new ProjectDataObject[this.assignedBusinessIndicators.size()]));
    }

    private void loadBusinessIndicatorsLists(Measurement measurement) {
        for (ProjectDataObject projectDataObject : measurement.getProject().getProjectDataObjects()) {
            if (!projectDataObject.isBusiness() || projectDataObject.getBusinessVariableType() != BusinessVariableType.MEASURE) continue;
            if (!measurement.containsBusinessIndicator(projectDataObject)) {
                this.unassignedBusinessIndicators.add(projectDataObject);
                continue;
            }
            this.assignedBusinessIndicators.add(projectDataObject);
        }
    }

    private Panel buildDescPanel(UiContainer parent) {
        Panel panel = new Panel(parent);
        RelativeLayout layout = new RelativeLayout();
        panel.setLayout((Layout)layout);
        Label descriptionLabel = Label.create((UiContainer)parent, (Msg)DesignerMsg.DESCRIPTION);
        this.descriptionArea = new TextArea((UiContainer)panel);
        this.descriptionArea.setLineWrap(true);
        this.descriptionArea.setRows(5);
        this.descriptionArea.setColumns(45);
        this.descriptionArea.setWrapStyleWord(true);
        this.descriptionArea.setText(((Measurement)this.getProjectObject()).getDefaultDescription());
        panel.add((UiComponent)descriptionLabel, (Object)"descriptionLabel");
        panel.add((UiComponent)this.descriptionArea, (Object)"descriptionField");
        panel.add((UiComponent)DesignerResources.buildLocalizationButton(((Measurement)this.getProjectObject()).getProject(), (UiContainer)panel, this.description, (TextComponent)this.descriptionArea, DesignerMsg.LOCALIZE_DESCRIPTION.getString(), true), (Object)"localizeButton");
        layout.addConstraint("descriptionLabel", AttributeType.TOP, (Constraint)new AttributeConstraint("_container", AttributeType.TOP));
        layout.addConstraint("descriptionLabel", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT));
        layout.addConstraint("descriptionField", AttributeType.TOP, (Constraint)new AttributeConstraint("_container", AttributeType.TOP, 20));
        layout.addConstraint("descriptionField", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT));
        layout.addConstraint("descriptionField", AttributeType.RIGHT, (Constraint)new AttributeConstraint("_container", AttributeType.RIGHT, -35));
        layout.addConstraint("localizeButton", AttributeType.TOP, (Constraint)new AttributeConstraint("_container", AttributeType.TOP, 20));
        layout.addConstraint("localizeButton", AttributeType.LEFT, (Constraint)new AttributeConstraint("descriptionField", AttributeType.RIGHT, 5));
        layout.addConstraint("localizeButton", AttributeType.RIGHT, (Constraint)new AttributeConstraint("_container", AttributeType.RIGHT));
        return panel;
    }

    private void addProjectDataObjectListener() {
        this.projectDataObjectListener = new ProjectListenerAdapter<ProjectDataObject>(ProjectDataObject.class){

            public void postObjectAdded(ProjectDataObject object, ProjectObject parent) {
                MeasurementMarkPanel.this.unassignedBusinessIndicators.add(object);
                MeasurementMarkPanel.this.reloadBusinessIndicatorsLists((Measurement)MeasurementMarkPanel.this.getProjectObject());
            }
        };
        ((Measurement)this.getProjectObject()).getProject().addListener(this.projectDataObjectListener);
    }

    private void removeProjectDataObjectListener() {
        ((Measurement)this.getProjectObject()).getProject().removeListener(this.projectDataObjectListener);
    }

    private void backupLocalizables() {
        this.description = ((Measurement)this.getProjectObject()).getDescriptionMap();
        this.label = ((Measurement)this.getProjectObject()).getLabelMap();
    }

    private ItemListener getMeasurementTypeListener() {
        if (this.itemListener == null) {
            this.itemListener = new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (MeasurementMarkPanel.this.stopButton.isSelected()) {
                        MeasurementMarkPanel.this.updateStartMeasurementsCombo();
                        MeasurementMarkPanel.this.reloadBusinessIndicatorsLists((Measurement)MeasurementMarkPanel.this.startMeasurementsCombo.getSelectedItem());
                        MeasurementMarkPanel.this.unassignedBIList.setEnabled(false);
                        MeasurementMarkPanel.this.assignBIButton.setEnabled(false);
                        MeasurementMarkPanel.this.assignAllBIButton.setEnabled(false);
                        MeasurementMarkPanel.this.unassignBIButton.setEnabled(false);
                        MeasurementMarkPanel.this.unassignAllBIButton.setEnabled(false);
                        MeasurementMarkPanel.this.newBIButton.setEnabled(false);
                        MeasurementMarkPanel.this.assignedBIList.setEnabled(false);
                    } else {
                        MeasurementMarkPanel.this.reloadBusinessIndicatorsLists((Measurement)MeasurementMarkPanel.this.getProjectObject());
                        MeasurementMarkPanel.this.unassignedBIList.setEnabled(true);
                        MeasurementMarkPanel.this.assignBIButton.setEnabled(true);
                        MeasurementMarkPanel.this.assignAllBIButton.setEnabled(true);
                        MeasurementMarkPanel.this.unassignBIButton.setEnabled(true);
                        MeasurementMarkPanel.this.unassignAllBIButton.setEnabled(true);
                        MeasurementMarkPanel.this.newBIButton.setEnabled(true);
                        MeasurementMarkPanel.this.assignedBIList.setEnabled(true);
                    }
                    MeasurementMarkPanel.this.checkNamePanelVisibility();
                }
            };
        }
        return this.itemListener;
    }

    private void checkNamePanelVisibility() {
        if (this.stopButton.isSelected()) {
            this.cardLayout.show((UiContainer)this.nameAndStartMeasurementPanel, "initial");
        } else {
            this.cardLayout.show((UiContainer)this.nameAndStartMeasurementPanel, "name");
        }
    }

    private void updateStartMeasurementsCombo() {
        this.startMeasurementsCombo.removeAllItems();
        List<Measurement> measurementList = this.findStartMeasurements();
        for (Measurement initialMeasurement : measurementList) {
            if (initialMeasurement == this.getProjectObject()) continue;
            this.startMeasurementsCombo.addItem((Object)initialMeasurement);
        }
        Measurement relatedMeasurement = ((Measurement)this.getProjectObject()).getRelatedMeasurement();
        if (this.startMeasurementsCombo.getItemCount() > 0 && relatedMeasurement == null) {
            this.startMeasurementsCombo.setSelectedItem((Object)0);
        } else {
            this.startMeasurementsCombo.setSelectedItem((Object)relatedMeasurement);
        }
    }
}

