/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.loghandler;

import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lib.Expression;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.project.compile.process.ExpressionHelper;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.processes.loghandlers.LogHandler;
import oracle.bpm.project.model.processes.loghandlers.LogHandlerSet;
import oracle.bpm.project.model.processes.loghandlers.LogHandlerTrigger;
import oracle.bpm.project.model.processes.loghandlers.Loggable;
import oracle.bpm.ui.table.ProviderTableModel;
import org.jetbrains.annotations.NotNull;

public class LogHandlersTableModel
extends ProviderTableModel<LogHandler> {
    private LogHandlerSet logHandlerSet;
    private static final MsgList titles = MsgList.create(DesignerMsg.TRIGGER, DesignerMsg.EXPRESSION, DesignerMsg.AUDIT);

    public LogHandlersTableModel(@NotNull LogHandlerSet logHandlerSet) {
        super(titles);
        this.logHandlerSet = logHandlerSet;
        for (LogHandler logHandler : logHandlerSet.getLogHandlers()) {
            LogHandler logHandlerCopy = logHandlerSet.createLogHandler(logHandler.getTrigger(), logHandler.getLevel(), logHandler.getExpression());
            logHandlerCopy.setMustDisplayInAuditTrail(logHandler.mustDisplayInAuditTrail());
            this.addRow(logHandlerCopy);
        }
    }

    public LogHandlerSet getLogHandlerSet() {
        return this.logHandlerSet;
    }

    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public Object getValueAt(int row, int column) {
        LogHandler logHandler = (LogHandler)this.getRow(row);
        switch (column) {
            case 0: {
                return logHandler;
            }
            case 1: {
                Expression expression = logHandler.getExpression();
                return ExpressionHelper.getText((Expression)expression, (ExpressionContext)this.createExpressionContext(logHandler));
            }
            case 2: {
                return logHandler.mustDisplayInAuditTrail();
            }
        }
        return "";
    }

    public boolean isTypeValid(int row) {
        LogHandler logHandler = (LogHandler)this.getRow(row);
        LogHandlerTrigger trigger = logHandler.getTrigger();
        Loggable loggable = this.logHandlerSet.getParentObject();
        Sequence availableLogHandlerTriggers = loggable.getAvailableLogHandlerTriggers();
        return availableLogHandlerTriggers.contains(trigger);
    }

    public boolean isExpressionValid(int row) {
        LogHandler logHandler = (LogHandler)this.getRow(row);
        return ExpressionHelper.isExpressionValid((Expression)logHandler.getExpression(), (ExpressionContext)this.createExpressionContext(logHandler));
    }

    public boolean isModelValid() {
        for (int row = 0; row < this.getRowCount(); ++row) {
            if (this.isRowValid(row)) continue;
            return false;
        }
        return true;
    }

    public boolean isRowValid(int row) {
        return this.isTypeValid(row) && this.isExpressionValid(row);
    }

    private ExpressionContext createExpressionContext(@NotNull LogHandler logHandler) {
        Loggable loggable = this.logHandlerSet.getParentObject();
        DataDeclarationContainer logHandlerContext = loggable.getLogHandlerContext(logHandler.getTrigger());
        return new ExpressionContext(logHandlerContext, LogHandler.ResultType.get());
    }
}

