/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.loghandler;

import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.loghandler.LogHandlerDialog;
import oracle.bpm.designer.loghandler.LogHandlersTableModel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.Color;
import oracle.bpm.project.model.processes.loghandlers.LogHandler;
import oracle.bpm.project.model.processes.loghandlers.LogHandlerLevel;
import oracle.bpm.project.model.processes.loghandlers.LogHandlerSet;
import oracle.bpm.project.model.processes.loghandlers.LogHandlerTrigger;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ColorProvider;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.TableColorProvider;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.table.BaseTablePanel;
import oracle.bpm.ui.table.TableModel;
import oracle.bpm.ui.table.renderers.BooleanYesNoLabelProvider;
import org.jetbrains.annotations.NotNull;

public class LogHandlersTable
extends BaseTablePanel {
    private LogHandlersTable(@NotNull UiContainer parent, @NotNull LogHandlersTableModel model) {
        super(parent, Msg.QUOTE(""), DesignerMsg.LOG_HANDLERS, (TableModel)model, BaseTablePanel.Style.TOOLBAR_TOP);
        this.setWithColons(true);
        this.init();
    }

    public static LogHandlersTable create(@NotNull UiContainer parent, @NotNull LogHandlerSet logHandlerSet) {
        LogHandlersTableModel model = new LogHandlersTableModel(logHandlerSet);
        return new LogHandlersTable(parent, model);
    }

    public Sequence<LogHandler> getLogHandlers() {
        return CollectionUtils.asSequence(this.getModel().getData());
    }

    protected boolean showEditAction() {
        return true;
    }

    protected void addAction() {
        LogHandlerSet logHandlerSet = this.getModel().getLogHandlerSet();
        LogHandlerDialog dialog = new LogHandlerDialog(Ui.getRoot(), logHandlerSet, null);
        if (dialog.display()) {
            LogHandler newLogHandler = (LogHandler)dialog.getObject();
            this.getModel().addRow(newLogHandler);
        }
    }

    protected void editAction() {
        LogHandlerSet logHandlerSet = this.getModel().getLogHandlerSet();
        LogHandler logHandler = (LogHandler)this.getModel().getRow(this.getTable().getSelectedRow());
        LogHandlerDialog dialog = new LogHandlerDialog(Ui.getRoot(), logHandlerSet, logHandler);
        if (dialog.display()) {
            this.getModel().fireTableDataChanged();
        }
    }

    protected LogHandlersTableModel getModel() {
        return (LogHandlersTableModel)super.getModel();
    }

    private void init() {
        this.getTable().getColumn(0).setColorProvider((ColorProvider)new TableColorProvider.Default(){

            public Color getForeground(Object element) {
                return !LogHandlersTable.this.getModel().isTypeValid(this.getRow()) ? Color.RED : null;
            }

            public Color getBackground(Object element) {
                return Color.WHITE;
            }
        });
        this.getTable().getColumn(1).setColorProvider((ColorProvider)new TableColorProvider.Default(){

            public Color getForeground(Object element) {
                return !LogHandlersTable.this.getModel().isExpressionValid(this.getRow()) ? Color.RED : null;
            }

            public Color getBackground(Object element) {
                return Color.WHITE;
            }
        });
        this.getTable().getColumn(0).setLabelProvider((LabelProvider)new LabelProvider<LogHandler>(){

            public Image getIcon(LogHandler logHandler) {
                LogHandlerLevel level = logHandler.getLevel();
                return Image.create((Msg)level.getMsg());
            }

            public String getText(LogHandler logHandler) {
                LogHandlerTrigger trigger = logHandler.getTrigger();
                return trigger.getMsg().getString();
            }
        });
        this.getTable().setDefaultLabelProvider(Boolean.class, (LabelProvider)new BooleanYesNoLabelProvider());
    }
}

