/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.loghandler;

import oracle.bpm.designer.loghandler.LogHandlersTable;
import oracle.bpm.designer.loghandler.LogHandlersTableModel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.loghandlers.LogHandler;
import oracle.bpm.project.model.processes.loghandlers.LogHandlerSet;
import oracle.bpm.project.model.processes.loghandlers.Loggable;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;

public class LogHandlersPanel
extends Panel {
    private LogHandlersTable table;

    public LogHandlersPanel(@NotNull UiContainer parent, @NotNull Loggable loggable) {
        super(parent);
        this.init(loggable);
    }

    public void applyChanges() {
        LogHandlerSet logHandlerSet = this.table.getModel().getLogHandlerSet();
        logHandlerSet.clearLogHandlers();
        for (LogHandler logHandler : this.table.getLogHandlers()) {
            try {
                logHandlerSet.addLogHandler(logHandler);
            }
            catch (ProjectException e) {
                MessageDialog.showError((Throwable)e);
            }
        }
    }

    public Msg validateInput() {
        LogHandlersTableModel model = this.table.getModel();
        if (!model.isModelValid()) {
            return DesignerMsg.DYNAMIC_ONE_OR_MORE_INVALID(DesignerMsg.LOG_HANDLERS);
        }
        return null;
    }

    private void init(@NotNull Loggable loggable) {
        this.setLayout((Layout)new MigLayout("ins 0, gap 0, fill"));
        LogHandlerSet logHandlerSet = loggable.getLogHandlerSet();
        this.table = LogHandlersTable.create((UiContainer)this, logHandlerSet);
        this.add((UiComponent)this.table, "grow");
    }
}

