/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.loghandler;

import oracle.bpm.designer.loghandler.LogHandlersPanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.processes.loghandlers.Loggable;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;

public class LogHandlersDialog
extends OkCancelDialog {
    private Loggable loggable;
    private LogHandlersPanel logHandlersPanel;

    public LogHandlersDialog(@NotNull UiWindow parent, @NotNull Loggable loggable) {
        super(parent, DesignerMsg.LOG_HANDLERS);
        this.loggable = loggable;
        this.init();
    }

    public void ok() {
        Msg errorMessage = this.logHandlersPanel.validateInput();
        if (errorMessage != null) {
            MessageDialog.showError((Msg)errorMessage);
            return;
        }
        if (this.logHandlersPanel != null) {
            this.logHandlersPanel.applyChanges();
        }
        this.close();
    }

    private void init() {
        UiContainer panel = this.getContentPane();
        panel.setLayout((Layout)new MigLayout("ins 5, gap 5, fill"));
        this.logHandlersPanel = new LogHandlersPanel(panel, this.loggable);
        panel.add((UiComponent)this.logHandlersPanel, (Object)"grow");
        this.setSize(500, 300);
        this.setLocationRelativeTo((UiComponent)this.getParent());
    }
}

