/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.loghandler;

import oracle.bpm.designer.expression.ExpressionPanel;
import oracle.bpm.designer.expression.ExpressionPanelFactory;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.project.model.processes.loghandlers.LogHandler;
import oracle.bpm.project.model.processes.loghandlers.LogHandlerLevel;
import oracle.bpm.project.model.processes.loghandlers.LogHandlerSet;
import oracle.bpm.project.model.processes.loghandlers.LogHandlerTrigger;
import oracle.bpm.project.model.processes.loghandlers.Loggable;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.ObjectEditorDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ReferenceComboBox;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import org.jetbrains.annotations.NotNull;

public class LogHandlerDialog
extends ObjectEditorDialog<LogHandler> {
    private CheckBox displayInATCheckbox;
    private ExpressionPanel expressionPanel;
    private ComboBox<LogHandlerLevel> levelComboBox;
    private LogHandlerSet logHandlerSet;
    private ReferenceComboBox<LogHandlerTrigger> triggerComboBox;

    public LogHandlerDialog(@NotNull UiWindow parent, @NotNull LogHandlerSet logHandlerSet, LogHandler logHandler) {
        super(parent, DesignerMsg.LOG_HANDLER, (Object)logHandler);
        this.logHandlerSet = logHandlerSet;
    }

    public Msg validateInput() {
        if (this.triggerComboBox.getSelectedItem() == null || !this.triggerComboBox.isValidSelection()) {
            return DesignerMsg.DYNAMIC_INVALID(DesignerMsg.TRIGGER);
        }
        if (this.expressionPanel.getExpression() == null || !this.expressionPanel.isExpressionValid()) {
            return DesignerMsg.INVALID_EXPRESSION;
        }
        return null;
    }

    protected void layoutControls(@NotNull UiContainer container) {
        Loggable loggable = this.getLoggable();
        container.setLayout((Layout)new MigLayout("ins 10, gap 5, fill"));
        container.add((UiComponent)Label.create((UiContainer)container, (Msg)DesignerMsg.TRIGGER));
        this.triggerComboBox = this.createTriggerComboBox(container, loggable);
        container.add(this.triggerComboBox, (Object)"pushx, growx");
        this.levelComboBox = this.createLevelComboBox(container);
        container.add((UiComponent)Label.create((UiContainer)container, (Msg)DesignerMsg.LEVEL));
        container.add(this.levelComboBox, (Object)"wrap");
        this.displayInATCheckbox = CheckBox.create((UiContainer)container, (Msg)DesignerMsg.DISPLAY_IN_AUDIT_TRAIL);
        container.add((UiComponent)this.displayInATCheckbox, (Object)"skip 1, pushx, growx, wrap");
        Panel expressionPanelContainer = new Panel(container, DesignerMsg.EXPRESSION);
        expressionPanelContainer.setLayout((Layout)new BorderLayout(5, 5));
        this.expressionPanel = ExpressionPanelFactory.createDefaultMultiLinePanel(container, this.createExpressionContext());
        expressionPanelContainer.add(this.expressionPanel.getUiComponent(), (Object)"Center");
        container.add((UiComponent)expressionPanelContainer, (Object)"spanx, grow");
        this.setSize(450, 300);
        this.setLocationRelativeTo((UiComponent)this.getParent());
    }

    protected void setObjectFromEditor(@NotNull LogHandler logHandler) {
        logHandler.setTrigger((LogHandlerTrigger)this.triggerComboBox.getSelectedItem());
        logHandler.setLevel((LogHandlerLevel)this.levelComboBox.getSelectedItem());
        logHandler.setMustDisplayInAuditTrail(this.displayInATCheckbox.isSelected());
        logHandler.setExpression(this.expressionPanel.getExpression());
    }

    protected LogHandler createObjectFromEditor() {
        LogHandler logHandler = this.logHandlerSet.createLogHandler((LogHandlerTrigger)this.triggerComboBox.getSelectedItem(), (LogHandlerLevel)this.levelComboBox.getSelectedItem(), this.expressionPanel.getExpression());
        logHandler.setMustDisplayInAuditTrail(this.displayInATCheckbox.isSelected());
        return logHandler;
    }

    protected void setEditorFromObject(@NotNull LogHandler logHandler) {
        this.triggerComboBox.setSelectedItem((Object)logHandler.getTrigger());
        this.levelComboBox.setSelectedItem((Object)logHandler.getLevel());
        this.displayInATCheckbox.setSelected(logHandler.mustDisplayInAuditTrail());
        this.expressionPanel.setExpression(logHandler.getExpression());
    }

    protected void setEditorDefaultValues() {
    }

    private ReferenceComboBox<LogHandlerTrigger> createTriggerComboBox(@NotNull UiContainer parent, @NotNull Loggable loggable) {
        ReferenceComboBox result = new ReferenceComboBox(parent);
        for (LogHandlerTrigger trigger : loggable.getAvailableLogHandlerTriggers()) {
            result.addItem((Object)trigger);
        }
        if (result.getItemCount() > 0) {
            result.setSelectedIndex(0);
        }
        result.addModificationListener(new ModificationListener(){

            public void objectModified(ModificationEvent modificationEvent) {
                LogHandlerDialog.this.updateExpressionContext();
            }
        });
        result.setLabelProvider((LabelProvider)new LabelProvider<LogHandlerTrigger>(){

            public Image getIcon(LogHandlerTrigger element) {
                return Image.create((Msg)element.getMsg());
            }

            public String getText(LogHandlerTrigger element) {
                return element.getMsg().getString();
            }
        });
        return result;
    }

    private ComboBox<LogHandlerLevel> createLevelComboBox(@NotNull UiContainer parent) {
        ComboBox result = UiFactory.createComboBox((UiContainer)parent);
        for (LogHandlerLevel level : LogHandlerLevel.values()) {
            result.addItem((Object)level);
        }
        result.setSelectedItem((Object)LogHandlerLevel.DEFAULT);
        result.setLabelProvider((LabelProvider)new LabelProvider<LogHandlerLevel>(){

            public Image getIcon(LogHandlerLevel element) {
                return Image.create((Msg)element.getMsg());
            }

            public String getText(LogHandlerLevel element) {
                return element.getMsg().getString();
            }
        });
        return result;
    }

    private ExpressionContext createExpressionContext() {
        LogHandlerTrigger trigger = (LogHandlerTrigger)this.triggerComboBox.getSelectedItem();
        Loggable loggable = this.getLoggable();
        return new ExpressionContext(loggable.getLogHandlerContext(trigger), LogHandler.ResultType.get());
    }

    private void updateExpressionContext() {
        ExpressionContext expressionContext = this.createExpressionContext();
        this.expressionPanel.setContext(expressionContext);
    }

    private Loggable getLoggable() {
        return this.logHandlerSet.getParentObject();
    }
}

