/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.importer.visio;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.bpm.designer.importer.visio.Drawing;
import oracle.bpm.designer.importer.visio.VisioGeom;
import oracle.bpm.designer.importer.visio.VisioMaster;
import oracle.bpm.designer.importer.visio.VisioXForm;
import oracle.bpm.geom.Point;

final class VisioShape {
    private List basicGeomKindList_d;
    private final List geoms_d;
    private boolean hasXForm1D_d = false;
    private final int id_d;
    private boolean lineBeginArrow_d = false;
    private boolean lineEndArrow_d = false;
    private VisioMaster master_d;
    private Integer masterId_d;
    private String name_d;
    private VisioShape parentShape_d = null;
    private Map shapes_d;
    private String text_d;
    private String type_d;
    private VisioXForm xForm_d;
    private static final String FUNCTIONAL_ROLE_NAME = "Functional band";
    private static final String GROUP_TYPE = "Group";
    private static final String LINE_SHAPE = "Line";
    public static final String COMPOSED_SHAPE = "Composed";
    public static final String RECTANGLE = "Rectangle";
    public static final String ELLIPSE = "Ellipse";

    public VisioShape(int id) {
        this.id_d = id;
        this.geoms_d = new ArrayList();
    }

    public String getBasicShape() {
        if (this.isLine()) {
            return LINE_SHAPE;
        }
        if (this.isCompound()) {
            return COMPOSED_SHAPE;
        }
        if (this.basicGeomKindList_d == null) {
            this.setBasicGeomKindList();
        }
        return (String)this.basicGeomKindList_d.get(0);
    }

    public boolean isChildShape() {
        return this.parentShape_d != null;
    }

    public boolean isDirectionInverted() {
        return this.lineBeginArrow_d && !this.lineEndArrow_d;
    }

    public void setDrawingDimensions(Drawing.Dimensions dimensions) {
        this.xForm_d.setDrawingDimensions(dimensions);
    }

    public List getGeoms() {
        return this.geoms_d;
    }

    public void setHasXForm1D(boolean hasXForm1D) {
        this.hasXForm1D_d = hasXForm1D;
    }

    public Integer getId() {
        return this.id_d;
    }

    public boolean isLine() {
        return this.hasXForm1D_d && !this.isCompound();
    }

    public void setLineBeginArrow(boolean hasArrow) {
        this.lineBeginArrow_d = hasArrow;
    }

    public void setLineEndArrow(boolean hasArrow) {
        this.lineEndArrow_d = hasArrow;
    }

    public Point getLocation(int convertionFactor) {
        return this.xForm_d.getLocation(convertionFactor);
    }

    public void setMaster(VisioMaster master) {
        this.master_d = master;
    }

    public void setMasterId(int id) {
        this.masterId_d = id;
    }

    public Integer getMasterId() {
        return this.masterId_d;
    }

    public void setName(String name) {
        this.name_d = name;
    }

    public String getName() {
        if (this.master_d != null) {
            this.name_d = this.master_d.getName();
        }
        return this.name_d;
    }

    public VisioShape getParentShape() {
        return this.parentShape_d;
    }

    public boolean isRole() {
        boolean isRole = false;
        if (this.master_d != null && this.master_d.getName().startsWith(FUNCTIONAL_ROLE_NAME)) {
            isRole = true;
        }
        return isRole;
    }

    public String getShortDescription() {
        StringBuffer sb = new StringBuffer();
        sb.append("Shape: ID: " + this.id_d);
        if (this.name_d != null) {
            sb.append(" - Name: " + this.name_d);
        }
        if (this.type_d != null) {
            sb.append(" - ConfigType: " + this.type_d);
        }
        return new String(sb);
    }

    public void setText(String text) {
        this.text_d = text;
    }

    public String getText() {
        if ((this.text_d == null || this.text_d.trim().equals("")) && this.shapes_d != null) {
            for (VisioShape visioShape : this.shapes_d.values()) {
                if (visioShape.getText() == null || visioShape.getText().trim().equals("")) continue;
                if (this.text_d == null) {
                    this.text_d = visioShape.getText().trim();
                    continue;
                }
                this.text_d = this.text_d + visioShape.getText().trim();
            }
        }
        return this.text_d;
    }

    public void setType(String type) {
        this.type_d = type;
    }

    public void setXForm(VisioXForm xForm) {
        this.xForm_d = xForm;
    }

    public VisioXForm getXForm() {
        return this.xForm_d;
    }

    public void addGeom(int index, VisioGeom geom) {
        this.geoms_d.add(index, geom);
    }

    public void addShape(VisioShape shape) {
        if (this.shapes_d == null) {
            this.shapes_d = new TreeMap();
        }
        this.shapes_d.put(shape.getId(), shape);
        shape.setParentShape(this);
    }

    public String toString() {
        Iterator it;
        StringBuffer sb = new StringBuffer();
        sb.append("Shape: ID: " + this.id_d);
        if (this.name_d != null) {
            sb.append(" - Name: " + this.name_d);
        }
        if (this.type_d != null) {
            sb.append(" - ConfigType: " + this.type_d);
        }
        if (this.text_d != null) {
            sb.append(" - Text: '" + this.text_d + "'");
        }
        if (this.masterId_d != null) {
            sb.append(" - Master: " + this.masterId_d);
        }
        sb.append(" - (" + this.getBasicShape() + ")");
        sb.append("\n  " + this.xForm_d);
        if (this.hasXForm1D_d) {
            sb.append("\n  XForm1D: 'Info not available' - Inverted Line Direction: " + this.isDirectionInverted());
        }
        if ((it = this.geoms_d.iterator()).hasNext()) {
            sb.append("\n  Geoms:");
        }
        while (it.hasNext()) {
            sb.append("\n" + it.next());
        }
        return sb + "\n";
    }

    private void setBasicGeomKindList() {
        this.basicGeomKindList_d = new ArrayList();
        Iterator it = this.geoms_d.iterator();
        while (it.hasNext()) {
            this.basicGeomKindList_d.add(((VisioGeom)it.next()).getBasicGeom().getKind());
        }
    }

    private boolean isCompound() {
        return this.geoms_d.size() != 1 || this.shapes_d != null || GROUP_TYPE.equals(this.type_d);
    }

    private void setParentShape(VisioShape shape) {
        this.parentShape_d = shape;
    }
}

