/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.importer;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.importer.ImportRuleActivity;
import oracle.bpm.project.importer.ImportRuleSet;
import oracle.bpm.project.importer.aris.ArisActivityType;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Box;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.ListSelectionMode;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.editors.AbstractCellEditor;
import oracle.bpm.ui.event.TableModelEvent;
import oracle.bpm.ui.event.TableModelListener;
import oracle.bpm.ui.layout.FlowLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.table.DefaultTableModel;
import oracle.bpm.ui.table.Table;
import oracle.bpm.ui.table.TableColumn;
import oracle.bpm.ui.table.TableModel;
import oracle.bpm.ui.table.editors.TableCellEditor;

public final class RulesEditorDialog
extends OkCancelDialog
implements TableModelListener {
    private BaseAction advancedAction;
    private boolean advancedMode;
    private final EditorTableModel dataModel;
    private final ImportRuleSet rules;
    private final Table rulesTable;
    private boolean showAdvancedButton = false;
    private static final int SHAPE = 0;
    private static final int ACTIVITY_TYPE = 1;

    public RulesEditorDialog(UiWindow parentFrame, ImportRuleSet rulesList) {
        super(parentFrame, DesignerMsg.IMPORT_RULES_EDITOR, true);
        Panel container = new Panel(this.getContentPane(), DesignerMsg.SELECT_ACT_TYPE_FOR_SHAPE);
        container.setLayout((Layout)new BorderLayout());
        this.rules = rulesList;
        this.dataModel = new EditorTableModel();
        this.dataModel.addTableModelListener(this);
        this.rulesTable = new Table((UiContainer)container, (TableModel)this.dataModel, ListSelectionMode.SINGLE_SELECTION);
        TableColumn column = this.rulesTable.getColumn(1);
        column.setCellEditor((TableCellEditor)new RuleActivityEditor());
        this.rulesTable.setShowHorizontalLines(true);
        this.rulesTable.setShowVerticalLines(true);
        this.fillRulesTable();
        this.rulesTable.setRelativeSizes(new double[]{0.5, 0.5});
        int nRows = this.rulesTable.getRowCount();
        nRows = nRows < 8 ? 8 : (nRows > 15 ? 15 : nRows);
        this.rulesTable.setPreferredRows(nRows);
        container.add(Box.createHorizontalStrut((UiContainer)container, (int)10), (Object)"East");
        container.add(Box.createHorizontalStrut((UiContainer)container, (int)10), (Object)"West");
        container.add(Box.createVerticalStrut((UiContainer)container, (int)10), (Object)"North");
        container.add(Box.createVerticalStrut((UiContainer)container, (int)10), (Object)"South");
        container.add((UiComponent)this.rulesTable, (Object)"Center");
        this.getContentPane().add((UiComponent)container, (Object)"Center");
        this.pack();
        this.setSize(500, 400);
        this.centerOnScreen();
    }

    public RulesEditorDialog(UiWindow parentFrame, ImportRuleSet rulesList, boolean showAdvancedButton) {
        this(parentFrame, rulesList);
        this.showAdvancedButton = showAdvancedButton;
    }

    public boolean isAdvancedMode() {
        return this.advancedMode;
    }

    public void ok() {
        if (this.rules.allDefined()) {
            this.close();
        } else {
            MessageDialog.showNotice((Msg)ProjectMsg.NOT_DEFINED_RULES);
            this.setUserAccepted(false);
        }
    }

    public void setAdvancedEnabled(boolean enabled) {
        this.advancedAction.setEnabled(enabled);
    }

    public void setAdvancedMode(boolean advancedMode) {
        this.advancedMode = advancedMode;
    }

    public void tableChanged(TableModelEvent e) {
        int row = e.getFirstRow();
        int column = e.getColumn();
        if (column == 1) {
            String typeName;
            String shape = (String)this.dataModel.getValueAt(row, 0);
            ArisActivityType arisActivityType = ArisActivityType.findFromString((String)shape);
            if (arisActivityType != null) {
                shape = arisActivityType.name();
            }
            if ((typeName = (String)this.dataModel.getValueAt(row, 1)) != null) {
                this.rules.addRuleFromExternalName(shape, typeName);
            }
        }
    }

    protected UiComponent internalBuildButtons(UiContainer parent) {
        this.advancedAction = new BaseAction(CoreMsg.ADVANCED){

            public void run() {
                RulesEditorDialog.this.setUserAccepted(true);
                RulesEditorDialog.this.setAdvancedMode(true);
                RulesEditorDialog.this.close();
                RulesEditorDialog.this.dispose();
            }
        };
        Panel newButtonPanel = new Panel(parent);
        newButtonPanel.setLayout((Layout)new BorderLayout());
        newButtonPanel.add(super.internalBuildButtons((UiContainer)newButtonPanel), (Object)"East");
        if (this.showAdvancedButton) {
            Panel advancedBtnPanel = new Panel((UiContainer)newButtonPanel);
            advancedBtnPanel.setLayout((Layout)new FlowLayout(0, 5, 5));
            advancedBtnPanel.add((UiComponent)new Button((UiContainer)advancedBtnPanel, this.advancedAction));
            newButtonPanel.add((UiComponent)advancedBtnPanel, (Object)"West");
        }
        this.advancedAction.setEnabled(false);
        return newButtonPanel;
    }

    private void fillRulesTable() {
        EditorTableModel tableModel = (EditorTableModel)this.rulesTable.getModel();
        String[] shapes = this.rules.getShapes();
        ImportRuleActivity[] activities = this.rules.getActivities();
        for (int i = 0; i < shapes.length; ++i) {
            ArisActivityType arisActivityType = ArisActivityType.findFromString((String)shapes[i]);
            String display = arisActivityType == null ? shapes[i] : arisActivityType.getString();
            tableModel.addRow(new Object[]{display, activities[i].getString()});
        }
    }

    private static class RuleActivityEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private ComboBox comboBox;

        private RuleActivityEditor() {
        }

        public UiComponent getTableCellEditor(Table component, Object value, boolean isSelected, int row, int column) {
            return this.createEditor((UiContainer)component, value);
        }

        public Object getCellEditorValue() {
            return this.comboBox.getSelectedItem();
        }

        public UiComponent createEditor(UiContainer parent, Object value) {
            this.comboBox = ImportRuleActivity.createCombo((UiContainer)parent);
            this.comboBox.setSelectedItem(value);
            return this.comboBox;
        }
    }

    private static final class EditorTableModel
    extends DefaultTableModel {
        public static final String[] columns = new String[]{DesignerMsg.SHAPE.getString(), DesignerMsg.ACTIVITY_TYPE.getString()};
        public static final Class[] classes = new Class[]{String.class, String.class};

        public Class getColumnClass(int columnIndex) {
            return classes[columnIndex];
        }

        public int getColumnCount() {
            return columns.length;
        }

        public String getColumnName(int column) {
            return columns[column];
        }

        public boolean isCellEditable(int row, int column) {
            return column != 0;
        }
    }
}

