/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.importer;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.log.Log;
import oracle.bpm.processmodel.SchemaType;
import oracle.bpm.project.importer.ModelImporter;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ImporterException;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.ui.filechooser.FileChooser;
import oracle.bpm.util.FileUtils;

public final class DrawingImporter {
    private final Map<String, ModelImporter> importers_d = new HashMap<String, ModelImporter>();
    private final DesignerPreferences preferences_d;

    public DrawingImporter(DesignerPreferences preferences) {
        this.preferences_d = preferences;
        List importers = ModelImporter.Extension.getImporters();
        for (ModelImporter importer : importers) {
            if (this.shouldSkipImporter(importer)) continue;
            this.registerImporter(importer);
        }
    }

    public static boolean isFuegoProcess(File sourceFile, ProjectObject project) throws ImporterException {
        return SchemaType.PROCEDURE.hasExtension(FileUtils.getExtension(sourceFile)) || SchemaType.SCREENFLOW.hasExtension(FileUtils.getExtension(sourceFile)) || SchemaType.PROCESS.hasExtension(FileUtils.getExtension(sourceFile));
    }

    public FileChooser getFileChooser() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setName("import.drawing");
        for (ModelImporter modelImporter : this.importers_d.values()) {
            fileChooser.addChoosableFileFilter(modelImporter.getFileFilter());
        }
        fileChooser.setAcceptAllFileFilterUsed(false);
        return fileChooser;
    }

    public Collection<ModelImporter> getImporters() {
        return this.importers_d.values();
    }

    public Collection<Process> importDrawing(File file, Project project) throws ProjectException, ImporterException {
        this.preferences_d.setImportDrawingLastUsedPath(file.getParentFile());
        Collection modelsCollection = this.getImporterFor(file).importModels(file, project);
        return modelsCollection;
    }

    public boolean isRegisteredExtension(String extension) {
        return this.importers_d.containsKey(extension);
    }

    public void postImport(File sourceFile, Process[] processes) throws ImporterException {
        ModelImporter importer = this.getImporterFor(sourceFile);
        try {
            importer.afterImport(processes);
        }
        catch (ProjectException e) {
            Log.logWarning(e);
        }
    }

    private boolean shouldSkipImporter(ModelImporter importer) {
        return importer.getType() == ModelImporter.Type.ARIS && !this.shouldIncludeArisImporter() || importer.getType() == ModelImporter.Type.ROSE && !this.shouldIncludeRoseImporter();
    }

    private boolean shouldIncludeArisImporter() {
        return System.getProperty("com.bea.importers.enableArisImporter") != null;
    }

    private boolean shouldIncludeRoseImporter() {
        return System.getProperty("com.bea.importers.enableRoseImporter") != null;
    }

    private ModelImporter getImporterFor(File file) throws ImporterException {
        String extension = FileUtils.getExtension(file);
        ModelImporter importer = this.importers_d.get(extension);
        if (importer == null) {
            throw new ImporterException(null, ProjectMsg.UNRECOGNIZED_DRAWING);
        }
        return importer;
    }

    private void registerImporter(ModelImporter importer) {
        this.importers_d.put(importer.getAssociatedExtension(), importer);
    }
}

