/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.identity;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.identity.LookupMembersService;
import oracle.bpm.designer.identity.MembersLabelProvider;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.identity.Member;
import oracle.bpm.project.model.identity.MemberContainer;
import oracle.bpm.project.model.identity.MemberType;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Box;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.event.TableModelEvent;
import oracle.bpm.ui.event.TableModelListener;
import oracle.bpm.ui.table.BaseTablePanel;
import oracle.bpm.ui.table.ProviderTableModel;
import oracle.bpm.ui.table.TableModel;
import org.jetbrains.annotations.NotNull;

public class MembersPanel
extends BaseTablePanel {
    private ComboBox<MemberType> membersTypeCombo;
    private static final Comparator<Member> MEMBER_COMPARATOR = new Comparator<Member>(){

        @Override
        public int compare(Member member1, Member member2) {
            return member1.equals(member2) ? 0 : 1;
        }
    };

    public MembersPanel(UiContainer parent) {
        super(parent, DesignerMsg.MEMBERS, null, null, BaseTablePanel.Style.TOOLBAR_TOP);
    }

    public void setMemberContainer(MemberContainer memberContainer) {
        MembersTableModel membersTableModel = MembersTableModel.create(memberContainer);
        this.getTable().setModel((TableModel)membersTableModel);
    }

    protected MembersTableModel getModel() {
        return (MembersTableModel)super.getModel();
    }

    protected void beforeActions(@NotNull ToolBar toolBar) {
        toolBar.add((UiComponent)Label.create((UiContainer)toolBar, (Msg)DesignerMsg.TYPE));
        this.membersTypeCombo = UiFactory.createComboBox((UiContainer)toolBar, (Object[])MemberType.values());
        this.membersTypeCombo.setLabelProvider((LabelProvider)new MembersLabelProvider());
        toolBar.add(Box.createHorizontalStrut((UiContainer)toolBar, (int)5));
        toolBar.add(this.membersTypeCombo);
        toolBar.add(Box.createHorizontalStrut((UiContainer)toolBar, (int)5));
    }

    protected void addAction() {
        MemberContainer memberContainer = this.getModel().getMemberContainer();
        if (memberContainer != null) {
            MemberType memberType = (MemberType)this.membersTypeCombo.getSelectedItem();
            String id = ModelUtils.getNextMemberId((MemberContainer)memberContainer, (MemberType)memberType);
            Member member = memberContainer.createMember(memberType, id);
            member.setName(id);
            this.getModel().addRow(member);
        }
    }

    protected boolean showBrowseAction() {
        return true;
    }

    protected void browseAction() {
        MemberContainer memberContainer = this.getModel().getMemberContainer();
        if (memberContainer != null) {
            MemberType memberType = (MemberType)this.membersTypeCombo.getSelectedItem();
            LookupMembersService lookupMembersService = AbstractStudioWorkbench.getInstance().getLookupMembersService();
            if (lookupMembersService != null) {
                boolean hasCommonMembers;
                Collection<Member> members = lookupMembersService.findMembers(memberContainer, memberType);
                boolean bl = hasCommonMembers = !Collections.disjoint(members, this.getModel().getData());
                if (hasCommonMembers) {
                    MessageDialog.showWarning((Msg)DesignerMsg.DUPLICATE_MEMBERS);
                    members = CollectionUtils.selectLeftDiff(members, this.getModel().getData(), MEMBER_COMPARATOR);
                }
                this.getModel().addRows(members);
            }
        }
    }

    private static class MembersTableModel
    extends ProviderTableModel<Member> {
        private MemberContainer memberContainer;
        private TableModelListener tableModelListener;
        private static int NAME_COLUMN = 0;

        private MembersTableModel(MemberContainer memberContainer) {
            super(MsgList.create(DesignerMsg.NAME, DesignerMsg.TYPE));
            this.addRows(memberContainer.getMembers());
            this.setMemberContainer(memberContainer);
            this.addTableModelListener(this.getTableModelListener());
        }

        public static final MembersTableModel create(MemberContainer memberContainer) {
            return new MembersTableModel(memberContainer);
        }

        public Object getValueAt(int row, int column) {
            Member member = (Member)this.getRow(row);
            return column == NAME_COLUMN ? member.getName() : member.getType().getMsg().getString();
        }

        public void setValueAt(Object value, int row, int column) {
            Member member = (Member)this.getRow(row);
            Member supposedDuplicatedMember = this.memberContainer.createMember(member.getType(), member.getId());
            supposedDuplicatedMember.setName((String)value);
            if (this.getData().contains(supposedDuplicatedMember) && this.getData().indexOf(supposedDuplicatedMember) != row) {
                MessageDialog.showError((Msg)DesignerMsg.DUPLICATE_COMPONENT(DesignerMsg.MEMBERS.getString()));
            } else {
                member.setName((String)value);
                this.fireTableChanged(new TableModelEvent((Object)this, row, row, column, 0));
            }
        }

        public boolean isCellEditable(int row, int column) {
            return column == NAME_COLUMN;
        }

        public void setMemberContainer(MemberContainer memberContainer) {
            this.memberContainer = memberContainer;
        }

        public MemberContainer getMemberContainer() {
            return this.memberContainer;
        }

        private TableModelListener getTableModelListener() {
            if (this.tableModelListener == null) {
                this.tableModelListener = new TableModelListener(){

                    public void tableChanged(TableModelEvent event) {
                        MembersTableModel model = (MembersTableModel)((Object)event.getSource());
                        try {
                            for (int firstRow = event.getFirstRow(); firstRow <= event.getLastRow(); ++firstRow) {
                                Member member;
                                if (event.isInsert()) {
                                    member = (Member)model.getRow(firstRow);
                                    MembersTableModel.this.memberContainer.addMember(member);
                                }
                                if (event.isDelete() && (member = (Member)event.getLastValue()) != null) {
                                    MembersTableModel.this.memberContainer.removeMember(member);
                                }
                                if (!event.isUpdate()) continue;
                                member = (Member)model.getRow(firstRow);
                                Member oldMember = MembersTableModel.this.memberContainer.findMember(member.getId());
                                oldMember.replace((ProjectObject)member);
                            }
                        }
                        catch (ProjectException e) {
                            MessageDialog.showError((Throwable)e);
                        }
                    }
                };
            }
            return this.tableModelListener;
        }
    }
}

