/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.humantask;

import javax.swing.text.html.HTML;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.flowpanels.PriorityCombo;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.soa.humantask.HumanTask;
import oracle.bpm.soa.humantask.HumanTaskBpm;
import oracle.bpm.soa.humantask.RoutingSlip;
import oracle.bpm.soa.humantask.Title;
import oracle.bpm.soa.humantask.WorkflowConfiguration;
import oracle.bpm.soa.humantask.msg.HumantaskMsg;

public class HumanTaskHtmlBuilder {
    private static final String START_EFFECT = "&nbsp<b>";
    private static final String END_EFFECT = "</b>";

    private HumanTaskHtmlBuilder() {
    }

    public static String getInfo(HumanTask humanTask) {
        StringBuilder builder = new StringBuilder();
        builder.append(HumanTaskHtmlBuilder.open(HTML.Tag.HTML));
        builder.append(HumanTaskHtmlBuilder.createLine(DesignerMsg.NAME, humanTask.getName()));
        String text = PriorityCombo.LABEL_PROVIDER.getText(humanTask.getPriority());
        builder.append(HumanTaskHtmlBuilder.createLine(ProjectModelMsg.VAR_PRIORITY_KEY, text));
        Title title = humanTask.getTitle();
        String value = title.getType().getMsg() + " - " + title.getValue();
        builder.append(HumanTaskHtmlBuilder.createLine(DesignerMsg.TITLE, value));
        WorkflowConfiguration.Outcomes outcomes = humanTask.getWorkflowConfiguration().getOutcomes();
        builder.append(HumanTaskHtmlBuilder.createLine(DesignerMsg.OUTCOMES, HumanTaskHtmlBuilder.getOutcomes(outcomes.getValues())));
        RoutingSlip routingSlip = humanTask.getRoutingSlip();
        HumanTaskBpm.LaneParticipantType laneParticipantType = HumanTaskBpm.getLaneParticipantType((RoutingSlip)routingSlip);
        if (laneParticipantType != null) {
            builder.append(HumanTaskHtmlBuilder.createLine(ProjectMsg.PERFORMER, laneParticipantType.getMsg().getString()));
            if (laneParticipantType.isCurrentLane()) {
                boolean isExcluded = HumanTaskBpm.isPreviousLaneParticipantExcluded((RoutingSlip)routingSlip);
                Msg msg = isExcluded ? CoreMsg.YES : CoreMsg.NO;
                builder.append(HumanTaskHtmlBuilder.createLine(HumantaskMsg.EXCLUDE_PREVIOUS_PARTICIPANTS, msg.getString()));
            }
        }
        HumanTaskBpm.PatternType patternType = HumanTaskBpm.getPatternType((HumanTask)humanTask);
        builder.append(HumanTaskHtmlBuilder.createLine(DesignerMsg.PATTERN, patternType.getString()));
        builder.append(HumanTaskHtmlBuilder.close(HTML.Tag.HTML));
        return builder.toString();
    }

    static String getOutcomes(Sequence<String> values) {
        StringBuilder builder = new StringBuilder();
        boolean isFirst = true;
        for (String value : values) {
            builder.append(isFirst ? value : ", " + value);
            isFirst = false;
        }
        return builder.toString();
    }

    private static String createLine(Msg name, String value) {
        return CoreMsg.COLON(name.getString()).getString() + START_EFFECT + value + END_EFFECT + HumanTaskHtmlBuilder.open(HTML.Tag.BR);
    }

    private static String open(HTML.Tag tag) {
        return "<" + tag.toString() + ">";
    }

    private static String close(HTML.Tag tag) {
        return "</" + tag.toString() + ">";
    }
}

