/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.humantask;

import oracle.bpm.designer.flowpanels.HumanTaskTypeCombo;
import oracle.bpm.designer.flowpanels.PriorityCombo;
import oracle.bpm.designer.humantask.EditorMode;
import oracle.bpm.designer.humantask.HumanTaskHtmlBuilder;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.HumanTaskType;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.soa.humantask.HumanTask;
import oracle.bpm.soa.humantask.HumanTaskBpm;
import oracle.bpm.soa.humantask.RoutingSlip;
import oracle.bpm.soa.humantask.WorkflowConfiguration;
import oracle.bpm.soa.humantask.msg.HumantaskMsg;
import oracle.bpm.ui.AbstractButton;
import oracle.bpm.ui.Box;
import oracle.bpm.ui.ButtonGroup;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.IdentifierTextField;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.RadioButton;
import oracle.bpm.ui.TabbedPane;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.CardLayout;
import oracle.bpm.ui.layout.FlowLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.NumericField;
import oracle.bpm.ui.text.TextField;

class HumanTaskEditorPanel
extends Panel {
    private HumanTaskEditorPanel(UiContainer parent, HumanTask humanTask, EditorMode mode) {
        super(parent);
        this.init(humanTask, mode);
    }

    public static HumanTaskEditorPanel create(UiContainer parent, HumanTask humanTask, EditorMode mode) {
        return new HumanTaskEditorPanel(parent, humanTask, mode);
    }

    private void init(HumanTask humanTask, EditorMode mode) {
        this.setLayout((Layout)new BorderLayout());
        TabbedPane tabbedPane = new TabbedPane((UiContainer)this);
        HumanTaskGeneralPanel generalPanel = new HumanTaskGeneralPanel((UiContainer)tabbedPane, humanTask, mode);
        tabbedPane.addTab(UIMsg.GENERAL, (UiComponent)generalPanel);
        this.add((UiComponent)tabbedPane, "Center");
    }

    private static class HumanTaskGeneralPanel
    extends Panel {
        private EditorMode editorMode;

        HumanTaskGeneralPanel(UiContainer parent, HumanTask humanTask, EditorMode mode) {
            super(parent);
            this.editorMode = mode;
            this.init(humanTask);
        }

        private static HumanTaskType getHumanTaskType(HumanTask humanTask) {
            HumanTaskBpm.PatternType patternType = HumanTaskBpm.getPatternType((HumanTask)humanTask);
            return HumanTaskGeneralPanel.getHumanTaskType(patternType);
        }

        private static HumanTaskType getHumanTaskType(HumanTaskBpm.PatternType pattern) {
            HumanTaskType result;
            switch (pattern) {
                case SIMPLE: {
                    result = HumanTaskType.SIMPLE;
                    break;
                }
                case FYI: {
                    result = HumanTaskType.FYI;
                    break;
                }
                case GROUP_VOTE: {
                    result = HumanTaskType.GROUP;
                    break;
                }
                case INITIATOR: {
                    result = HumanTaskType.INITIATOR;
                    break;
                }
                case MANAGEMENT: {
                    result = HumanTaskType.MANAGEMENT;
                    break;
                }
                default: {
                    result = HumanTaskType.COMPLEX;
                }
            }
            return result;
        }

        private void init(HumanTask humanTask) {
            this.setLayout((Layout)new MigLayout("fill, gapx 5, ins 5"));
            IdentifierTextField nameTextField = new IdentifierTextField((UiContainer)this, humanTask.getName(), 30, true);
            this.checkReadOnly((UiComponent)nameTextField);
            PriorityCombo priorityComboBox = new PriorityCombo((UiContainer)this);
            priorityComboBox.setSelectedItem(humanTask.getPriority());
            this.checkReadOnly((UiComponent)priorityComboBox);
            TextField titleTextField = new TextField((UiContainer)this, humanTask.getTitle().getValue(), 40);
            this.checkReadOnly((UiComponent)titleTextField);
            HumanTaskType humanTaskType = HumanTaskGeneralPanel.getHumanTaskType(humanTask);
            HumanTaskTypeCombo humanTaskTypeComboBox = HumanTaskTypeCombo.create((UiContainer)this, humanTaskType);
            this.checkReadOnly((UiComponent)humanTaskTypeComboBox);
            this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.NAME));
            this.add((UiComponent)nameTextField, "growx 70");
            this.add((UiComponent)Label.create((UiContainer)this, (Msg)ProjectModelMsg.VAR_PRIORITY_KEY));
            this.add((UiComponent)priorityComboBox, "growx 30, wrap");
            this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.TITLE));
            this.add((UiComponent)titleTextField, "spanx 3, growx, wrap");
            WorkflowConfiguration.Outcomes outcomes = humanTask.getWorkflowConfiguration().getOutcomes();
            String values = HumanTaskHtmlBuilder.getOutcomes(outcomes.getValues());
            TextField outcomesTextField = new TextField((UiContainer)this, values, 40);
            this.checkReadOnly((UiComponent)outcomesTextField);
            this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.OUTCOMES));
            this.add((UiComponent)outcomesTextField, "spanx 3, growx, wrap");
            this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.PATTERN));
            this.add((UiComponent)humanTaskTypeComboBox, "wrap");
            PropertiesCardPanel propertiesCardPanel = PropertiesCardPanel.create((UiContainer)this, humanTask, this.editorMode);
            this.add((UiComponent)propertiesCardPanel, "skip 1, spanx 3, growx, wrap");
        }

        private void checkReadOnly(UiComponent component) {
            component.setEnabled(!this.editorMode.isView());
        }

        private static class PropertiesCardPanel
        extends Panel {
            private PropertiesPanel activePanel = null;
            private CommonParticipantPanel commonPanel;
            private EditorMode editorMode;
            private EmptyPanel emptyPanel;
            private HumanTask humanTask;
            private ManagementPanel managementPanel;

            private PropertiesCardPanel(UiContainer parent, HumanTask humanTask, EditorMode mode) {
                super(parent);
                this.humanTask = humanTask;
                this.editorMode = mode;
                this.setLayout((Layout)new CardLayout());
                this.show(HumanTaskGeneralPanel.getHumanTaskType(humanTask));
            }

            public static PropertiesCardPanel create(UiContainer parent, HumanTask humanTask, EditorMode mode) {
                return new PropertiesCardPanel(parent, humanTask, mode);
            }

            public CardLayout getLayout() {
                return (CardLayout)super.getLayout();
            }

            public void show(HumanTaskType type) {
                String key = type.name();
                if (this.activePanel != null) {
                    this.remove((UiComponent)this.activePanel);
                }
                if (type.isManagement()) {
                    if (this.managementPanel == null) {
                        this.managementPanel = ManagementPanel.create((UiContainer)this, this.humanTask, this.editorMode);
                    }
                    this.add((UiComponent)this.managementPanel, key);
                    this.activePanel = this.managementPanel;
                } else if (type.isSimple() || type.isFyi() || type.isGroup()) {
                    if (this.commonPanel == null) {
                        this.commonPanel = CommonParticipantPanel.create((UiContainer)this, this.humanTask, this.editorMode);
                    }
                    this.add((UiComponent)this.commonPanel, key);
                    this.activePanel = this.commonPanel;
                } else {
                    if (this.emptyPanel == null) {
                        this.emptyPanel = EmptyPanel.create((UiContainer)this, this.humanTask, this.editorMode);
                    }
                    this.add((UiComponent)this.emptyPanel, key);
                    this.activePanel = this.emptyPanel;
                }
                this.getLayout().show((UiContainer)this, key);
            }

            private static class ManagementPanel
            extends LaneParticipantPanel {
                private NumericField<Integer> levelsNumericField;
                private TextField topParticipantTextField;

                private ManagementPanel(UiContainer parent, HumanTask humanTask, EditorMode mode) {
                    super(parent, humanTask, mode);
                    this.init();
                }

                public static ManagementPanel create(UiContainer parent, HumanTask humanTask, EditorMode mode) {
                    return new ManagementPanel(parent, humanTask, mode);
                }

                private static NumericField<Integer> createLevelsNumericField(UiContainer parent) {
                    NumericField result = NumericField.createIntegerNumericField((UiContainer)parent, (boolean)true);
                    result.setMinimum((Number)1);
                    result.setValue((Number)1);
                    return result;
                }

                private void init() {
                    this.setLayout((Layout)new MigLayout("fill, gapx 5, ins 0"));
                    this.addPerformerComponents((UiContainer)this);
                    this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.TOP_PARTICIPANT));
                    this.topParticipantTextField = new TextField((UiContainer)this, 30);
                    this.checkReadOnly((UiComponent)this.topParticipantTextField);
                    this.add((UiComponent)this.topParticipantTextField, "wrap");
                    this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.NUMBER_OF_LEVELS));
                    this.levelsNumericField = ManagementPanel.createLevelsNumericField((UiContainer)this);
                    this.checkReadOnly((UiComponent)this.levelsNumericField);
                    this.add((UiComponent)this.levelsNumericField, "wrap");
                }
            }

            private static class EmptyPanel
            extends PropertiesPanel {
                private EmptyPanel(UiContainer parent, HumanTask humanTask, EditorMode mode) {
                    super(parent, humanTask, mode);
                }

                public static EmptyPanel create(UiContainer parent, HumanTask humanTask, EditorMode mode) {
                    return new EmptyPanel(parent, humanTask, mode);
                }
            }

            private static class CommonParticipantPanel
            extends LaneParticipantPanel {
                private CommonParticipantPanel(UiContainer parent, HumanTask humanTask, EditorMode mode) {
                    super(parent, humanTask, mode);
                    this.init();
                }

                public static CommonParticipantPanel create(UiContainer parent, HumanTask humanTask, EditorMode mode) {
                    return new CommonParticipantPanel(parent, humanTask, mode);
                }

                private void init() {
                    this.setLayout((Layout)new MigLayout("fill, gapx 5, ins 0"));
                    this.addPerformerComponents((UiContainer)this);
                }
            }

            private static abstract class PropertiesPanel
            extends Panel {
                private EditorMode editorMode;
                private HumanTask humanTask;

                protected PropertiesPanel(UiContainer parent, HumanTask humanTask, EditorMode mode) {
                    super(parent, null);
                    this.humanTask = humanTask;
                    this.editorMode = mode;
                }

                protected void checkReadOnly(UiComponent component) {
                    component.setEnabled(!this.editorMode.isView());
                }

                protected HumanTask getHumanTask() {
                    return this.humanTask;
                }
            }

            private static abstract class LaneParticipantPanel
            extends PropertiesPanel {
                protected LaneParticipantPanel(UiContainer parent, HumanTask humanTask, EditorMode mode) {
                    super(parent, humanTask, mode);
                }

                protected void addPerformerComponents(UiContainer container) {
                    RoutingSlip routingSlip = this.getHumanTask().getRoutingSlip();
                    HumanTaskBpm.LaneParticipantType laneParticipantType = HumanTaskBpm.getLaneParticipantType((RoutingSlip)routingSlip);
                    if (laneParticipantType != null) {
                        Panel radioPanels = new Panel(container);
                        radioPanels.setLayout((Layout)new FlowLayout(0, 0, 0));
                        RadioButton currentLaneButton = new RadioButton((UiContainer)radioPanels, HumantaskMsg.CURRENT_LANE_PARTICIPANT);
                        currentLaneButton.setSelected(laneParticipantType.isCurrentLane());
                        this.checkReadOnly((UiComponent)currentLaneButton);
                        RadioButton previousLaneButton = new RadioButton((UiContainer)radioPanels, HumantaskMsg.PREVIOUS_LANE_PARTICIPANT);
                        previousLaneButton.setSelected(laneParticipantType.isPreviousLane());
                        this.checkReadOnly((UiComponent)previousLaneButton);
                        boolean isExcluded = HumanTaskBpm.isPreviousLaneParticipantExcluded((RoutingSlip)routingSlip);
                        CheckBox excludeCheckBox = CheckBox.create((UiContainer)container, (Msg)HumantaskMsg.EXCLUDE_PREVIOUS_PARTICIPANTS, (boolean)isExcluded);
                        this.checkReadOnly((UiComponent)excludeCheckBox);
                        ButtonGroup buttonGroup = new ButtonGroup();
                        buttonGroup.add((AbstractButton)currentLaneButton);
                        buttonGroup.add((AbstractButton)previousLaneButton);
                        radioPanels.add((UiComponent)currentLaneButton);
                        radioPanels.add(Box.createHorizontalStrut((UiContainer)radioPanels, (int)10));
                        radioPanels.add((UiComponent)previousLaneButton);
                        container.add((UiComponent)Label.create((UiContainer)container, (Msg)ProjectMsg.PERFORMER));
                        container.add((UiComponent)radioPanels, (Object)"growx, wrap");
                        container.add((UiComponent)excludeCheckBox, (Object)"skip 1, gapx 25, wrap");
                    }
                }
            }
        }
    }
}

