/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.flowpanels.AbstractCompositeEditor;
import oracle.bpm.designer.flowpanels.DefaultEditorBuilder;
import oracle.bpm.designer.flowpanels.DefaultRowEditorBuilder;
import oracle.bpm.designer.flowpanels.EditorBuilder;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesEditor;
import oracle.bpm.designer.flowpanels.HumanTaskPriorityExpressionPanelAdapter;
import oracle.bpm.designer.flowpanels.HumanTaskReinitiatePanel;
import oracle.bpm.designer.flowpanels.HumanTaskTitleExpressionPanelAdapter;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;

class UserTaskPreferencesEditor
extends AbstractCompositeEditor {
    public UserTaskPreferencesEditor(UserTask userTask) {
        super(DesignerMsg.HUMAN_TASK_ATTRIBUTES, (FlowNode)userTask);
    }

    public UserTask getFlowNode() {
        return (UserTask)super.getFlowNode();
    }

    @Override
    public boolean isCollapsed() {
        return false;
    }

    @Override
    public boolean shouldRender() {
        return super.shouldRender() && !AbstractStudioWorkbench.getInstance().isBusinessAnalyst();
    }

    @Override
    protected List<FlowNodePropertiesEditor> buildEditors() {
        ArrayList<FlowNodePropertiesEditor> result = new ArrayList<FlowNodePropertiesEditor>();
        result.add(new PreferencesEditor(this.getFlowNode()));
        return result;
    }

    private static class PreferencesEditor
    extends FlowNodePropertiesEditor {
        private PreferencesEditorBuilder builder;

        public PreferencesEditor(UserTask userTask) {
            this.builder = new PreferencesEditorBuilder(userTask);
        }

        @Override
        public void applyChanges() {
            this.builder.applyChanges();
        }

        @Override
        public EditorBuilder getEditorBuilder() {
            return this.builder;
        }

        @Override
        public void validate() throws ProjectException {
            this.builder.validate();
        }

        private static class PreferencesEditorBuilder
        extends DefaultEditorBuilder {
            private ArrayList<EditorBuilder.RowBuilder> builders = new ArrayList();
            private HumanTaskPriorityExpressionPanelAdapter priorityExpressionPanelAdapter;
            private HumanTaskReinitiatePanel reinitiatePanel;
            private HumanTaskTitleExpressionPanelAdapter titleExpressionPanelAdapter;

            public PreferencesEditorBuilder(final UserTask userTask) {
                this.builders.add(new DefaultRowEditorBuilder(DesignerMsg.TITLE){

                    @Override
                    public UiComponent createEditor(UiContainer parent) {
                        PreferencesEditorBuilder.this.titleExpressionPanelAdapter = HumanTaskTitleExpressionPanelAdapter.create(parent, userTask);
                        return PreferencesEditorBuilder.this.titleExpressionPanelAdapter.getUiComponent();
                    }
                });
                this.builders.add(new DefaultRowEditorBuilder(ProjectModelMsg.VAR_PRIORITY_KEY){

                    @Override
                    public UiComponent createEditor(UiContainer parent) {
                        PreferencesEditorBuilder.this.priorityExpressionPanelAdapter = HumanTaskPriorityExpressionPanelAdapter.create(parent, userTask);
                        return PreferencesEditorBuilder.this.priorityExpressionPanelAdapter.getUiComponent();
                    }
                });
                this.builders.add(new DefaultRowEditorBuilder(DesignerMsg.EMPTY_MSG("")){

                    @Override
                    public UiComponent createEditor(UiContainer parent) {
                        PreferencesEditorBuilder.this.reinitiatePanel = new HumanTaskReinitiatePanel(parent, userTask);
                        return PreferencesEditorBuilder.this.reinitiatePanel;
                    }
                });
            }

            @Override
            public List<EditorBuilder.RowBuilder> getBuilders() {
                return this.builders;
            }

            public void applyChanges() {
                this.titleExpressionPanelAdapter.applyChanges();
                this.priorityExpressionPanelAdapter.applyChanges();
                this.reinitiatePanel.applyChanges();
            }

            public void validate() throws ProjectException {
                this.titleExpressionPanelAdapter.validateEditor();
                this.reinitiatePanel.validateEditor();
            }
        }
    }
}

