/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.designer.flowpanels.DefaultEditorBuilder;
import oracle.bpm.designer.flowpanels.EditorBuilder;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesEditor;
import oracle.bpm.designer.flowpanels.SoaUserTaskRowEditorBuilder;
import oracle.bpm.project.model.catalog.HumanTask;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.HumanTaskType;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.project.view.filter.ProjectFilter;
import oracle.bpm.project.view.filter.ProjectFilters;

class UserTaskEditor
extends FlowNodePropertiesEditor {
    private UserTaskImplementationEditorBuilder builder;

    public UserTaskEditor(UserTask userTask) {
        this.builder = new UserTaskImplementationEditorBuilder(userTask);
    }

    @Override
    public void applyChanges() {
        this.builder.applyChanges();
    }

    @Override
    public EditorBuilder getEditorBuilder() {
        return this.builder;
    }

    private static class UserTaskImplementationEditorBuilder
    extends DefaultEditorBuilder {
        private SoaUserTaskRowEditorBuilder catalogObjectRowEditorBuilder;
        private HumanTask humanTask;
        private List<EditorBuilder.RowBuilder> rowBuilders = new ArrayList<EditorBuilder.RowBuilder>();

        public UserTaskImplementationEditorBuilder(UserTask userTask) {
            this.humanTask = userTask.getHumanTask();
            HumanTaskType humanTaskTypeFilter = null;
            if (!userTask.getHumanTaskType().isDefault() && this.humanTask == null) {
                humanTaskTypeFilter = userTask.getHumanTaskType();
            }
            ProjectFilters.HumanTaskFilter humanTaskFilter = ProjectFilters.HumanTaskFilter.create(humanTaskTypeFilter);
            this.catalogObjectRowEditorBuilder = new SoaUserTaskRowEditorBuilder(ProjectModelMsg.HUMAN_TASK, (ProjectFilter)humanTaskFilter, userTask);
            this.rowBuilders.add(this.catalogObjectRowEditorBuilder);
        }

        public void applyChanges() {
            this.catalogObjectRowEditorBuilder.applyChanges();
        }

        @Override
        public List<EditorBuilder.RowBuilder> getBuilders() {
            return this.rowBuilders;
        }
    }
}

