/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.designer.flowpanels.DefaultEditorBuilder;
import oracle.bpm.designer.flowpanels.DefaultRowEditorBuilder;
import oracle.bpm.designer.flowpanels.EditorBuilder;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesEditor;
import oracle.bpm.designer.flowpanels.HumanTaskApplicationContextPanel;
import oracle.bpm.designer.flowpanels.HumanTaskIdentificationContextPanel;
import oracle.bpm.designer.flowpanels.HumanTaskIdentificationKeyPanel;
import oracle.bpm.designer.flowpanels.HumanTaskInitiatorPanel;
import oracle.bpm.designer.flowpanels.HumanTaskOwnerPanel;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;

class UserTaskAdvancedEditor
extends FlowNodePropertiesEditor {
    private UserTaskEditorBuilder builder;

    public UserTaskAdvancedEditor(UserTask userTask) {
        this.builder = new UserTaskEditorBuilder(userTask);
    }

    @Override
    public void applyChanges() {
        this.builder.applyChanges();
    }

    @Override
    public EditorBuilder getEditorBuilder() {
        return this.builder;
    }

    @Override
    public void validate() throws ProjectException {
        this.builder.validate();
    }

    private static class UserTaskEditorBuilder
    extends DefaultEditorBuilder {
        private HumanTaskApplicationContextPanel applicationContextPanel;
        private List<EditorBuilder.RowBuilder> builders;
        private HumanTaskIdentificationContextPanel identificationContextPanel;
        private HumanTaskIdentificationKeyPanel identificationKeyPanel;
        private HumanTaskInitiatorPanel initiatorPanel;
        private HumanTaskOwnerPanel ownerPanel;
        private UserTask userTask;

        public UserTaskEditorBuilder(final UserTask userTask) {
            this.userTask = userTask;
            this.builders = new ArrayList<EditorBuilder.RowBuilder>();
            this.builders.add(new DefaultRowEditorBuilder(ProjectModelMsg.INITIATOR){

                @Override
                public UiComponent createEditor(UiContainer parent) {
                    UserTaskEditorBuilder.this.initiatorPanel = new HumanTaskInitiatorPanel(parent, userTask);
                    return UserTaskEditorBuilder.this.initiatorPanel;
                }
            });
            this.builders.add(new DefaultRowEditorBuilder(ProjectModelMsg.OWNER){

                @Override
                public UiComponent createEditor(UiContainer parent) {
                    UserTaskEditorBuilder.this.ownerPanel = new HumanTaskOwnerPanel(parent, userTask);
                    return UserTaskEditorBuilder.this.ownerPanel;
                }
            });
            this.builders.add(new DefaultRowEditorBuilder(ProjectModelMsg.ID_KEY){

                @Override
                public UiComponent createEditor(UiContainer parent) {
                    UserTaskEditorBuilder.this.identificationKeyPanel = new HumanTaskIdentificationKeyPanel(parent, userTask);
                    return UserTaskEditorBuilder.this.identificationKeyPanel;
                }
            });
            this.builders.add(new DefaultRowEditorBuilder(ProjectModelMsg.ID_CONTEXT){

                @Override
                public UiComponent createEditor(UiContainer parent) {
                    UserTaskEditorBuilder.this.identificationContextPanel = new HumanTaskIdentificationContextPanel(parent, userTask);
                    return UserTaskEditorBuilder.this.identificationContextPanel;
                }
            });
            this.builders.add(new DefaultRowEditorBuilder(ProjectModelMsg.APP_CONTEXT){

                @Override
                public UiComponent createEditor(UiContainer parent) {
                    UserTaskEditorBuilder.this.applicationContextPanel = new HumanTaskApplicationContextPanel(parent, userTask);
                    return UserTaskEditorBuilder.this.applicationContextPanel;
                }
            });
        }

        @Override
        public List<EditorBuilder.RowBuilder> getBuilders() {
            return this.builders;
        }

        public void applyChanges() {
            this.initiatorPanel.applyChanges();
            this.ownerPanel.applyChanges();
            this.identificationKeyPanel.applyChanges();
            this.identificationContextPanel.applyChanges();
            this.applicationContextPanel.applyChanges();
        }

        public void validate() throws ProjectException {
            this.initiatorPanel.validateEditor();
            this.ownerPanel.validateEditor();
            this.identificationKeyPanel.validateEditor();
            this.identificationContextPanel.validateEditor();
            this.applicationContextPanel.validateEditor();
        }
    }
}

