/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.designer.expression.ExpressionPanel;
import oracle.bpm.designer.expression.ExpressionPanelFactory;
import oracle.bpm.designer.flowpanels.SchedulePanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.FormatException;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.Time;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.XPathExpression;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.project.compile.msg.ProjectCompileMsg;
import oracle.bpm.project.model.OutOfCalendarPolicy;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.RescheduleRestrictionsPolicy;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.EventDefinition;
import oracle.bpm.project.model.processes.TimerEventDefinition;
import oracle.bpm.project.model.processes.TimerEventType;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.ComboBoxTabbedPane;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.RadioButtonsPanel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.ChangeEvent;
import oracle.bpm.ui.event.ChangeListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.CardLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.IntervalField;
import oracle.bpm.ui.text.NumericField;
import oracle.bpm.ui.text.TimeField;
import oracle.bpm.ui.text.ValueChangedEvent;
import oracle.bpm.ui.text.ValueChangedListener;
import org.jetbrains.annotations.NotNull;

public class TimerPanel
extends Panel {
    private ComboBoxTabbedPane<TimerEventType> comboBoxTabbedPane;
    private Event event;
    private Map<TimerEventType, TimerEditorPanel> timerPanels = new HashMap<TimerEventType, TimerEditorPanel>();
    private CheckBox checkBoxStartDate;
    private CheckBox checkBoxEndDate;
    private CheckBox checkBoxFixedNumber;
    private RadioButtonsPanel<RescheduleRestrictionsPolicy> rescheduleRestrictionsPolicyPanel;
    private RadioButtonsPanel<OutOfCalendarPolicy> outOfCalendarPolicyPanel;

    public TimerPanel(@NotNull UiContainer parent, @NotNull Event event) {
        super(parent, DesignerMsg.TIMER_DEFINITION);
        this.event = event;
        this.init();
    }

    public void validateInput() throws ProjectException {
        this.timerPanels.get(this.comboBoxTabbedPane.getSelectedItem()).validatePanel();
        if (this.getTimerEventDefinition().getOptionalFeatures().getStartDate() != null && this.getTimerEventDefinition().getOptionalFeatures().getEndDate() != null && this.getTimerEventDefinition().getOptionalFeatures().getStartDate().compareTo(this.getTimerEventDefinition().getOptionalFeatures().getEndDate()) > 0) {
            throw new ProjectException(null, DesignerMsg.START_DATE_GREATER_THAN_END_DATE);
        }
    }

    public void applyChanges() {
        TimerEventDefinition timerEventDefinition = this.getTimerEventDefinition();
        TimerEditorPanel panel = this.getActiveChangeEditorPanel();
        panel.applyValue(timerEventDefinition);
    }

    private void init() {
        this.setLayout((Layout)new MigLayout("ins 5, gap 0, fill"));
        this.comboBoxTabbedPane = new ComboBoxTabbedPane((UiContainer)this);
        this.comboBoxTabbedPane.setLabelProvider((LabelProvider)new LabelProvider.Default<TimerEventType>(){

            public String getText(TimerEventType type) {
                switch (type) {
                    case TIME_DATE: {
                        return ProjectModelMsg.TIME_DATE.getString();
                    }
                    case TIME_CYCLE: {
                        return ProjectModelMsg.TIME_CYCLE.getString();
                    }
                    case SCHEDULE: {
                        return ProjectModelMsg.TIME_SCHEDULE.getString();
                    }
                }
                return null;
            }
        });
        UiContainer uiContainer = this.comboBoxTabbedPane.getAddPoint();
        this.timerPanels.put(TimerEventType.TIME_DATE, ChangeEditorPanel.createForTimeDate(uiContainer, this.event));
        this.timerPanels.put(TimerEventType.TIME_CYCLE, ChangeEditorPanel.createForTimeCycle(uiContainer, this.event));
        this.timerPanels.put(TimerEventType.SCHEDULE, ChangeEditorPanel.createForSchedule(uiContainer, this.getTimerEventDefinition()));
        this.comboBoxTabbedPane.addTab((Object)TimerEventType.TIME_DATE, ProjectModelMsg.TIME_DATE, (UiComponent)this.timerPanels.get(TimerEventType.TIME_DATE));
        this.comboBoxTabbedPane.addTab((Object)TimerEventType.TIME_CYCLE, ProjectModelMsg.TIME_CYCLE, (UiComponent)this.timerPanels.get(TimerEventType.TIME_CYCLE));
        this.comboBoxTabbedPane.addTab((Object)TimerEventType.SCHEDULE, ProjectModelMsg.SCHEDULE, (UiComponent)this.timerPanels.get(TimerEventType.SCHEDULE));
        this.comboBoxTabbedPane.setValue((Object)this.getTimerEventDefinition().getType());
        this.comboBoxTabbedPane.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (TimerPanel.this.comboBoxTabbedPane.getSelectedItem() == TimerEventType.TIME_DATE) {
                    if (TimerPanel.this.checkBoxStartDate.isSelected()) {
                        TimerPanel.this.checkBoxStartDate.doClick();
                    }
                    if (TimerPanel.this.checkBoxEndDate.isSelected()) {
                        TimerPanel.this.checkBoxEndDate.doClick();
                    }
                    if (TimerPanel.this.checkBoxFixedNumber.isSelected()) {
                        TimerPanel.this.checkBoxFixedNumber.doClick();
                    }
                }
                TimerPanel.this.checkBoxStartDate.setEnabled(TimerPanel.this.comboBoxTabbedPane.getSelectedItem() != TimerEventType.TIME_DATE);
                TimerPanel.this.checkBoxEndDate.setEnabled(TimerPanel.this.comboBoxTabbedPane.getSelectedItem() != TimerEventType.TIME_DATE);
                TimerPanel.this.checkBoxFixedNumber.setEnabled(TimerPanel.this.comboBoxTabbedPane.getSelectedItem() != TimerEventType.TIME_DATE);
                TimerPanel.this.rescheduleRestrictionsPolicyPanel.setEnabled(TimerPanel.this.comboBoxTabbedPane.getSelectedItem() == TimerEventType.SCHEDULE && TimerPanel.this.getTimerEventDefinition().getOptionalFeatures().isUseCalendarRules() && TimerPanel.this.outOfCalendarPolicyPanel.getSelectedValue() != OutOfCalendarPolicy.NO_RESCHEDULE);
            }
        });
        this.add((UiComponent)this.comboBoxTabbedPane, "spanx, growx");
        this.add((UiComponent)this.createOptionalFields(this.getTimerEventDefinition().getOptionalFeatures(), (UiContainer)this), "spanx, growx");
    }

    private Panel createOptionalFields(final TimerEventDefinition.OptionalFeatures optionalFeatures, UiContainer parent) {
        Panel result = new Panel(parent, DesignerMsg.OPTIONAL_SETTINGS);
        result.setLayout((Layout)new MigLayout("ins 5, gap 5, fill"));
        final TimeField startDateField = new TimeField((UiContainer)result);
        final TimeField endDateField = new TimeField((UiContainer)result);
        final NumericField repetitionsField = NumericField.createIntegerNumericField((UiContainer)result, (boolean)true);
        this.checkBoxStartDate = CheckBox.create((UiContainer)result, (Msg)DesignerMsg.RUN_FROM, (optionalFeatures.getStartDate() != null ? 1 : 0) != 0);
        this.outOfCalendarPolicyPanel = new RadioButtonsPanel(parent, new ArrayList<OutOfCalendarPolicy>(Arrays.asList(OutOfCalendarPolicy.values())), true, DesignerMsg.OUT_OF_CALENDAR_POLICY, null);
        this.outOfCalendarPolicyPanel.setSelectedValue((Object)optionalFeatures.getOutOfCalendarPolicy());
        ArrayList<Msg> rescheduleToolTips = new ArrayList<Msg>();
        rescheduleToolTips.add(DesignerMsg.RESCHEDULE_POLICY_1);
        rescheduleToolTips.add(DesignerMsg.RESCHEDULE_POLICY_2);
        this.rescheduleRestrictionsPolicyPanel = new RadioButtonsPanel(parent, new ArrayList<RescheduleRestrictionsPolicy>(Arrays.asList(RescheduleRestrictionsPolicy.values())), false, DesignerMsg.RESCHEDULE_RESTRICTIONS_POLICY, rescheduleToolTips);
        this.rescheduleRestrictionsPolicyPanel.setSelectedValue((Object)optionalFeatures.getRescheduleRestrictionsPolicy());
        startDateField.setEnabled(optionalFeatures.getStartDate() != null);
        if (optionalFeatures.getStartDate() != null) {
            startDateField.setTime(optionalFeatures.getStartDate());
        }
        this.checkBoxStartDate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                startDateField.setEnabled(TimerPanel.this.checkBoxStartDate.isSelected());
                if (!TimerPanel.this.checkBoxStartDate.isSelected()) {
                    optionalFeatures.setStartDate(null);
                } else {
                    optionalFeatures.setStartDate(startDateField.getTime());
                }
            }
        });
        startDateField.addValueChangedListener(new ValueChangedListener(){

            public void valueChanged(ValueChangedEvent valuechangedevent) {
                optionalFeatures.setStartDate(startDateField.getTime());
            }
        });
        this.checkBoxEndDate = CheckBox.create((UiContainer)result, (Msg)DesignerMsg.RUN_TO, (optionalFeatures.getEndDate() != null ? 1 : 0) != 0);
        endDateField.setEnabled(optionalFeatures.getEndDate() != null);
        if (optionalFeatures.getEndDate() != null) {
            endDateField.setTime(optionalFeatures.getEndDate());
        }
        this.checkBoxEndDate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                endDateField.setEnabled(TimerPanel.this.checkBoxEndDate.isSelected());
                if (!TimerPanel.this.checkBoxEndDate.isSelected()) {
                    optionalFeatures.setEndDate(null);
                } else {
                    optionalFeatures.setEndDate(endDateField.getTime());
                }
            }
        });
        endDateField.addValueChangedListener(new ValueChangedListener(){

            public void valueChanged(ValueChangedEvent valuechangedevent) {
                optionalFeatures.setEndDate(endDateField.getTime());
            }
        });
        this.checkBoxFixedNumber = CheckBox.create((UiContainer)result, (Msg)DesignerMsg.REPETITIONS, (optionalFeatures.getRepetitions() != null ? 1 : 0) != 0);
        repetitionsField.setEnabled(optionalFeatures.getRepetitions() != null);
        repetitionsField.setMinimum((Number)1);
        final CheckBox calendarRulesOption = CheckBox.create((UiContainer)result, (Msg)UIMsg.USE_CALENDAR_RULES, (boolean)optionalFeatures.isUseCalendarRules());
        calendarRulesOption.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                optionalFeatures.setUseCalendarRules(calendarRulesOption.isSelected());
            }
        });
        if (optionalFeatures.getRepetitions() != null) {
            repetitionsField.setValue((Number)optionalFeatures.getRepetitions());
        } else {
            repetitionsField.setValue(repetitionsField.getMinimum());
        }
        this.checkBoxFixedNumber.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                repetitionsField.setEnabled(TimerPanel.this.checkBoxFixedNumber.isSelected());
                if (!TimerPanel.this.checkBoxFixedNumber.isSelected()) {
                    optionalFeatures.setRepetitions(null);
                } else {
                    optionalFeatures.setRepetitions((Integer)repetitionsField.getValue());
                }
            }
        });
        repetitionsField.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                optionalFeatures.setRepetitions((Integer)repetitionsField.getValue());
            }
        });
        calendarRulesOption.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TimerPanel.this.outOfCalendarPolicyPanel.setEnabled(calendarRulesOption.isSelected());
                TimerPanel.this.rescheduleRestrictionsPolicyPanel.setEnabled(optionalFeatures.isUseCalendarRules() && TimerPanel.this.outOfCalendarPolicyPanel.getSelectedValue() != OutOfCalendarPolicy.NO_RESCHEDULE);
            }
        });
        this.outOfCalendarPolicyPanel.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                optionalFeatures.setOutOfCalendarPolicy((OutOfCalendarPolicy)TimerPanel.this.outOfCalendarPolicyPanel.getSelectedValue());
            }
        });
        this.outOfCalendarPolicyPanel.setEnabled(optionalFeatures.isUseCalendarRules());
        this.outOfCalendarPolicyPanel.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                TimerPanel.this.rescheduleRestrictionsPolicyPanel.setEnabled(TimerPanel.this.comboBoxTabbedPane.getSelectedItem() == TimerEventType.SCHEDULE && TimerPanel.this.outOfCalendarPolicyPanel.getSelectedValue() != OutOfCalendarPolicy.NO_RESCHEDULE);
            }
        });
        this.rescheduleRestrictionsPolicyPanel.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                optionalFeatures.setRescheduleRestrictionsPolicy((RescheduleRestrictionsPolicy)TimerPanel.this.rescheduleRestrictionsPolicyPanel.getSelectedValue());
            }
        });
        this.rescheduleRestrictionsPolicyPanel.setEnabled(this.comboBoxTabbedPane.getSelectedItem() == TimerEventType.SCHEDULE && optionalFeatures.isUseCalendarRules() && this.outOfCalendarPolicyPanel.getSelectedValue() != OutOfCalendarPolicy.NO_RESCHEDULE);
        result.add((UiComponent)this.checkBoxStartDate);
        result.add((UiComponent)startDateField, (Object)" pushx, wrap");
        result.add((UiComponent)this.checkBoxEndDate);
        result.add((UiComponent)endDateField, (Object)"pushx, wrap");
        result.add((UiComponent)this.checkBoxFixedNumber);
        result.add((UiComponent)repetitionsField, (Object)"wrap");
        result.add((UiComponent)calendarRulesOption, (Object)"growx, wrap");
        result.add(this.outOfCalendarPolicyPanel, (Object)"growx, spanx 5, wrap");
        result.add(this.rescheduleRestrictionsPolicyPanel, (Object)"growx,  spanx 5");
        return result;
    }

    private TimerEventDefinition getTimerEventDefinition() {
        EventDefinition eventDefinition = this.event.getEventDefinition();
        return (TimerEventDefinition)eventDefinition.as(TimerEventDefinition.class);
    }

    private TimerEditorPanel getActiveChangeEditorPanel() {
        return this.timerPanels.get(this.comboBoxTabbedPane.getSelectedItem());
    }

    private static abstract class ChangeEditorPanel
    extends Panel
    implements TimerEditorPanel {
        CheckBox checkBox;
        private CardPanel cardPanel;
        private Event event;
        private TimerEventDefinition timerEventDefinition;

        public ChangeEditorPanel(UiContainer parent, Event event) {
            super(parent);
            this.event = event;
            this.timerEventDefinition = (TimerEventDefinition)event.getEventDefinition().as(TimerEventDefinition.class);
            this.init();
        }

        public static TimerEditorPanel createForTimeDate(UiContainer parent, Event event) {
            return new ChangeEditorPanelTimeDate(parent, event);
        }

        public static TimerEditorPanel createForTimeCycle(UiContainer parent, Event event) {
            return new ChangeEditorPanelTimeCycle(parent, event);
        }

        public static TimerEditorPanel createForSchedule(UiContainer parent, TimerEventDefinition timerEventDefinition) {
            return new SchedulePanel(parent, timerEventDefinition);
        }

        @Override
        public void applyValue(TimerEventDefinition timerEventDefinition) {
            this.cardPanel.getActivateEditor().applyValue(timerEventDefinition);
        }

        protected abstract void initCardPanel();

        protected CardPanel getCardPanel() {
            return this.cardPanel;
        }

        protected TimerEventDefinition getTimerEventDefinition() {
            return this.timerEventDefinition;
        }

        protected Event getEvent() {
            return this.event;
        }

        private void init() {
            this.setLayout((Layout)new MigLayout("ins 0, gap 0, fillx"));
            boolean isExpression = this.timerEventDefinition.isExpresion();
            this.checkBox = CheckBox.create((UiContainer)this, (Msg)DesignerMsg.USE_EXPRESSION, (boolean)isExpression);
            this.checkBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    ChangeEditorPanel.this.show(e.isStateSelected());
                }
            });
            this.cardPanel = new CardPanel((UiContainer)this);
            this.add((UiComponent)this.checkBox, "wrap");
            this.add((UiComponent)this.cardPanel, "growx, gapy 5");
            this.initCardPanel();
            this.show(isExpression);
        }

        private void show(boolean isExpression) {
            this.cardPanel.show(isExpression ? "ExpressionEditor" : "DefaultEditor");
        }

        private static class ChangeEditorPanelTimeDate
        extends ChangeEditorPanel {
            private ValueEventEditor expressionEditor;
            private ValueEventEditor timeEditor;

            public ChangeEditorPanelTimeDate(UiContainer parent, Event event) {
                super(parent, event);
            }

            @Override
            public void validatePanel() throws ProjectException {
                if (this.getCardPanel().isExpression()) {
                    this.expressionEditor.validateEditor();
                } else {
                    this.timeEditor.validateEditor();
                }
            }

            @Override
            protected void initCardPanel() {
                Expression dateExpression;
                Expression expression = null;
                Time timeDateValue = null;
                TimerEventDefinition timerEventDefinition = this.getTimerEventDefinition();
                boolean isTimeDate = timerEventDefinition.getType().equals((Object)TimerEventType.TIME_DATE);
                if (isTimeDate && (dateExpression = timerEventDefinition.getTimeDateExpression()) != null) {
                    try {
                        timeDateValue = Time.valueOf(XPathExpression.fromXPathLiteral(dateExpression.getExpressionValue()));
                    }
                    catch (FormatException e) {
                        expression = dateExpression;
                    }
                }
                CardPanel cardPanel = this.getCardPanel();
                this.timeEditor = ValueEventEditor.createTime((UiContainer)cardPanel, timeDateValue);
                cardPanel.add(this.timeEditor, "DefaultEditor");
                this.expressionEditor = ValueEventEditor.createExpresionForTimeDate((UiContainer)cardPanel, (DataDeclarationContainer)this.getEvent(), expression);
                cardPanel.add(this.expressionEditor, "ExpressionEditor");
            }
        }

        private static class ChangeEditorPanelTimeCycle
        extends ChangeEditorPanel {
            private ValueEventEditor expressionEditor;
            private ValueEventEditor intervalEditor;

            public ChangeEditorPanelTimeCycle(UiContainer parent, Event event) {
                super(parent, event);
            }

            @Override
            public void validatePanel() throws ProjectException {
                if (this.getCardPanel().isExpression()) {
                    this.expressionEditor.validateEditor();
                } else {
                    this.intervalEditor.validateEditor();
                }
            }

            @Override
            protected void initCardPanel() {
                Expression cycleExpression;
                Expression expression = null;
                Interval timeCycleValue = null;
                TimerEventDefinition timerEventDefinition = this.getTimerEventDefinition();
                boolean isTimeCycle = timerEventDefinition.getType().equals((Object)TimerEventType.TIME_CYCLE);
                if (isTimeCycle && (cycleExpression = timerEventDefinition.getTimeCycleExpression()) != null) {
                    try {
                        timeCycleValue = Interval.valueOf(XPathExpression.fromXPathLiteral(cycleExpression.getExpressionValue()));
                    }
                    catch (Exception e) {
                        expression = cycleExpression;
                    }
                }
                CardPanel cardPanel = this.getCardPanel();
                this.intervalEditor = ValueEventEditor.createInterval((UiContainer)cardPanel, timeCycleValue);
                cardPanel.add(this.intervalEditor, "DefaultEditor");
                this.expressionEditor = ValueEventEditor.createExpresionForTimeCycle((UiContainer)cardPanel, (DataDeclarationContainer)this.getEvent(), expression);
                cardPanel.add(this.expressionEditor, "ExpressionEditor");
            }
        }

        private static class ChangeEditorPanelSchedule
        extends ChangeEditorPanel {
            private ValueEventEditor expressionEditor;
            private ValueEventEditor timeEditor;

            public ChangeEditorPanelSchedule(UiContainer parent, Event event) {
                super(parent, event);
            }

            @Override
            public void validatePanel() throws ProjectException {
                if (this.getCardPanel().isExpression()) {
                    this.expressionEditor.validateEditor();
                } else {
                    this.timeEditor.validateEditor();
                }
            }

            @Override
            protected void initCardPanel() {
                Expression dateExpression;
                Expression expression = null;
                Time timeDateValue = null;
                TimerEventDefinition timerEventDefinition = this.getTimerEventDefinition();
                boolean isTimeDate = timerEventDefinition.getType().equals((Object)TimerEventType.TIME_DATE);
                if (isTimeDate && (dateExpression = timerEventDefinition.getTimeDateExpression()) != null) {
                    try {
                        timeDateValue = Time.valueOf(XPathExpression.fromXPathLiteral(dateExpression.getExpressionValue()));
                    }
                    catch (Exception e) {
                        expression = dateExpression;
                    }
                }
                CardPanel cardPanel = this.getCardPanel();
                this.timeEditor = ValueEventEditor.createTime((UiContainer)cardPanel, timeDateValue);
                cardPanel.add(this.timeEditor, "DefaultEditor");
                this.expressionEditor = ValueEventEditor.createExpresionForTimeDate((UiContainer)cardPanel, (DataDeclarationContainer)this.getEvent(), expression);
                cardPanel.add(this.expressionEditor, "ExpressionEditor");
            }
        }

        private static class CardPanel
        extends Panel {
            private String activateKey;
            private Map<String, ValueEventEditor> editors = new HashMap<String, ValueEventEditor>();
            private static final String DEFAULT_EDITOR = "DefaultEditor";
            private static final String EXPRESSION_EDITOR = "ExpressionEditor";

            public CardPanel(UiContainer parent) {
                super(parent);
                this.setLayout((Layout)new CardLayout());
            }

            public UiComponent add(ValueEventEditor editor, String key) {
                this.activateKey = key;
                this.editors.put(key, editor);
                return super.add((UiComponent)editor, (Object)key);
            }

            public CardLayout getLayout() {
                return (CardLayout)super.getLayout();
            }

            public void show(String key) {
                this.getLayout().show((UiContainer)this, key);
                this.activateKey = key;
            }

            public boolean isExpression() {
                return EXPRESSION_EDITOR.equals(this.activateKey);
            }

            public ValueEventEditor getActivateEditor() {
                return this.editors.get(this.activateKey);
            }
        }

        private static abstract class ValueEventEditor<E>
        extends Panel {
            ValueEventEditor(UiContainer parent) {
                super(parent);
            }

            public abstract void applyValue(TimerEventDefinition var1);

            public abstract UiComponent createEditor(UiContainer var1, E var2);

            public static ValueEventEditor createExpresionForTimeDate(UiContainer parent, DataDeclarationContainer context, Expression value) {
                return new ExpressionEditor(parent, context, true, value);
            }

            public static ValueEventEditor createExpresionForTimeCycle(UiContainer parent, DataDeclarationContainer context, Expression value) {
                return new ExpressionEditor(parent, context, false, value);
            }

            public static ValueEventEditor createTime(UiContainer parent, Time value) {
                return new TimeEditor(parent, value);
            }

            public static ValueEventEditor createInterval(UiContainer parent, Interval value) {
                return new IntervalEditor(parent, value);
            }

            protected void init(E value) {
                this.setLayout((Layout)new MigLayout("ins 0, gap 0, fillx"));
                this.add(this.createEditor((UiContainer)this, value), "growx");
            }

            abstract void validateEditor() throws ProjectException;

            private static class TimeEditor
            extends ValueEventEditor<Time> {
                private TimeField timeField;

                TimeEditor(UiContainer parent, Time value) {
                    super(parent);
                    this.init(value);
                }

                @Override
                public void applyValue(TimerEventDefinition timerEventDefinition) {
                    timerEventDefinition.setTimeDateExpression((Expression)XPathExpression.createConstantExpression(this.getValue().toXMLString()));
                }

                @Override
                public UiComponent createEditor(UiContainer parent, Time value) {
                    this.timeField = new TimeField(parent);
                    if (value != null) {
                        this.timeField.setTime(value);
                    }
                    return this.timeField;
                }

                @Override
                void validateEditor() throws ProjectException {
                }

                private Time getValue() {
                    return this.timeField.getTime();
                }
            }

            private static class IntervalEditor
            extends ValueEventEditor<Interval> {
                private IntervalField intervalField;

                IntervalEditor(UiContainer parent, Interval value) {
                    super(parent);
                    this.init(value);
                }

                @Override
                public void applyValue(TimerEventDefinition timerEventDefinition) {
                    timerEventDefinition.setTimeCycleExpression((Expression)XPathExpression.createConstantExpression(this.getValue().toXMLString()));
                }

                @Override
                public UiComponent createEditor(UiContainer parent, Interval value) {
                    this.intervalField = IntervalField.createPositiveIntervalField((UiContainer)parent);
                    if (value != null) {
                        this.intervalField.setInterval(value);
                    }
                    return this.intervalField;
                }

                @Override
                void validateEditor() throws ProjectException {
                }

                private Interval getValue() {
                    return this.intervalField.getInterval();
                }
            }

            private static class ExpressionEditor
            extends ValueEventEditor<Expression> {
                private DataDeclarationContainer context;
                private ExpressionPanel expressionPanel;
                private boolean isTimeDate;

                ExpressionEditor(UiContainer parent, DataDeclarationContainer context, boolean isTimeDate, Expression value) {
                    super(parent);
                    this.context = context;
                    this.isTimeDate = isTimeDate;
                    this.init(value);
                }

                @Override
                public void applyValue(TimerEventDefinition timerEventDefinition) {
                    if (this.isTimeDate) {
                        timerEventDefinition.setTimeDateExpression(this.expressionPanel.getExpression());
                    } else {
                        timerEventDefinition.setTimeCycleExpression(this.expressionPanel.getExpression());
                    }
                }

                @Override
                public UiComponent createEditor(UiContainer parent, Expression expression) {
                    Panel panel = new Panel(parent);
                    panel.setLayout((Layout)new MigLayout("ins 0, gap 0, fill"));
                    CatalogType resultType = this.isTimeDate ? CatalogType.Default.getTime() : CatalogType.Default.getInterval();
                    this.expressionPanel = ExpressionPanelFactory.createDefaultMultiLinePanel((UiContainer)panel, new ExpressionContext(this.context, resultType));
                    this.expressionPanel.setExpression(expression);
                    panel.add(this.expressionPanel.getUiComponent(), (Object)"growx, height 100!");
                    return panel;
                }

                @Override
                public void validateEditor() throws ProjectException {
                    Expression expression = this.expressionPanel.getExpression();
                    if (!this.expressionPanel.isExpressionValid()) {
                        throw new ProjectException((ProjectObject)this.context, DesignerMsg.INVALID_EXPRESSION);
                    }
                    if (expression == null || Str.isEmpty(expression.getExpressionValue())) {
                        throw new ProjectException((ProjectObject)this.context, ProjectCompileMsg.EMPTY_EXPRESSION_NOT_ALLOWED);
                    }
                }
            }
        }
    }

    public static interface TimerEditorPanel {
        public void validatePanel() throws ProjectException;

        public void applyValue(TimerEventDefinition var1);
    }
}

