/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import java.util.ArrayList;
import java.util.Arrays;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.HumanTaskData;
import oracle.bpm.designer.HumanTaskPreferences;
import oracle.bpm.designer.HumanTaskService;
import oracle.bpm.designer.action.ReloadCatalogAction;
import oracle.bpm.designer.flowpanels.SoaObjectRowEditorBuilder;
import oracle.bpm.designer.humantask.HumanTaskEditorDialog;
import oracle.bpm.designer.humantask.HumanTaskHtmlBuilder;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.draw.figure.FlowFigureType;
import oracle.bpm.draw.figure.FlowFigureUtils;
import oracle.bpm.draw.themes.DefaultTheme;
import oracle.bpm.draw.themes.ImageType;
import oracle.bpm.lang.Any;
import oracle.bpm.project.HumanTaskImpl;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.catalog.HumanTask;
import oracle.bpm.project.model.processes.HumanTaskType;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.project.view.filter.ProjectFilter;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.msg.UIMsg;
import org.jetbrains.annotations.NotNull;

public class SoaUserTaskRowEditorBuilder
extends SoaObjectRowEditorBuilder<HumanTask> {
    private Button infoButton;
    private final HumanTaskService service = AbstractStudioWorkbench.getInstance().getHumanTaskService();
    private UserTask userTask;

    public SoaUserTaskRowEditorBuilder(Msg msg, ProjectFilter projectFilter, UserTask userTask) {
        super(msg, userTask.getProject(), projectFilter, userTask.getHumanTask());
        this.userTask = userTask;
    }

    public void applyChanges() {
        HumanTask value = (HumanTask)this.getValue();
        if (!Any.equals(this.userTask.getHumanTask(), value)) {
            this.userTask.setHumanTask(value);
        }
    }

    public void setUserTask(UserTask userTask) {
        this.userTask = userTask;
    }

    public boolean isDirty() {
        return !Any.equals(this.userTask.getHumanTask(), this.getValue());
    }

    @Override
    public Image getCatalogObjectIcon(@NotNull HumanTask newValue) {
        Image result = null;
        HumanTaskType humanTaskType = newValue.getHumanTaskType();
        if (humanTaskType != null) {
            result = SoaUserTaskRowEditorBuilder.getImage(humanTaskType);
        }
        return result;
    }

    @Override
    public String getCatalogObjectToolTip(@NotNull HumanTask value) {
        oracle.bpm.soa.humantask.HumanTask task = ((HumanTaskImpl)value).getTask();
        return task == null ? null : HumanTaskHtmlBuilder.getInfo(task);
    }

    @Override
    protected Sequence<Button> createCustomButtons(UiContainer parent) {
        Sequence<Button> customButtons = super.createCustomButtons(parent);
        ArrayList<Button> list = new ArrayList<Button>();
        Button[] buttons = customButtons.toArray(new Button[0]);
        list.addAll(Arrays.asList(buttons));
        this.infoButton = this.createInfoButton(parent);
        this.infoButton.setEnabled(this.getValue() != null);
        list.add(this.infoButton);
        return CollectionUtils.asSequence(list);
    }

    @Override
    protected void addAction(UiWindow parent) {
        HumanTask newHumanTask;
        HumanTaskPreferences humanTaskPreferences = new HumanTaskPreferences();
        HumanTaskData humanTaskData = this.service.createHumanTask(parent, this.userTask, humanTaskPreferences);
        if (humanTaskData != null && (newHumanTask = humanTaskData.getHumanTask()) != null) {
            this.changeValue((CatalogObject)newHumanTask);
            if (!newHumanTask.getHumanTaskType().isInitiator()) {
                SoaUserTaskRowEditorBuilder.changeDataAssociation(this.userTask.getInputDataAssociationSet(), humanTaskData.getInputParameters());
            }
            SoaUserTaskRowEditorBuilder.changeDataAssociation(this.userTask.getOutputDataAssociationSet(), humanTaskData.getOutputParameters());
            new ReloadCatalogAction((CatalogObject)this.getProject().getCatalogRoot()).doIt();
        }
    }

    @Override
    protected void change(HumanTask newValue) {
        this.applyChanges();
        this.infoButton.setEnabled(newValue != null);
    }

    @Override
    protected Msg getBrowseTitle() {
        return DesignerMsg.BROWSE_HUMAN_TASKS;
    }

    private static Image getImage(HumanTaskType humanTaskType) {
        HumanTaskType type = humanTaskType == null ? HumanTaskType.SIMPLE : humanTaskType;
        FlowFigureType flowFigureType = FlowFigureUtils.fromUserTask((HumanTaskType)type);
        DefaultTheme theme = DesignerPreferences.getPreferences().getTheme();
        return theme.getImageFor(flowFigureType, ImageType.MINI_ICON);
    }

    private Button createInfoButton(UiContainer parent) {
        final Button result = SoaUserTaskRowEditorBuilder.createButton(parent, UIMsg.INFO);
        result.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HumanTask humanTask = (HumanTask)SoaUserTaskRowEditorBuilder.this.getValue();
                if (humanTask != null) {
                    oracle.bpm.soa.humantask.HumanTask task = ((HumanTaskImpl)humanTask).getTask();
                    HumanTaskEditorDialog dialog = HumanTaskEditorDialog.viewTask(result.getOwnerWindow(), task);
                    dialog.setVisible(true);
                }
            }
        });
        return result;
    }
}

