/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import java.util.ArrayList;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.Tuple;
import oracle.bpm.designer.flowpanels.CatalogObjectAddRowEditorBuilder;
import oracle.bpm.lib.Expression;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.project.compile.process.ExpressionHelper;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.processes.dataassociations.DataAssignment;
import oracle.bpm.project.model.processes.dataassociations.DataAssignmentItemEndpoint;
import oracle.bpm.project.model.processes.dataassociations.DataAssociation;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import oracle.bpm.project.view.filter.ProjectFilter;
import oracle.bpm.resources.Msg;
import org.jetbrains.annotations.NotNull;

public abstract class SoaObjectRowEditorBuilder<E extends CatalogObject>
extends CatalogObjectAddRowEditorBuilder<E> {
    public SoaObjectRowEditorBuilder(Msg msg, Project project, ProjectFilter projectFilter, E value) {
        super(msg, project, projectFilter, value);
    }

    protected static void changeDataAssociation(DataAssociationSet associationSet, Sequence<Tuple<String, String>> parameters) {
        associationSet.clearDataAssociations();
        Sequence<DataAssignment> dataAssociations = SoaObjectRowEditorBuilder.createDataAssociation(associationSet, parameters);
        for (DataAssignment dataAssignment : dataAssociations) {
            associationSet.addDataAssociation((DataAssociation)dataAssignment);
        }
    }

    private static Sequence<DataAssignment> createDataAssociation(DataAssociationSet dataAssociationSet, Sequence<Tuple<String, String>> parameters) {
        ArrayList<DataAssignment> result = new ArrayList<DataAssignment>();
        for (Tuple<String, String> tuple : parameters) {
            String sourceName = tuple.getFirst();
            String targetName = tuple.getSecond();
            DataAssignment dataAssignment = SoaObjectRowEditorBuilder.createSimpleDataAssociation(dataAssociationSet, sourceName, targetName);
            result.add(dataAssignment);
        }
        return CollectionUtils.asSequence(result);
    }

    private static DataAssignment createSimpleDataAssociation(@NotNull DataAssociationSet dataAssociationSet, @NotNull String sourceString, @NotNull String targetString) {
        DataAssignmentItemEndpoint targetEndpoint = DataAssignmentItemEndpoint.TARGET;
        DataDeclarationContainer targetContext = dataAssociationSet.getDataDeclarationContainer(targetEndpoint);
        Expression targetExpression = ExpressionHelper.createSimpleExpression((String)targetString, (ExpressionContext)new ExpressionContext(targetContext));
        CatalogType targetType = ExpressionHelper.getExpressionType((Expression)targetExpression, (ExpressionContext)new ExpressionContext(targetContext, true));
        DataAssignmentItemEndpoint sourceEndpoint = DataAssignmentItemEndpoint.SOURCE;
        DataDeclarationContainer sourceContext = dataAssociationSet.getDataDeclarationContainer(sourceEndpoint);
        Expression sourceExpression = ExpressionHelper.createSimpleExpression((String)sourceString, (ExpressionContext)new ExpressionContext(sourceContext, targetType));
        return dataAssociationSet.createDataAssignment(sourceExpression, targetExpression);
    }
}

