/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.designer.flowpanels.CatalogObjectRowEditorBuilder;
import oracle.bpm.designer.flowpanels.DefaultEditorBuilder;
import oracle.bpm.designer.flowpanels.EditorBuilder;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesEditor;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.catalog.SignalObject;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.EventDefinition;
import oracle.bpm.project.model.processes.SignalEventDefinition;
import oracle.bpm.project.view.filter.ProjectFilter;
import oracle.bpm.project.view.filter.ProjectFilters;
import oracle.bpm.resources.Msg;

class SignalEventEditor
extends FlowNodePropertiesEditor {
    private SignalEventEditorBuilder builder;

    public SignalEventEditor(Event event) {
        this.builder = new SignalEventEditorBuilder(event);
    }

    @Override
    public void applyChanges() {
        this.builder.applyChanges();
    }

    @Override
    public EditorBuilder getEditorBuilder() {
        return this.builder;
    }

    private static class SignalEventEditorBuilder
    extends DefaultEditorBuilder {
        private List<EditorBuilder.RowBuilder> builders;
        private Event event;
        private SignalObject signalObject;

        public SignalEventEditorBuilder(Event event) {
            this.event = event;
            this.signalObject = this.getSignalEventDefinition().getSignal();
            this.builders = new ArrayList<EditorBuilder.RowBuilder>();
            ProjectFilter selectorFilter = ProjectFilters.SIGNAL_OBJECT;
            this.builders.add(new CatalogObjectRowEditorBuilder<SignalObject>(DesignerMsg.EVENT, event.getProject(), selectorFilter, this.signalObject){

                @Override
                protected void change(SignalObject newValue) {
                    SignalEventEditorBuilder.this.signalObject = newValue;
                    SignalEventEditorBuilder.this.applyChanges();
                }

                @Override
                protected Msg getBrowseTitle() {
                    return DesignerMsg.BROWSE_EVENTS;
                }
            });
        }

        @Override
        public List<EditorBuilder.RowBuilder> getBuilders() {
            return this.builders;
        }

        public void applyChanges() {
            this.getSignalEventDefinition().setSignal(this.signalObject);
        }

        private SignalEventDefinition getSignalEventDefinition() {
            EventDefinition eventDefinition = this.getEvent().getEventDefinition();
            return (SignalEventDefinition)eventDefinition.as(SignalEventDefinition.class);
        }

        private Event getEvent() {
            return this.event;
        }
    }
}

