/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import oracle.bpm.designer.flowpanels.ElementsLinkEditor;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.panels.builder.EditableComponent;
import oracle.bpm.designer.serviceproperties.ServicePropertiesDialog;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.serviceproperties.ServicePropertiesEnabled;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;

public class ServicePropertiesSelectorPanel
extends Panel
implements EditableComponent<ServicePropertiesEnabled> {
    private ServicePropertiesEnabled servicePropertiesEnabled;

    public ServicePropertiesSelectorPanel(@NotNull UiContainer parent, @NotNull ServicePropertiesEnabled servicePropertiesEnabled) {
        super(parent);
        this.servicePropertiesEnabled = servicePropertiesEnabled;
        this.init();
    }

    @Override
    public void validateEditor() throws ProjectException {
    }

    @Override
    public void applyChanges() {
    }

    @Override
    public void populateValues() {
    }

    @Override
    public void loadValues() {
    }

    @Override
    public UiComponent getUiComponent() {
        return this;
    }

    @Override
    public ServicePropertiesEnabled getElement() {
        return this.servicePropertiesEnabled;
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public void setElement(ServicePropertiesEnabled element) {
        this.servicePropertiesEnabled = element;
    }

    private void init() {
        this.setLayout((Layout)new MigLayout("ins 0, gap 0"));
        this.add((UiComponent)this.createServicePropertiesLinkEditor((UiContainer)this));
    }

    private ElementsLinkEditor createServicePropertiesLinkEditor(@NotNull UiContainer parent) {
        ElementsLinkEditor result = new ElementsLinkEditor(parent, DesignerMsg.SERVICE_PROPERTIES, Image.create((Msg)DesignerMsg.SERVICE_PROPERTIES)){

            @Override
            protected boolean hasElements() {
                return ServicePropertiesSelectorPanel.this.hasServiceProperties();
            }

            @Override
            protected void clearElements() {
                if (MessageDialog.showQuestion((Msg)DesignerMsg.SERVICE_PROPERTIES, (Msg)DesignerMsg.CONFIRM_CLEAR_SERVICE_PROPERTIES, (int)6) == 2) {
                    ServicePropertiesSelectorPanel.this.clearServiceProperties();
                }
            }

            @Override
            protected void editElements() {
                ServicePropertiesDialog d = new ServicePropertiesDialog(this.getOwnerWindow(), ServicePropertiesSelectorPanel.this.servicePropertiesEnabled);
                d.setVisible(true);
            }
        };
        result.initialize();
        return result;
    }

    private void clearServiceProperties() {
        this.servicePropertiesEnabled.clearServiceProperties();
    }

    private boolean hasServiceProperties() {
        return this.servicePropertiesEnabled.hasServiceProperties();
    }
}

