/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import oracle.bpm.designer.flowpanels.ScheduleModel;
import oracle.bpm.designer.flowpanels.TimerPanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Month;
import oracle.bpm.lang.Week;
import oracle.bpm.project.model.Schedule;
import oracle.bpm.project.model.ScheduleEntry;
import oracle.bpm.project.model.ScheduleType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.TimerEventDefinition;
import oracle.bpm.project.ui.ComboBoxCell;
import oracle.bpm.project.ui.DayCell;
import oracle.bpm.project.ui.TimeCell;
import oracle.bpm.ui.Dialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.TabbedPane;
import oracle.bpm.ui.TableCell;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiType;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.table.BaseTablePanel;
import oracle.bpm.ui.table.TableColumn;
import oracle.bpm.ui.table.TableModel;
import oracle.bpm.ui.text.TimeField;
import org.jetbrains.annotations.NotNull;

public class SchedulePanel
extends Panel
implements TimerPanel.TimerEditorPanel {
    private ScheduleTable dailyScheduleTable;
    private ScheduleTable monthlyScheduleTable;
    private Schedule schedule;
    private TabbedPane scheduleTabbedPanel;
    private TimerEventDefinition timerEventDefinition;
    private ScheduleTable weeklyScheduleTable;

    public SchedulePanel(UiContainer parent, TimerEventDefinition timerEventDefinition) {
        super(parent);
        this.setLayout((Layout)new MigLayout("ins 0, gap 0, fill"));
        this.timerEventDefinition = timerEventDefinition;
        this.schedule = timerEventDefinition.getSchedule();
        if (this.schedule == null) {
            this.schedule = new Schedule();
        }
        this.scheduleTabbedPanel = new TabbedPane((UiContainer)this);
        this.dailyScheduleTable = this.createTablePanel((UiContainer)this.scheduleTabbedPanel, this.schedule, ScheduleType.DAILY);
        this.weeklyScheduleTable = this.createTablePanel((UiContainer)this.scheduleTabbedPanel, this.schedule, ScheduleType.WEEKLY);
        this.monthlyScheduleTable = this.createTablePanel((UiContainer)this.scheduleTabbedPanel, this.schedule, ScheduleType.MONTHLY);
        this.scheduleTabbedPanel.add((UiComponent)this.dailyScheduleTable, (Object)ScheduleType.DAILY.getString());
        this.scheduleTabbedPanel.add((UiComponent)this.weeklyScheduleTable, (Object)ScheduleType.WEEKLY.getString());
        this.scheduleTabbedPanel.add((UiComponent)this.monthlyScheduleTable, (Object)ScheduleType.MONTHLY.getString());
        this.add((UiComponent)this.scheduleTabbedPanel, "spanx, growx");
    }

    public static void main(String[] args) {
        UiType type = UiType.SWING;
        Ui.initialize((UiType)type);
        Dialog dialog = new Dialog(null);
        UiContainer container = dialog.getContentPane();
        SchedulePanel panel = new SchedulePanel(container, null);
        container.add((UiComponent)panel, (Object)"Center");
        dialog.setVisible(true);
    }

    @Override
    public void validatePanel() throws ProjectException {
        if (this.schedule.getAllEntries().isEmpty()) {
            throw new ProjectException(null, DesignerMsg.NO_SCHEDULE_ENTRIES_ERROR);
        }
    }

    @Override
    public void applyValue(TimerEventDefinition timerEventDefinition) {
        this.dailyScheduleTable.stopAllCellEditing();
        this.weeklyScheduleTable.stopAllCellEditing();
        this.monthlyScheduleTable.stopAllCellEditing();
        timerEventDefinition.setSchedule(this.schedule);
    }

    private ScheduleTable createTablePanel(UiContainer parent, Schedule schedule, ScheduleType scheduleType) {
        return new ScheduleTable(parent, schedule, scheduleType);
    }

    public static class ScheduleTable
    extends BaseTablePanel {
        private ScheduleType scheduleType;
        private static final int ROWS = 5;

        public ScheduleTable(@NotNull UiContainer parent, @NotNull Schedule schedule, @NotNull ScheduleType scheduleType) {
            super(parent, null, null, (TableModel)new ScheduleModel(schedule, scheduleType), BaseTablePanel.Style.TOOLBAR_RIGHT);
            this.scheduleType = scheduleType;
            this.table.setPreferredRows(5);
            TimeCell timeCell = new TimeCell(TimeField.Style.TIME, TimeField.Format.MEDIUM, Interval.class);
            ComboBoxCell monthCell = new ComboBoxCell((Object[])Month.values(), (Object)UIMsg.ALL);
            ComboBoxCell weekCell = new ComboBoxCell((Object[])Week.values(), (Object)UIMsg.DAY_OF_MONTH);
            DayCell dayCell = new DayCell(schedule, scheduleType);
            int column = 0;
            if (scheduleType == ScheduleType.MONTHLY) {
                this.setCell(column++, (TableCell)monthCell);
                this.setCell(column++, (TableCell)weekCell);
                this.setCell(column++, (TableCell)dayCell);
            } else if (scheduleType == ScheduleType.WEEKLY) {
                this.setCell(column++, (TableCell)dayCell);
            }
            this.setCell(column, (TableCell)timeCell);
        }

        public ScheduleModel getScheduleModel() {
            return (ScheduleModel)this.table.getModel();
        }

        public void stopAllCellEditing() {
            for (int i = 0; i < this.table.getColumnCount(); ++i) {
                this.table.getColumn(i).getCellEditor().stopCellEditing();
            }
        }

        protected void addAction() {
            this.getScheduleModel().addScheduleEntry(ScheduleEntry.create((ScheduleType)this.scheduleType));
            this.table.setSelectionInterval(this.table.getRowCount() - 1, this.table.getRowCount() - 1);
        }

        protected void deleteAction() {
            if (this.table.getCellEditor() != null) {
                this.table.getCellEditor().stopCellEditing();
            }
            this.getScheduleModel().removeScheduleEntry(this.table.getSelectedRow());
        }

        private void setCell(int column, TableCell tableCell) {
            TableColumn tc = this.table.getColumn(column);
            tc.setLabelProvider(tableCell.renderer());
            tc.setCellEditor(tableCell.editor());
            int width = tableCell.getMinimumSize().getWidth();
            int tcWidth = tc.getWidth();
            if (width > tcWidth) {
                tc.setWidth(width);
            }
        }
    }
}

