/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import oracle.bpm.project.model.Schedule;
import oracle.bpm.project.model.ScheduleEntry;
import oracle.bpm.project.model.ScheduleType;
import oracle.bpm.ui.table.AbstractTableModel;

class ScheduleModel
extends AbstractTableModel {
    private ScheduleEntry prototype;
    private Schedule schedule;

    public ScheduleModel(Schedule schedule, ScheduleType type) {
        this.schedule = schedule;
        this.prototype = ScheduleEntry.create((ScheduleType)type);
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    public Class getColumnClass(int columnIndex) {
        return this.getPrototype().getFieldClass(columnIndex);
    }

    public int getColumnCount() {
        return this.getPrototype().getFieldCount() - 1;
    }

    public String getColumnName(int column) {
        return this.getPrototype().getField(column).getString();
    }

    public int getRowCount() {
        return this.schedule.size(this.prototype.getType());
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex >= this.schedule.size(this.prototype.getType())) {
            return;
        }
        this.schedule.get(this.prototype.getType(), rowIndex).setFieldValue(columnIndex, aValue);
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.schedule.get(this.prototype.getType(), rowIndex).getFieldValue(columnIndex);
    }

    public Schedule getSchedule() {
        return this.schedule;
    }

    public void addScheduleEntry(ScheduleEntry scheduleEntry) {
        this.getSchedule().add(scheduleEntry);
        int insertPosition = this.getSchedule().size(scheduleEntry.getType()) - 1;
        this.fireTableRowsInserted(insertPosition, insertPosition);
    }

    public void removeScheduleEntry(int position) {
        int n = this.getSchedule().size(this.prototype.getType());
        if (n >= 1) {
            int selectedRow = position;
            if (selectedRow < 0 || selectedRow >= n) {
                selectedRow = n - 1;
            }
            this.getSchedule().remove(this.prototype.getType(), selectedRow);
            this.fireTableRowsDeleted(selectedRow, selectedRow);
        }
    }

    private ScheduleEntry getPrototype() {
        return this.prototype;
    }
}

