/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.designer.flowpanels.AbstractFlowNodePropertiesPanel;
import oracle.bpm.designer.flowpanels.DefaultEditorBuilder;
import oracle.bpm.designer.flowpanels.DefaultRowEditorBuilder;
import oracle.bpm.designer.flowpanels.EditorBuilder;
import oracle.bpm.designer.flowpanels.FlowNodeDescriptionPanel;
import oracle.bpm.designer.flowpanels.FlowNodeNamePanel;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesEditor;
import oracle.bpm.designer.flowpanels.PermissionPanel;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.features.ActivityPermissionFeature;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;

class NameAndDescriptionEditor
extends FlowNodePropertiesEditor {
    private NamePanelBuilder builder;

    public NameAndDescriptionEditor(FlowNode flowNode, AbstractFlowNodePropertiesPanel.ChangeTypeListener sealTypeListener) {
        this.builder = new NamePanelBuilder(flowNode, sealTypeListener);
    }

    @Override
    public void applyChanges() {
        this.builder.applyChanges();
    }

    @Override
    public EditorBuilder getEditorBuilder() {
        return this.builder;
    }

    @Override
    public void validate() throws ProjectException {
        this.builder.validate();
    }

    private static class NamePanelBuilder
    extends DefaultEditorBuilder {
        private ArrayList<EditorBuilder.RowBuilder> builders;
        private FlowNodeDescriptionPanel descriptionPanel;
        private FlowNode flowNode;
        private FlowNodeNamePanel namePanel;
        private PermissionPanel permissionPanel;

        public NamePanelBuilder(final FlowNode flowNode, final AbstractFlowNodePropertiesPanel.ChangeTypeListener sealTypeListener) {
            this.flowNode = flowNode;
            this.builders = new ArrayList();
            this.builders.add(new DefaultRowEditorBuilder(ProjectDrawMsg.NAME){

                @Override
                public UiComponent createEditor(UiContainer parent) {
                    NamePanelBuilder.this.namePanel = new FlowNodeNamePanel(parent, flowNode);
                    return NamePanelBuilder.this.namePanel;
                }
            });
            this.builders.add(new DefaultRowEditorBuilder(ProjectDrawMsg.DESCRIPTION){

                @Override
                public UiComponent createEditor(UiContainer parent) {
                    NamePanelBuilder.this.descriptionPanel = new FlowNodeDescriptionPanel(parent, flowNode);
                    return NamePanelBuilder.this.descriptionPanel;
                }
            });
            if (this.getProject().getPreferences().isTemplate()) {
                ActivityPermissionFeature activityPermissionFeature;
                boolean validFlowNode = true;
                if (flowNode.isGateway()) {
                    validFlowNode = BpmnType.COMPLEX_GATEWAY.equals((Object)flowNode.getBpmnType());
                }
                if (validFlowNode && (activityPermissionFeature = (ActivityPermissionFeature)this.flowNode.getFeature(ActivityPermissionFeature.class)) != null) {
                    this.builders.add(new DefaultRowEditorBuilder(LibMsg.PART_ROLE_INFO_PERMISSION){

                        @Override
                        public UiComponent createEditor(UiContainer parent) {
                            NamePanelBuilder.this.permissionPanel = new PermissionPanel(parent, activityPermissionFeature, sealTypeListener);
                            return NamePanelBuilder.this.permissionPanel;
                        }
                    });
                }
            }
        }

        @Override
        public List<EditorBuilder.RowBuilder> getBuilders() {
            return this.builders;
        }

        public void applyChanges() {
            this.namePanel.applyChanges();
            this.descriptionPanel.applyChanges();
            this.applyPermission();
        }

        public void validate() throws ProjectException {
            this.namePanel.validatePanel();
        }

        private void applyPermission() {
            ActivityPermissionFeature permission = (ActivityPermissionFeature)this.flowNode.getFeature(ActivityPermissionFeature.class);
            if (permission != null && this.permissionPanel != null) {
                this.permissionPanel.applyChanges();
            }
        }

        private Project getProject() {
            return this.flowNode.getProject();
        }
    }
}

