/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.designer.flowpanels.DefaultEditorBuilder;
import oracle.bpm.designer.flowpanels.DefaultRowEditorBuilder;
import oracle.bpm.designer.flowpanels.EditorBuilder;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesEditor;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;

public class MultipleLinksPropertiesEditor
extends FlowNodePropertiesEditor {
    private MultipleLinksEditorBuilder builder = new MultipleLinksEditorBuilder(3);

    @Override
    public EditorBuilder getEditorBuilder() {
        return this.builder;
    }

    @Override
    public void applyChanges() {
    }

    public void addLinkEditor(@NotNull FlowNodePropertiesEditor linkEditor) {
        this.builder.addEditor(linkEditor);
    }

    public boolean hasEditors() {
        return this.builder.hasEditors();
    }

    private static class MultipleLinksEditorBuilder
    extends DefaultEditorBuilder {
        private int columns;
        private List<FlowNodePropertiesEditor> editors = new ArrayList<FlowNodePropertiesEditor>();
        private List<EditorBuilder.RowBuilder> rowBuilders;

        public MultipleLinksEditorBuilder(int columns) {
            this.columns = columns;
            this.rowBuilders = new ArrayList<EditorBuilder.RowBuilder>();
            this.rowBuilders.add(new DefaultRowEditorBuilder(null){

                @Override
                public UiComponent createEditor(UiContainer parent) {
                    return MultipleLinksEditorBuilder.this.createLinksContainer(parent, MultipleLinksEditorBuilder.this.editors);
                }
            });
        }

        @Override
        public List<EditorBuilder.RowBuilder> getBuilders() {
            return this.rowBuilders;
        }

        public void addEditor(@NotNull FlowNodePropertiesEditor editor) {
            this.editors.add(editor);
        }

        public boolean hasEditors() {
            return !this.editors.isEmpty();
        }

        private UiComponent createLinksContainer(@NotNull UiContainer parent, @NotNull List<FlowNodePropertiesEditor> editors) {
            Panel result = new Panel(parent);
            result.setLayout((Layout)new MigLayout("ins 0, gap 0, fillx"));
            int col = 1;
            for (FlowNodePropertiesEditor editor : editors) {
                EditorBuilder editorBuilder = editor.getEditorBuilder();
                Panel placeHolderPanel = new Panel((UiContainer)result);
                placeHolderPanel.setLayout((Layout)new MigLayout("ins 0, gap 0"));
                editorBuilder.build(placeHolderPanel);
                String constraints = "growx";
                if (col++ >= this.columns) {
                    constraints = constraints + ",wrap";
                    col = 1;
                }
                result.add((UiComponent)placeHolderPanel, (Object)constraints);
            }
            return result;
        }
    }
}

