/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.designer.flowpanels.DefaultEditorBuilder;
import oracle.bpm.designer.flowpanels.DefaultRowEditorBuilder;
import oracle.bpm.designer.flowpanels.EditorBuilder;
import oracle.bpm.designer.flowpanels.ElementsLinkEditor;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesEditor;
import oracle.bpm.designer.messageheaders.MessageHeadersDialog;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.processes.messageheaders.InputMessageHeadersEnabled;
import oracle.bpm.project.model.processes.messageheaders.MessageHeadersEnabled;
import oracle.bpm.project.model.processes.messageheaders.OutputMessageHeadersEnabled;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import org.jetbrains.annotations.NotNull;

class MessageHeadersEditor
extends FlowNodePropertiesEditor {
    private MessageHeadersEditorBuilder builder;

    public MessageHeadersEditor(@NotNull MessageHeadersEnabled messages) {
        this.builder = new MessageHeadersEditorBuilder(messages);
    }

    @Override
    public EditorBuilder getEditorBuilder() {
        return this.builder;
    }

    @Override
    public void applyChanges() {
        this.builder.applyChanges();
    }

    private static class MessageHeadersEditorBuilder
    extends DefaultEditorBuilder {
        private List<EditorBuilder.RowBuilder> rowBuilders = new ArrayList<EditorBuilder.RowBuilder>();

        public MessageHeadersEditorBuilder(final @NotNull MessageHeadersEnabled messages) {
            this.rowBuilders.add(new DefaultRowEditorBuilder(null){

                @Override
                public UiComponent createEditor(UiContainer parent) {
                    return MessageHeadersEditorBuilder.this.createLinkEditor(parent, messages);
                }
            });
        }

        @Override
        public List<EditorBuilder.RowBuilder> getBuilders() {
            return this.rowBuilders;
        }

        public void applyChanges() {
        }

        private ElementsLinkEditor createLinkEditor(@NotNull UiContainer parent, final MessageHeadersEnabled messages) {
            ElementsLinkEditor result = new ElementsLinkEditor(parent, DesignerMsg.MESSAGE_HEADERS, Image.create((Msg)DesignerMsg.MESSAGE_HEADERS)){

                @Override
                protected boolean hasElements() {
                    boolean hasElements = false;
                    if (messages.isInputMessageHeadersEnable()) {
                        InputMessageHeadersEnabled input = (InputMessageHeadersEnabled)messages.asAnyNode(InputMessageHeadersEnabled.class);
                        boolean bl = hasElements = !input.getInputMessageHeaderSet().getMessageHeaders().isEmpty();
                    }
                    if (!hasElements && messages.isOutputMessageHeadersEnable()) {
                        OutputMessageHeadersEnabled output = (OutputMessageHeadersEnabled)messages.asAnyNode(OutputMessageHeadersEnabled.class);
                        hasElements = !output.getOutputMessageHeaderSet().getMessageHeaders().isEmpty();
                    }
                    return hasElements;
                }

                @Override
                protected void clearElements() {
                    if (MessageDialog.showQuestion((Msg)DesignerMsg.MESSAGE_HEADERS, (Msg)DesignerMsg.CONFIRM_CLEAR_MESSAGE_HEADERS, (int)6) == 2) {
                        if (messages.isInputMessageHeadersEnable()) {
                            InputMessageHeadersEnabled input = (InputMessageHeadersEnabled)messages.asAnyNode(InputMessageHeadersEnabled.class);
                            input.getInputMessageHeaderSet().clearMessageHeaders();
                        }
                        if (messages.isOutputMessageHeadersEnable()) {
                            OutputMessageHeadersEnabled output = (OutputMessageHeadersEnabled)messages.asAnyNode(OutputMessageHeadersEnabled.class);
                            output.getOutputMessageHeaderSet().clearMessageHeaders();
                        }
                    }
                }

                @Override
                protected void editElements() {
                    MessageHeadersDialog d = new MessageHeadersDialog(this.getOwnerWindow(), messages);
                    d.setVisible(true);
                }
            };
            result.initialize();
            return result;
        }
    }
}

