/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.designer.datadeclaration.DataDeclarationDialog;
import oracle.bpm.designer.expression.ExpressionPanel;
import oracle.bpm.designer.expression.ExpressionPanelFactory;
import oracle.bpm.designer.flowpanels.DefaultEditorBuilder;
import oracle.bpm.designer.flowpanels.DefaultRowEditorBuilder;
import oracle.bpm.designer.flowpanels.EditorBuilder;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesEditor;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.renderers.DataDeclarationRenderer;
import oracle.bpm.designer.selectorpanel.RadioButtonSelectorPanel;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.lang.Any;
import oracle.bpm.lib.Expression;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.InputDataAssociationEnabled;
import oracle.bpm.project.model.processes.Loop;
import oracle.bpm.project.model.processes.LoopCharacteristics;
import oracle.bpm.project.model.processes.LoopCharacteristicsType;
import oracle.bpm.project.model.processes.MultiInstance;
import oracle.bpm.project.model.processes.OutputDataAssociationEnabled;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import oracle.bpm.project.process.dataassociations.DataAssociationPropertiesManager;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.AbstractButton;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.ButtonGroup;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.RadioButton;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.ChangeEvent;
import oracle.bpm.ui.event.ChangeListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.NumericField;
import oracle.bpm.ui.text.TextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LoopCharacteristicsDataEditor
extends FlowNodePropertiesEditor {
    private LoopCharacteristicsDataBuilder builder;

    public LoopCharacteristicsDataEditor(@NotNull Subprocess subprocess) {
        this.builder = new LoopCharacteristicsDataBuilder(subprocess);
    }

    @Override
    public void validate() throws ProjectException {
        this.builder.validatePanel();
    }

    @Override
    public void applyChanges() {
        this.builder.applyChanges();
    }

    @Override
    public EditorBuilder getEditorBuilder() {
        return this.builder;
    }

    private static class LoopCharacteristicsDataBuilder
    extends DefaultEditorBuilder {
        private List<EditorBuilder.RowBuilder> builders;
        private CompletionConditionExpressionPanel completionConditionExpressionPanel;
        private LoopConditionExpressionPanel loopConditionExpressionPanel;
        private LoopCreationTypeSelectorPanel loopCreationTypeSelectorPanel;
        private LoopPanel loopPanel;
        private ModePanel modePanel;
        private final Subprocess subprocess;

        public LoopCharacteristicsDataBuilder(@NotNull Subprocess subprocess) {
            this.subprocess = subprocess;
            this.builders = this.createRowBuilders();
        }

        @Override
        public List<EditorBuilder.RowBuilder> getBuilders() {
            return this.builders;
        }

        public void applyChanges() {
            LoopCharacteristicsType type = this.subprocess.getLoopCharacteristicsType();
            LoopCharacteristics characteristics = this.subprocess.getLoopCharacteristics();
            if (characteristics != null) {
                if (type == LoopCharacteristicsType.MULTIINSTANCE) {
                    this.completionConditionExpressionPanel.panelToObject();
                    this.loopCreationTypeSelectorPanel.panelToObject();
                    this.modePanel.panelToObject();
                } else {
                    this.loopConditionExpressionPanel.panelToObject();
                    this.loopPanel.panelToObject();
                }
            }
        }

        public void validatePanel() throws ProjectException {
            LoopCharacteristicsType type = this.subprocess.getLoopCharacteristicsType();
            if (type == LoopCharacteristicsType.MULTIINSTANCE) {
                this.loopCreationTypeSelectorPanel.validatePanel();
                this.completionConditionExpressionPanel.validatePanel();
                this.modePanel.validatePanel();
            } else if (type == LoopCharacteristicsType.LOOP) {
                this.loopConditionExpressionPanel.validatePanel();
                this.loopPanel.validatePanel();
            }
        }

        private List<EditorBuilder.RowBuilder> createRowBuilders() {
            ArrayList<EditorBuilder.RowBuilder> result = new ArrayList<EditorBuilder.RowBuilder>();
            LoopCharacteristicsType type = this.subprocess.getLoopCharacteristicsType();
            LoopCharacteristics characteristics = this.subprocess.getLoopCharacteristics();
            if (characteristics != null) {
                if (type == LoopCharacteristicsType.MULTIINSTANCE) {
                    final MultiInstance multiInstance = (MultiInstance)characteristics.as(MultiInstance.class);
                    result.add(new DefaultRowEditorBuilder(null){

                        @Override
                        public UiComponent createEditor(UiContainer parent) {
                            LoopCharacteristicsDataBuilder.this.modePanel = new ModePanel(parent, multiInstance, LoopCharacteristicsDataBuilder.this.subprocess);
                            LoopCharacteristicsDataBuilder.this.modePanel.objectToPanel();
                            return LoopCharacteristicsDataBuilder.this.modePanel;
                        }
                    });
                    result.add(new DefaultRowEditorBuilder(null){

                        @Override
                        public UiComponent createEditor(UiContainer parent) {
                            LoopCharacteristicsDataBuilder.this.loopCreationTypeSelectorPanel = new LoopCreationTypeSelectorPanel(parent, multiInstance, LoopCharacteristicsDataBuilder.this.subprocess);
                            LoopCharacteristicsDataBuilder.this.loopCreationTypeSelectorPanel.objectToPanel();
                            return LoopCharacteristicsDataBuilder.this.loopCreationTypeSelectorPanel;
                        }
                    });
                    result.add(new DefaultRowEditorBuilder(null){

                        @Override
                        public UiComponent createEditor(UiContainer parent) {
                            LoopCharacteristicsDataBuilder.this.completionConditionExpressionPanel = new CompletionConditionExpressionPanel(parent, multiInstance, LoopCharacteristicsDataBuilder.this.subprocess);
                            LoopCharacteristicsDataBuilder.this.completionConditionExpressionPanel.objectToPanel();
                            return LoopCharacteristicsDataBuilder.this.completionConditionExpressionPanel;
                        }
                    });
                } else if (type == LoopCharacteristicsType.LOOP) {
                    final Loop loop = (Loop)characteristics.as(Loop.class);
                    result.add(new DefaultRowEditorBuilder(null){

                        @Override
                        public UiComponent createEditor(UiContainer parent) {
                            LoopCharacteristicsDataBuilder.this.loopConditionExpressionPanel = new LoopConditionExpressionPanel(parent, loop, LoopCharacteristicsDataBuilder.this.subprocess);
                            LoopCharacteristicsDataBuilder.this.loopConditionExpressionPanel.objectToPanel();
                            return LoopCharacteristicsDataBuilder.this.loopConditionExpressionPanel;
                        }
                    });
                    result.add(new DefaultRowEditorBuilder(null){

                        @Override
                        public UiComponent createEditor(UiContainer parent) {
                            LoopCharacteristicsDataBuilder.this.loopPanel = new LoopPanel(parent, loop);
                            LoopCharacteristicsDataBuilder.this.loopPanel.objectToPanel();
                            return LoopCharacteristicsDataBuilder.this.loopPanel;
                        }
                    });
                }
            }
            return result;
        }

        private class ModePanel
        extends MultiInstancePropertiesEditorPanel {
            private RadioButton parallelRadio;
            private RadioButton sequentialRadio;

            private ModePanel(@NotNull UiContainer parent, @NotNull MultiInstance multiInstance, Subprocess subprocess) {
                super(parent, multiInstance, subprocess, DesignerMsg.MODE);
                this.init();
            }

            @Override
            public void validatePanel() throws ProjectException {
            }

            @Override
            public void objectToPanel() {
                this.sequentialRadio.setSelected(this.getMultiInstance().isSequential());
            }

            @Override
            public void panelToObject() {
                this.getMultiInstance().setSequential(this.sequentialRadio.isSelected());
            }

            private void init() {
                this.setLayout((Layout)new MigLayout("ins 5, gap 5"));
                this.parallelRadio = new RadioButton((UiContainer)this, DesignerMsg.PARALLEL);
                this.sequentialRadio = new RadioButton((UiContainer)this, DesignerMsg.SEQUENTIAL);
                ButtonGroup buttonGroup = new ButtonGroup();
                buttonGroup.add((AbstractButton)this.parallelRadio);
                buttonGroup.add((AbstractButton)this.sequentialRadio);
                this.add((UiComponent)this.sequentialRadio);
                this.add((UiComponent)this.parallelRadio);
                this.parallelRadio.setSelected(true);
            }
        }

        private class LoopPanel
        extends Panel
        implements LoopPropertiesEditor {
            private CheckBox beforeCheckBox;
            private final int DEFAULT_VALUE = 1;
            private final Loop loop;
            private CheckBox loopMaximumCheckBox;
            private NumericField<Integer> loopMaximumNumericField;

            private LoopPanel(@NotNull UiContainer parent, Loop loop) {
                super(parent);
                this.DEFAULT_VALUE = 1;
                this.loop = loop;
                this.buildPanel();
            }

            @Override
            public void objectToPanel() {
                boolean hasLoopMaximum = this.loop.hasLoopMaximum();
                this.loopMaximumCheckBox.setSelected(hasLoopMaximum);
                if (hasLoopMaximum) {
                    int value = this.loop.getLoopMaximum();
                    this.loopMaximumNumericField.setValue((Number)(value < 1 ? 1 : value));
                }
                this.beforeCheckBox.setSelected(this.loop.isTestBefore());
            }

            @Override
            public void panelToObject() {
                boolean hasLoopMaximum = this.loopMaximumCheckBox.isSelected();
                this.loop.setHasLoopMaximum(hasLoopMaximum);
                this.loop.setLoopMaximum(hasLoopMaximum ? (Integer)this.loopMaximumNumericField.getValue() : 1);
                this.loop.setTestBefore(this.beforeCheckBox.isSelected());
            }

            @Override
            public void validatePanel() throws ProjectException {
            }

            private void buildPanel() {
                this.setLayout((Layout)new MigLayout("gap 5, ins 5"));
                this.loopMaximumCheckBox = CheckBox.create((UiContainer)this, (Msg)DesignerMsg.LOOP_MAXIMUM);
                this.loopMaximumCheckBox.addItemListener(new ItemListener(){

                    public void itemStateChanged(ItemEvent e) {
                        LoopPanel.this.loopMaximumNumericField.setEnabled(e.isStateSelected());
                    }
                });
                this.loopMaximumNumericField = NumericField.createIntegerNumericField((UiContainer)this, (boolean)true);
                this.loopMaximumNumericField.setMinimum((Number)1);
                this.loopMaximumNumericField.setValue((Number)1);
                this.loopMaximumNumericField.setEnabled(false);
                this.beforeCheckBox = CheckBox.create((UiContainer)this, (Msg)ProjectModelMsg.BEFORE);
                this.add((UiComponent)this.loopMaximumCheckBox);
                this.add((UiComponent)this.loopMaximumNumericField, "wrap");
                this.add((UiComponent)Label.create((UiContainer)this, (Msg)ProjectModelMsg.BEFORE_AFTER));
                this.add((UiComponent)this.beforeCheckBox, "wrap");
            }
        }

        private static class LoopDataSelector
        extends Panel {
            private boolean isInput;
            private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
            private DataDeclaration loopData;
            private TextField loopDataTextField;
            private Subprocess subprocess;

            public LoopDataSelector(@NotNull UiContainer parent, @NotNull Subprocess subprocess, boolean isInput) {
                super(parent);
                this.subprocess = subprocess;
                this.isInput = isInput;
                this.init();
            }

            public void addChangeListener(@NotNull ChangeListener listener) {
                this.listeners.add(listener);
            }

            public void removeChangeListener(@NotNull ChangeListener listener) {
                this.listeners.remove(listener);
            }

            public DataDeclaration getLoopData() {
                return this.loopData;
            }

            public void setLoopData(@Nullable DataDeclaration loopData) {
                if (Any.equals(this.loopData, loopData)) {
                    return;
                }
                this.loopData = loopData;
                this.updateLoopDataTextField();
                this.fireStateChanged();
            }

            private void init() {
                this.setLayout((Layout)new MigLayout("ins 0, gap 5, fillx"));
                this.loopDataTextField = new TextField((UiContainer)this);
                this.loopDataTextField.setEnabled(false);
                this.add((UiComponent)this.loopDataTextField, "growx");
                Button editButton = Button.createIconic((UiContainer)this, (Msg)UIMsg.EDIT);
                editButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        LoopDataSelector.this.editLoopData();
                    }
                });
                this.add((UiComponent)editButton);
                Button removeButton = Button.createIconic((UiContainer)this, (Msg)UIMsg.REMOVE);
                removeButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        LoopDataSelector.this.setLoopData(null);
                    }
                });
                this.add((UiComponent)removeButton);
            }

            private void updateLoopDataTextField() {
                String loopDataText = null;
                if (this.loopData != null) {
                    loopDataText = new DataDeclarationRenderer().getLabel(this.loopData);
                }
                this.loopDataTextField.setText(loopDataText);
            }

            private DataDeclarationContainer getLoopDataArgumentContainer() {
                return this.isInput ? this.subprocess.getInputArgumentsContainer() : this.subprocess.getOutputArgumentsContainer();
            }

            private void editLoopData() {
                String name = this.getLoopData() != null ? this.getLoopData().getName() : this.createDefaultLoopDataName();
                CatalogType type = this.getLoopData() != null ? this.getLoopData().getType() : CatalogType.Default.getArray((CatalogType)CatalogType.Default.getString());
                try {
                    DataDeclaration loopDataArgument = this.getLoopDataArgumentContainer().createDeclaration(name, type);
                    DataDeclarationDialog dialog = DataDeclarationDialog.createForLoopDataArgument(Ui.getRoot(), loopDataArgument, CollectionUtils.<DataDeclaration>emptySequence());
                    dialog.setVisible(true);
                    if (dialog.userAccepted()) {
                        this.setLoopData(loopDataArgument);
                    }
                }
                catch (ProjectException ex) {
                    MessageDialog.showError((Throwable)ex);
                }
            }

            private String createDefaultLoopDataName() {
                return this.isInput ? "loopDataInput" : "loopDataOutput";
            }

            private void fireStateChanged() {
                ChangeEvent e = new ChangeEvent((Object)this);
                for (ChangeListener listener : this.listeners) {
                    listener.stateChanged(e);
                }
            }
        }

        private static class LoopDataPanel
        extends MultiInstancePropertiesEditorPanel {
            private DataAssociationPropertiesManager dataAssociationPropertiesManager;
            private boolean isInput;
            private ExpressionPanel loopDataExpressionPanel;
            private LoopDataSelector loopDataSelector;

            public LoopDataPanel(@NotNull UiContainer parent, @NotNull MultiInstance multiInstance, @NotNull Subprocess subprocess, boolean isInput) {
                super(parent, multiInstance, subprocess, isInput ? DesignerMsg.LOOP_DATA_INPUT : DesignerMsg.LOOP_DATA_OUTPUT);
                this.isInput = isInput;
                this.init();
            }

            @Override
            public void validatePanel() throws ProjectException {
                if (this.isInput && this.loopDataSelector.getLoopData() == null) {
                    throw new ProjectException((ProjectObject)this.getSubprocess(), DesignerMsg.DYNAMIC_NOT_NULL(DesignerMsg.LOOP_DATA_INPUT));
                }
                if (this.loopDataSelector.getLoopData() != null) {
                    Msg label;
                    Msg msg = label = this.isInput ? DesignerMsg.LOOP_DATA_INPUT_EXPRESSION : DesignerMsg.LOOP_DATA_OUTPUT_EXPRESSION;
                    if (this.loopDataExpressionPanel.getExpression() == null) {
                        throw new ProjectException((ProjectObject)this.getSubprocess(), DesignerMsg.DYNAMIC_NOT_NULL(label));
                    }
                    if (!this.loopDataExpressionPanel.isExpressionValid()) {
                        throw new ProjectException((ProjectObject)this.getSubprocess(), DesignerMsg.DYNAMIC_INVALID(label));
                    }
                }
            }

            @Override
            public void panelToObject() {
                DataDeclaration loopData;
                DataDeclaration currentLoopData = this.isInput ? this.getMultiInstance().getLoopDataInput() : this.getMultiInstance().getLoopDataOutput();
                if (currentLoopData != null) {
                    if (this.isInput) {
                        this.getMultiInstance().setLoopDataInput(null);
                    } else {
                        this.getMultiInstance().setLoopDataOutput(null);
                    }
                    Expression property = this.dataAssociationPropertiesManager.createProperty(currentLoopData.getName());
                    this.dataAssociationPropertiesManager.setExpression(property, null);
                    try {
                        this.getLoopDataArgumentContainer().removeDeclaration(currentLoopData);
                    }
                    catch (ProjectException e) {
                        MessageDialog.showError((Throwable)e);
                    }
                }
                if ((loopData = this.loopDataSelector.getLoopData()) != null) {
                    DataDeclarationContainer argumentsContainer = this.getLoopDataArgumentContainer();
                    try {
                        argumentsContainer.addDeclaration(loopData);
                    }
                    catch (ProjectException e) {
                        MessageDialog.showError((Throwable)e);
                    }
                    if (this.isInput) {
                        this.getMultiInstance().setLoopDataInput(loopData);
                    } else {
                        this.getMultiInstance().setLoopDataOutput(loopData);
                    }
                    Expression property = this.dataAssociationPropertiesManager.createProperty(loopData.getName());
                    this.dataAssociationPropertiesManager.setExpression(property, this.loopDataExpressionPanel.getExpression());
                }
            }

            @Override
            public void objectToPanel() {
                DataDeclaration loopData = this.isInput ? this.getMultiInstance().getLoopDataInput() : this.getMultiInstance().getLoopDataOutput();
                if (loopData != null) {
                    this.loopDataSelector.setLoopData(loopData);
                    Expression property = this.dataAssociationPropertiesManager.createProperty(loopData.getName());
                    Expression expression = this.dataAssociationPropertiesManager.getExpression(property);
                    this.loopDataExpressionPanel.setExpression(expression);
                }
            }

            private void init() {
                this.dataAssociationPropertiesManager = this.isInput ? DataAssociationPropertiesManager.createInput((InputDataAssociationEnabled)((InputDataAssociationEnabled)this.getSubprocess().asAnyNode(InputDataAssociationEnabled.class))) : DataAssociationPropertiesManager.createOutput((OutputDataAssociationEnabled)((OutputDataAssociationEnabled)this.getSubprocess().asAnyNode(OutputDataAssociationEnabled.class)));
                this.setLayout((Layout)new MigLayout("ins 0, gap 5, fillx, hidemode 3"));
                this.add((UiComponent)Label.create((UiContainer)this, (Msg)(this.isInput ? DesignerMsg.INPUT : DesignerMsg.OUTPUT)));
                this.loopDataSelector = new LoopDataSelector((UiContainer)this, this.getSubprocess(), this.isInput);
                this.add((UiComponent)this.loopDataSelector, "growx, wrap");
                this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.EXPRESSION));
                ExpressionContext expressionContext = this.createExpressionContext(null, !this.isInput);
                this.loopDataExpressionPanel = ExpressionPanelFactory.createDefaultSingleLinePanel((UiContainer)this, expressionContext);
                this.loopDataExpressionPanel.getUiComponent().makeRecyclable();
                this.add(this.loopDataExpressionPanel.getUiComponent(), "growx");
                this.loopDataSelector.addChangeListener(new ChangeListener(){

                    public void stateChanged(ChangeEvent e) {
                        LoopDataPanel.this.updateExpressionPanel();
                    }
                });
                this.updateExpressionPanel();
            }

            private void updateExpressionPanel() {
                DataDeclaration loopData = this.loopDataSelector.getLoopData();
                if (loopData != null) {
                    CatalogType type = loopData.getType();
                    ExpressionContext expressionContext = this.createExpressionContext(type, !this.isInput);
                    this.loopDataExpressionPanel.setContext(expressionContext);
                } else {
                    this.loopDataExpressionPanel.setExpression(null);
                }
                this.loopDataExpressionPanel.setEnabled(loopData != null);
            }

            private ExpressionContext createExpressionContext(@Nullable CatalogType type, boolean isLValue) {
                DataDeclarationContainer container = this.getDataAssociationSet().getDataObjectsContainer();
                return new ExpressionContext(container, type, isLValue);
            }

            private DataAssociationSet getDataAssociationSet() {
                return this.isInput ? this.getSubprocess().getInputDataAssociationSet() : this.getSubprocess().getOutputDataAssociationSet();
            }

            private DataDeclarationContainer getLoopDataArgumentContainer() {
                return this.isInput ? this.getSubprocess().getInputArgumentsContainer() : this.getSubprocess().getOutputArgumentsContainer();
            }
        }

        private static class LoopDataInputOutputPanel
        extends MultiInstancePropertiesEditorPanel {
            private LoopDataPanel inputPanel;
            private LoopDataPanel outputPanel;

            private LoopDataInputOutputPanel(@NotNull UiContainer parent, @NotNull MultiInstance multiInstance, @NotNull Subprocess subprocess) {
                super(parent, multiInstance, subprocess, null);
                this.init();
            }

            @Override
            public void validatePanel() throws ProjectException {
                this.inputPanel.validatePanel();
                this.outputPanel.validatePanel();
            }

            @Override
            public void objectToPanel() {
                this.inputPanel.objectToPanel();
                this.outputPanel.objectToPanel();
            }

            @Override
            public void panelToObject() {
                this.inputPanel.panelToObject();
                this.outputPanel.panelToObject();
            }

            private void init() {
                this.setLayout((Layout)new MigLayout("ins 0, gap 5, fillx"));
                this.inputPanel = new LoopDataPanel((UiContainer)this, this.getMultiInstance(), this.getSubprocess(), true);
                this.add((UiComponent)this.inputPanel, "growx, wrap");
                this.outputPanel = new LoopDataPanel((UiContainer)this, this.getMultiInstance(), this.getSubprocess(), false);
                this.add((UiComponent)this.outputPanel, "growx, wrap");
            }
        }

        private static class LoopCreationTypeSelectorPanel
        extends RadioButtonSelectorPanel<LoopCreationType>
        implements LoopPropertiesEditor {
            private MultiInstance multiInstance;
            private Subprocess subprocess;

            private LoopCreationTypeSelectorPanel(@NotNull UiContainer parent, @NotNull MultiInstance multiInstance, @NotNull Subprocess subprocess) {
                super(parent, DesignerMsg.CREATION_TYPE, 5);
                this.multiInstance = multiInstance;
                this.subprocess = subprocess;
                this.init();
            }

            @Override
            public LoopPropertiesEditorPanel getInnerPanel() {
                return (LoopPropertiesEditorPanel)super.getInnerPanel();
            }

            @Override
            public void objectToPanel() {
                if (this.multiInstance.getLoopCardinality() != null) {
                    this.setSelectedOption(LoopCreationType.CARDINALITY);
                } else if (this.multiInstance.getLoopDataInput() != null || this.multiInstance.getLoopDataOutput() != null) {
                    this.setSelectedOption(LoopCreationType.COLLECTION);
                }
                this.getInnerPanel().objectToPanel();
            }

            @Override
            public void panelToObject() {
                this.getInnerPanel().panelToObject();
            }

            @Override
            public void validatePanel() throws ProjectException {
                this.getInnerPanel().validatePanel();
            }

            @Override
            protected Panel createInnerPanel(@NotNull UiContainer container, @NotNull LoopCreationType selectedItem) {
                MultiInstancePropertiesEditorPanel result = null;
                if (selectedItem == LoopCreationType.CARDINALITY) {
                    result = new LoopCardinalityExpressionPanel(container, this.multiInstance, this.subprocess);
                } else if (selectedItem == LoopCreationType.COLLECTION) {
                    result = new LoopDataInputOutputPanel(container, this.multiInstance, this.subprocess);
                }
                return result;
            }

            private void init() {
                this.addOption(LoopCreationType.CARDINALITY);
                this.addOption(LoopCreationType.COLLECTION);
                this.setSelectedOption(LoopCreationType.CARDINALITY);
            }
        }

        private static class LoopConditionExpressionPanel
        extends LoopPropertiesEditorPanel {
            private ExpressionPanel expressionPanel;
            private final Loop loop;
            private Subprocess subprocess;

            public LoopConditionExpressionPanel(UiContainer parent, @NotNull Loop loop, @NotNull Subprocess subprocess) {
                super(parent, DesignerMsg.LOOP_CONDITION);
                this.loop = loop;
                this.subprocess = subprocess;
                this.init();
            }

            @Override
            public void validatePanel() throws ProjectException {
                if (!this.expressionPanel.isExpressionValid()) {
                    throw new ProjectException((ProjectObject)this.subprocess, DesignerMsg.DYNAMIC_INVALID(DesignerMsg.LOOP_CONDITION));
                }
            }

            @Override
            public void objectToPanel() {
                this.expressionPanel.setExpression(this.loop.getLoopExpression());
            }

            @Override
            public void panelToObject() {
                this.loop.setLoopExpression(this.expressionPanel.getExpression());
            }

            private void init() {
                this.setLayout((Layout)new MigLayout("ins 5, gap 5, fill"));
                DataDeclarationContainer container = this.loop.getLoopCharacteristicsContainer();
                ExpressionContext context = new ExpressionContext(container, CatalogType.Default.getBool());
                this.expressionPanel = ExpressionPanelFactory.createDefaultMultiLinePanel((UiContainer)this, context);
                this.add(this.expressionPanel.getUiComponent(), "growx, height 60!");
            }
        }

        private static class LoopCardinalityExpressionPanel
        extends MultiInstancePropertiesEditorPanel {
            private ExpressionPanel expressionPanel;

            public LoopCardinalityExpressionPanel(@NotNull UiContainer parent, @NotNull MultiInstance multiInstance, @NotNull Subprocess subprocess) {
                super(parent, multiInstance, subprocess, DesignerMsg.LOOP_CARDINALITY);
                this.init();
            }

            @Override
            public void validatePanel() throws ProjectException {
                if (this.expressionPanel.getExpression() == null) {
                    throw new ProjectException((ProjectObject)this.getSubprocess(), DesignerMsg.DYNAMIC_NOT_NULL(DesignerMsg.LOOP_CARDINALITY));
                }
                if (!this.expressionPanel.isExpressionValid()) {
                    throw new ProjectException((ProjectObject)this.getSubprocess(), DesignerMsg.DYNAMIC_INVALID(DesignerMsg.LOOP_CARDINALITY));
                }
            }

            @Override
            public void objectToPanel() {
                this.expressionPanel.setExpression(this.getMultiInstance().getLoopCardinality());
            }

            @Override
            public void panelToObject() {
                this.getMultiInstance().setLoopCardinality(this.expressionPanel.getExpression());
            }

            private void init() {
                this.setLayout((Layout)new MigLayout("ins 5, gap 5, fillx"));
                DataDeclarationContainer container = this.getMultiInstance().getLoopCharacteristicsContainer();
                ExpressionContext context = new ExpressionContext(container, CatalogType.Default.getInt());
                this.expressionPanel = ExpressionPanelFactory.createDefaultMultiLinePanel((UiContainer)this, context);
                this.add(this.expressionPanel.getUiComponent(), "growx, height 60!");
            }
        }

        private static class CompletionConditionExpressionPanel
        extends MultiInstancePropertiesEditorPanel {
            private CheckBox expressionCheckbox;
            private ExpressionPanel expressionPanel;

            public CompletionConditionExpressionPanel(UiContainer parent, @NotNull MultiInstance multiInstance, @NotNull Subprocess subprocess) {
                super(parent, multiInstance, subprocess, DesignerMsg.COMPLETION_CONDITION);
                this.init();
            }

            @Override
            public void validatePanel() throws ProjectException {
                if (!this.expressionPanel.isExpressionValid()) {
                    throw new ProjectException((ProjectObject)this.getSubprocess(), DesignerMsg.DYNAMIC_INVALID(DesignerMsg.COMPLETION_CONDITION));
                }
            }

            @Override
            public void objectToPanel() {
                this.expressionCheckbox.setSelected(this.getMultiInstance().hasCompletionCondition());
                this.expressionPanel.setExpression(this.getMultiInstance().getCompletionCondition());
            }

            @Override
            public void panelToObject() {
                Expression expression = this.expressionCheckbox.isSelected() ? this.expressionPanel.getExpression() : null;
                this.getMultiInstance().setCompletionCondition(expression);
            }

            private void init() {
                this.setLayout((Layout)new MigLayout("ins 5, gap 5, fill, hidemode 3"));
                DataDeclarationContainer container = this.getMultiInstance().getLoopCharacteristicsContainer();
                ExpressionContext context = new ExpressionContext(container, CatalogType.Default.getBool());
                this.expressionPanel = ExpressionPanelFactory.createDefaultMultiLinePanel((UiContainer)this, context);
                this.expressionPanel.getUiComponent().makeRecyclable();
                this.expressionCheckbox = CheckBox.create((UiContainer)this, (Msg)DesignerMsg.USE_EXPRESSION);
                this.add((UiComponent)this.expressionCheckbox, "wrap");
                this.expressionCheckbox.addModificationListener(new ModificationListener(){

                    public void objectModified(ModificationEvent modificationEvent) {
                        CompletionConditionExpressionPanel.this.expressionPanel.setVisible(CompletionConditionExpressionPanel.this.expressionCheckbox.isSelected());
                    }
                });
                this.expressionPanel.setVisible(false);
                this.add(this.expressionPanel.getUiComponent(), "growx, height 60!");
            }
        }

        private static abstract class MultiInstancePropertiesEditorPanel
        extends LoopPropertiesEditorPanel {
            private MultiInstance multiInstance;
            private Subprocess subprocess;

            private MultiInstancePropertiesEditorPanel(@NotNull UiContainer parent, @NotNull MultiInstance multiInstance, @NotNull Subprocess subprocess, @Nullable Msg title) {
                super(parent, title);
                this.multiInstance = multiInstance;
                this.subprocess = subprocess;
            }

            public Subprocess getSubprocess() {
                return this.subprocess;
            }

            protected MultiInstance getMultiInstance() {
                return this.multiInstance;
            }
        }

        private static abstract class LoopPropertiesEditorPanel
        extends Panel
        implements LoopPropertiesEditor {
            public LoopPropertiesEditorPanel(@NotNull UiContainer parent, @Nullable Msg title) {
                super(parent, title);
            }
        }

        private static interface LoopPropertiesEditor {
            public void objectToPanel();

            public void panelToObject();

            public void validatePanel() throws ProjectException;
        }

        private static enum LoopCreationType implements I18nProvider
        {
            CARDINALITY(DesignerMsg.CARDINALITY),
            COLLECTION(DesignerMsg.COLLECTION);

            private Msg msg;

            private LoopCreationType(Msg msg) {
                this.msg = msg;
            }

            public Msg getMsg() {
                return this.msg;
            }

            @Override
            public String getString() {
                return this.msg.getString();
            }

            @Override
            public String getString(Locale locale) {
                return this.msg.getString(locale);
            }
        }
    }
}

