/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import oracle.bpm.designer.flowpanels.ElementsLinkEditor;
import oracle.bpm.designer.loghandler.LogHandlersDialog;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.panels.builder.EditableComponent;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.loghandlers.LogHandlerSet;
import oracle.bpm.project.model.processes.loghandlers.Loggable;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;

public class LogHandlersSelectorPanel
extends Panel
implements EditableComponent<Loggable> {
    private Loggable loggable;

    public LogHandlersSelectorPanel(@NotNull UiContainer parent, @NotNull Loggable loggable) {
        super(parent);
        this.loggable = loggable;
        this.init();
    }

    @Override
    public void validateEditor() throws ProjectException {
    }

    @Override
    public void applyChanges() {
    }

    @Override
    public void populateValues() {
    }

    @Override
    public void loadValues() {
    }

    @Override
    public UiComponent getUiComponent() {
        return this;
    }

    @Override
    public Loggable getElement() {
        return this.loggable;
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public void setElement(Loggable element) {
        this.loggable = element;
    }

    private void init() {
        this.setLayout((Layout)new MigLayout("ins 0, gap 0"));
        this.add((UiComponent)this.createLogHandlersLinkEditor((UiContainer)this));
    }

    private ElementsLinkEditor createLogHandlersLinkEditor(@NotNull UiContainer parent) {
        ElementsLinkEditor result = new ElementsLinkEditor(parent, DesignerMsg.LOG_HANDLERS, Image.create((Msg)DesignerMsg.LOG_HANDLERS)){

            @Override
            protected boolean hasElements() {
                return LogHandlersSelectorPanel.this.hasLogHandlers();
            }

            @Override
            protected void clearElements() {
                if (MessageDialog.showQuestion((Msg)DesignerMsg.LOG_HANDLERS, (Msg)DesignerMsg.CONFIRM_CLEAR_LOG_HANDLERS, (int)6) == 2) {
                    LogHandlersSelectorPanel.this.clearLogHandlers();
                }
            }

            @Override
            protected void editElements() {
                LogHandlersDialog d = new LogHandlersDialog(this.getOwnerWindow(), LogHandlersSelectorPanel.this.loggable);
                d.setVisible(true);
            }
        };
        result.initialize();
        return result;
    }

    private void clearLogHandlers() {
        LogHandlerSet logHandlerSet = this.loggable.getLogHandlerSet();
        logHandlerSet.clearLogHandlers();
    }

    private boolean hasLogHandlers() {
        LogHandlerSet logHandlerSet = this.loggable.getLogHandlerSet();
        return !logHandlerSet.getLogHandlers().isEmpty();
    }
}

