/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import oracle.bpm.designer.expression.ExpressionPanel;
import oracle.bpm.designer.expression.ExpressionPanelFactory;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.panels.builder.EditableComponent;
import oracle.bpm.lang.Any;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;

public class HumanTaskTitleExpressionPanelAdapter
implements EditableComponent<UserTask> {
    private ExpressionPanel titleExpression;
    private UserTask userTask;

    private HumanTaskTitleExpressionPanelAdapter(UiContainer parent, UserTask userTask) {
        this.userTask = userTask;
        this.buildUi(parent);
    }

    public static HumanTaskTitleExpressionPanelAdapter create(UiContainer parent, UserTask userTask) {
        return new HumanTaskTitleExpressionPanelAdapter(parent, userTask);
    }

    @Override
    public void validateEditor() throws ProjectException {
        if (!this.titleExpression.isExpressionValid()) {
            this.titleExpression.setExpression(this.userTask.getSubject());
            throw new ProjectException((ProjectObject)this.userTask, DesignerMsg.INVALID_ATTRIBUTE_EXPRESSION(DesignerMsg.TITLE.getString()));
        }
    }

    @Override
    public void applyChanges() {
        this.userTask.setSubject(this.titleExpression.getExpression());
    }

    @Override
    public boolean isDirty() {
        return !Any.equals(this.userTask.getSubject(), this.titleExpression.getExpression());
    }

    @Override
    public void setElement(UserTask element) {
        this.userTask = element;
    }

    @Override
    public String getHelpId() {
        return null;
    }

    @Override
    public UiComponent getUiComponent() {
        return this.titleExpression.getUiComponent();
    }

    @Override
    public UserTask getElement() {
        return this.userTask;
    }

    @Override
    public void populateValues() {
        this.loadValues();
    }

    @Override
    public void loadValues() {
        this.titleExpression.setExpression(this.userTask.getSubject());
    }

    private void buildUi(UiContainer parent) {
        this.titleExpression = ExpressionPanelFactory.createDefaultSingleLinePanel(parent, new ExpressionContext((DataDeclarationContainer)this.userTask, CatalogType.Default.getString()));
        this.populateValues();
    }
}

