/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.panels.builder.EditableComponent;
import oracle.bpm.lang.Any;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.ReinitiatePolicy;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.project.view.project.view.renderer.ProjectObjectRenderer;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ReferenceComboBox;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;

public class HumanTaskReinitiatePanel
extends Panel
implements EditableComponent<UserTask> {
    private CheckBox clearPayloadCheckBox;
    private CheckBox reinitiateCheckBox;
    private ReferenceComboBox<UserTask> sourceCombobox;
    private UserTask userTask;

    public HumanTaskReinitiatePanel(UiContainer parent, UserTask userTask) {
        super(parent);
        this.userTask = userTask;
        this.buildUi();
    }

    public static HumanTaskReinitiatePanel create(UiContainer parent, UserTask userTask) {
        return new HumanTaskReinitiatePanel(parent, userTask);
    }

    @Override
    public void validateEditor() throws ProjectException {
        if (this.reinitiateCheckBox.isSelected() && (!this.sourceCombobox.isValidSelection() || this.sourceCombobox.getValue() == null)) {
            this.reinitiateCheckBox.setSelected(false);
            throw new ProjectException((ProjectObject)this.userTask, DesignerMsg.INVALID_REINITITE_SOURCE);
        }
    }

    @Override
    public void applyChanges() {
        boolean isReinitiate = this.reinitiateCheckBox.isSelected();
        if (this.userTask.isReinitiate() != isReinitiate) {
            this.userTask.setReinitiate(isReinitiate);
        }
        ReinitiatePolicy policy = isReinitiate && this.clearPayloadCheckBox.isSelected() ? ReinitiatePolicy.CLEAR_PAYLOAD : ReinitiatePolicy.REUSE_PAYLOAD;
        this.userTask.setReinitiatePolicy(policy);
        UserTask source = isReinitiate ? (UserTask)this.sourceCombobox.getValue() : null;
        this.userTask.setReinitiateSource(source);
    }

    @Override
    public boolean isDirty() {
        boolean isReinitiate = this.reinitiateCheckBox.isSelected();
        ReinitiatePolicy policy = isReinitiate && this.clearPayloadCheckBox.isSelected() ? ReinitiatePolicy.CLEAR_PAYLOAD : ReinitiatePolicy.REUSE_PAYLOAD;
        UserTask source = isReinitiate ? (UserTask)this.sourceCombobox.getValue() : null;
        return !Any.equals(this.userTask.isReinitiate(), this.reinitiateCheckBox.isSelected()) || !Any.equals(this.userTask.getReinitiatePolicy(), policy) || !Any.equals(this.userTask.getReinitiateSource(), source);
    }

    @Override
    public void setElement(UserTask element) {
        this.userTask = element;
    }

    @Override
    public UiComponent getUiComponent() {
        return this;
    }

    @Override
    public UserTask getElement() {
        return this.userTask;
    }

    @Override
    public void populateValues() {
        this.sourceCombobox.removeAllItems();
        this.sourceCombobox.addItems(this.getSouceComboItems());
        this.loadValues();
    }

    @Override
    public void loadValues() {
        boolean isReinitiate = this.userTask.isReinitiate();
        this.reinitiateCheckBox.setSelected(isReinitiate);
        if (this.sourceCombobox.getItemCount() > 0) {
            if (this.userTask.getReinitiateSource() != null) {
                this.sourceCombobox.setValue((Object)this.userTask.getReinitiateSource());
            } else {
                this.sourceCombobox.setSelectedIndex(0);
            }
        }
        boolean isClear = isReinitiate && this.userTask.getReinitiatePolicy().isClear();
        this.clearPayloadCheckBox.setSelected(isClear);
    }

    private void buildUi() {
        this.setLayout((Layout)new MigLayout("hidemode 3, ins 0, gap 5, fillx"));
        this.reinitiateCheckBox = CheckBox.create((UiContainer)this, (Msg)ProjectModelMsg.RE_INITIATE);
        boolean isReinitiate = this.userTask.isReinitiate();
        this.sourceCombobox = this.createReinitiateSourceComboBox((UiContainer)this, this.userTask);
        this.clearPayloadCheckBox = CheckBox.create((UiContainer)this, (Msg)ProjectModelMsg.CLEAR_PAYLOAD_DSC);
        this.clearPayloadCheckBox.setVisible(isReinitiate);
        this.sourceCombobox.setVisible(isReinitiate);
        this.reinitiateCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                boolean isSelected = e.isStateSelected();
                HumanTaskReinitiatePanel.this.clearPayloadCheckBox.setVisible(isSelected);
                HumanTaskReinitiatePanel.this.sourceCombobox.setVisible(isSelected);
                if (isSelected && HumanTaskReinitiatePanel.this.sourceCombobox.getItemCount() > 0) {
                    HumanTaskReinitiatePanel.this.sourceCombobox.setSelectedIndex(0);
                }
            }
        });
        this.populateValues();
        this.add((UiComponent)this.reinitiateCheckBox);
        this.add((UiComponent)this.sourceCombobox, "growx, wrap");
        this.add((UiComponent)this.clearPayloadCheckBox, "spanx, wrap");
    }

    private ReferenceComboBox<UserTask> createReinitiateSourceComboBox(@NotNull UiContainer parent, @NotNull UserTask userTask) {
        ReferenceComboBox result = new ReferenceComboBox(parent);
        result.addItems(this.getSouceComboItems());
        result.setLabelProvider((LabelProvider)new LabelProvider<UserTask>(){

            public Image getIcon(UserTask element) {
                return ProjectObjectRenderer.Default.getIcon((ProjectObject)element);
            }

            public String getText(UserTask element) {
                return ProjectObjectRenderer.Default.getLabel((ProjectObject)element);
            }
        });
        return result;
    }

    private Iterable<? extends UserTask> getSouceComboItems() {
        return this.userTask.getProcess().getDescendants(UserTask.class);
    }
}

