/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import oracle.bpm.designer.expression.ExpressionPanel;
import oracle.bpm.designer.expression.ExpressionPanelFactory;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.panels.builder.EditableComponent;
import oracle.bpm.lang.Any;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;

public class HumanTaskInitiatorPanel
extends Panel
implements EditableComponent<UserTask> {
    private ExpressionPanel initiatorField;
    private UserTask userTask;

    public HumanTaskInitiatorPanel(UiContainer parent, UserTask userTask) {
        super(parent);
        this.userTask = userTask;
        this.buildUi();
    }

    public static HumanTaskInitiatorPanel create(UiContainer parent, UserTask userTask) {
        return new HumanTaskInitiatorPanel(parent, userTask);
    }

    @Override
    public void validateEditor() throws ProjectException {
        if (!this.initiatorField.isExpressionValid()) {
            this.initiatorField.setExpression(this.userTask.getInitiator());
            throw new ProjectException((ProjectObject)this.userTask, DesignerMsg.INVALID_ATTRIBUTE_EXPRESSION(ProjectModelMsg.INITIATOR.getString()));
        }
    }

    @Override
    public void applyChanges() {
        if (this.isDirty()) {
            this.userTask.setInitiator(this.initiatorField.getExpression());
        }
    }

    @Override
    public boolean isDirty() {
        return !Any.equals(this.userTask.getInitiator(), this.initiatorField.getExpression());
    }

    @Override
    public void setElement(UserTask element) {
        this.userTask = element;
    }

    @Override
    public UiComponent getUiComponent() {
        return this;
    }

    @Override
    public UserTask getElement() {
        return this.userTask;
    }

    @Override
    public void populateValues() {
        this.loadValues();
    }

    @Override
    public void loadValues() {
        this.initiatorField.setExpression(this.userTask.getInitiator());
    }

    private void buildUi() {
        this.initiatorField = ExpressionPanelFactory.createDefaultSingleLinePanel((UiContainer)this, new ExpressionContext((DataDeclarationContainer)this.userTask, CatalogType.Default.getString()));
        this.populateValues();
        this.setLayout((Layout)new BorderLayout());
        this.add(this.initiatorField.getUiComponent(), "Center");
    }
}

