/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import oracle.bpm.designer.expression.ExpressionPanel;
import oracle.bpm.designer.expression.ExpressionPanelFactory;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.panels.builder.EditableComponent;
import oracle.bpm.lang.Any;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;

public class HumanTaskApplicationContextPanel
extends Panel
implements EditableComponent<UserTask> {
    private ExpressionPanel applicationContextField;
    private UserTask userTask;

    public HumanTaskApplicationContextPanel(UiContainer parent, UserTask userTask) {
        super(parent);
        this.userTask = userTask;
        this.buildUi();
    }

    public static HumanTaskApplicationContextPanel create(UiContainer parent, UserTask userTask) {
        return new HumanTaskApplicationContextPanel(parent, userTask);
    }

    @Override
    public void validateEditor() throws ProjectException {
        if (!this.applicationContextField.isExpressionValid()) {
            this.applicationContextField.setExpression(this.userTask.getApplicationContext());
            throw new ProjectException((ProjectObject)this.userTask, DesignerMsg.INVALID_ATTRIBUTE_EXPRESSION(ProjectModelMsg.APP_CONTEXT.getString()));
        }
    }

    @Override
    public void applyChanges() {
        if (this.isDirty()) {
            this.userTask.setApplicationContext(this.applicationContextField.getExpression());
        }
    }

    @Override
    public boolean isDirty() {
        return !Any.equals(this.userTask.getApplicationContext(), this.applicationContextField.getExpression());
    }

    @Override
    public void setElement(UserTask element) {
        this.userTask = element;
    }

    @Override
    public UiComponent getUiComponent() {
        return this;
    }

    @Override
    public UserTask getElement() {
        return this.userTask;
    }

    @Override
    public void populateValues() {
        this.loadValues();
    }

    @Override
    public void loadValues() {
        this.applicationContextField.setExpression(this.userTask.getApplicationContext());
    }

    private void buildUi() {
        this.applicationContextField = ExpressionPanelFactory.createDefaultSingleLinePanel((UiContainer)this, new ExpressionContext((DataDeclarationContainer)this.userTask, CatalogType.Default.getString()));
        this.populateValues();
        this.setLayout((Layout)new BorderLayout());
        this.add(this.applicationContextField.getUiComponent(), "Center");
    }
}

