/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Function;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.flowpanels.PropertiesSheet;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.ui.msg.UIMsg;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowNodePropertiesPreferences {
    private List<Function<FlowNode, FlowNode>> afterCopy;
    private Predicate<PropertiesSheet> selectedSheet = SHOW_BASIC;
    public static final Predicate<PropertiesSheet> SHOW_BASIC = new Predicate<PropertiesSheet>(){

        @Override
        public boolean check(@Nullable PropertiesSheet sheet) {
            return sheet != null && UIMsg.BASIC.equals(sheet.getTitle());
        }
    };
    public static final Predicate<PropertiesSheet> SHOW_IMPLEMENTATION = new Predicate<PropertiesSheet>(){

        @Override
        public boolean check(@Nullable PropertiesSheet sheet) {
            return sheet != null && ProjectMsg.IMPLEMENTATION.equals(sheet.getTitle());
        }
    };

    private FlowNodePropertiesPreferences() {
        this.afterCopy = new ArrayList<Function<FlowNode, FlowNode>>();
    }

    public static FlowNodePropertiesPreferences create() {
        return new FlowNodePropertiesPreferences();
    }

    public void setSelectedSheet(@NotNull Predicate<PropertiesSheet> selectedPredicate) {
        this.selectedSheet = selectedPredicate;
    }

    public boolean shouldSelectSheet(@NotNull PropertiesSheet sheet) {
        return this.selectedSheet.check(sheet);
    }

    public void addAfterCopyFunction(@NotNull Function<FlowNode, FlowNode> function) {
        this.afterCopy.add(function);
    }

    public Sequence<Function<FlowNode, FlowNode>> getAfterCopyFunctions() {
        return CollectionUtils.asSequence(this.afterCopy);
    }
}

