/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import oracle.bpm.collections.Function;
import oracle.bpm.command.Command;
import oracle.bpm.designer.ActionRunner;
import oracle.bpm.designer.flowpanels.AbstractFlowNodePropertiesPanel;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesPreferences;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.command.design.CopyFlowNodeCommand;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;

public class FlowNodePropertiesDialog
extends OkCancelDialog {
    private AbstractFlowNodePropertiesPanel flowNodePanel;
    private FlowNode sourceNode;

    private FlowNodePropertiesDialog(FlowNode flowNode, FlowNodePropertiesPreferences preferences) {
        super(Ui.getRoot(), DesignerMsg.PROJECT_OBJECT_PROPERTIES(flowNode.getDefaultLabel()), true);
        this.sourceNode = flowNode;
        this.init(this.sourceNode, preferences);
    }

    public static boolean editProperties(FlowNode flowNode) {
        return FlowNodePropertiesDialog.editProperties(flowNode, FlowNodePropertiesPreferences.create());
    }

    public static boolean editProperties(FlowNode flowNode, FlowNodePropertiesPreferences preferences) {
        FlowNodePropertiesDialog dialog = new FlowNodePropertiesDialog(flowNode, preferences);
        dialog.setVisible(true);
        return dialog.userAccepted();
    }

    public String getHelpId() {
        return this.flowNodePanel.getHelpId();
    }

    public void ok() {
        try {
            this.flowNodePanel.validate();
            this.flowNodePanel.applyChanges();
            ActionRunner.getInstance().run((Command)new CopyFlowNodeCommand(this.flowNodePanel.getFlowNode(), this.sourceNode));
            this.setUserAccepted(true);
            this.close();
        }
        catch (Exception e) {
            MessageDialog.showError((Throwable)e);
        }
    }

    private void init(FlowNode flowNode, FlowNodePropertiesPreferences preferences) {
        FlowNode copy = flowNode.copy();
        for (Function<FlowNode, FlowNode> function : preferences.getAfterCopyFunctions()) {
            copy = function.eval(copy);
        }
        this.flowNodePanel = AbstractFlowNodePropertiesPanel.create(copy, preferences);
        UiContainer container = this.getContentPane();
        UiComponent uiComponent = this.flowNodePanel.buildPanel(container);
        container.setLayout((Layout)new BorderLayout());
        container.add(uiComponent, (Object)"Center");
        this.setSize(580, 500);
        this.setLocationRelativeTo((UiComponent)this.getParent());
        this.setTitle(DesignerMsg.PROJECT_OBJECT_PROPERTIES(copy.getDefaultLabel()).getString());
    }
}

