/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.designer.DesignerResources;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.panels.builder.EditableComponent;
import oracle.bpm.lang.Str;
import oracle.bpm.project.compile.exceptions.ActivityHasNoNameException;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.DocumentEvent;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.ui.text.TextHolder;

public class FlowNodeNamePanel
extends Panel
implements EditableComponent<FlowNode> {
    private LocaleStringMap clonedLabel;
    private FlowNode flowNode;
    private TextField labelField;

    public FlowNodeNamePanel(UiContainer parent, FlowNode flowNode) {
        super(parent);
        this.flowNode = flowNode;
        this.buildUi();
    }

    @Override
    public void validateEditor() throws ProjectException {
        this.validatePanel();
    }

    @Override
    public void applyChanges() {
        if (this.clonedLabel != null) {
            LocaleStringMap localeStringMap = this.flowNode.getLabelMap();
            localeStringMap.clear();
            localeStringMap.putAll(this.clonedLabel);
        }
        this.flowNode.setDefaultLabel(this.labelField.getText());
    }

    @Override
    public UiComponent getUiComponent() {
        return this;
    }

    @Override
    public FlowNode getElement() {
        return this.flowNode;
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public void setElement(FlowNode element) {
        this.flowNode = element;
    }

    public void validatePanel() throws ProjectException {
        if (Str.isEmpty(this.labelField.getText())) {
            throw new ActivityHasNoNameException(this.flowNode);
        }
    }

    @Override
    public void populateValues() {
        this.loadValues();
    }

    @Override
    public void loadValues() {
        String defaultLabel = this.flowNode.getDefaultLabel();
        if (!Str.isEmpty(defaultLabel)) {
            this.labelField.setText(defaultLabel);
        } else {
            this.labelField.setText(ModelUtils.generateDefaultLabel((FlowNode)this.flowNode));
            this.labelField.selectAll();
            this.labelField.requestFocus();
        }
    }

    private void buildUi() {
        this.setLayout((Layout)new MigLayout("fillx, gapx 5, ins 0"));
        this.labelField = new TextField((UiContainer)this, 20);
        this.labelField.setRequestFocusEnabled(true);
        this.populateValues();
        this.labelField.addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                FlowNodeNamePanel.this.applyChanges();
            }

            public void insertUpdate(DocumentEvent e) {
                FlowNodeNamePanel.this.applyChanges();
            }

            public void removeUpdate(DocumentEvent e) {
                FlowNodeNamePanel.this.applyChanges();
            }
        });
        DesignerResources.LocalizationProvider localizationProvider = new DesignerResources.LocalizationProvider(){

            @Override
            public LocaleStringMap getLocaleStringMap() {
                return FlowNodeNamePanel.this.clonedLabel;
            }

            @Override
            public TextHolder getTextHolder() {
                return FlowNodeNamePanel.this.labelField;
            }
        };
        DesignerResources.LocalizationButton localizationButton = DesignerResources.buildLocalizationButton(this.flowNode.getProject(), (UiContainer)this, localizationProvider, DesignerMsg.LOCALIZE_LABEL.getString());
        this.clonedLabel = this.flowNode.getLabelMap().clone();
        this.add((UiComponent)this.labelField, "growx");
        this.add((UiComponent)localizationButton);
    }
}

