/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.panels.builder.EditableComponent;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.renderer.FlowElementImageRenderer;
import oracle.bpm.geom.Dimension;
import oracle.bpm.project.model.features.CustomizedImageFeature;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.border.BorderFactory;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.msg.UIMsg;

public class FlowNodeImagePanel
extends Panel
implements EditableComponent<FlowNode> {
    private DrawContext context;
    private FlowNode flowNode;
    private Label iconLabel;

    public FlowNodeImagePanel(UiContainer parent, FlowNode flowNode) {
        super(parent);
        this.flowNode = flowNode;
        this.buildUi();
    }

    @Override
    public void validateEditor() {
    }

    @Override
    public void applyChanges() {
    }

    @Override
    public UiComponent getUiComponent() {
        return this;
    }

    @Override
    public FlowNode getElement() {
        return this.flowNode;
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public void setElement(FlowNode element) {
        this.flowNode = element;
    }

    @Override
    public void populateValues() {
        this.updateIcon(this.iconLabel, (FlowElement)this.flowNode, this.context);
    }

    @Override
    public void loadValues() {
        this.updateIcon(this.iconLabel, (FlowElement)this.flowNode, this.context);
    }

    private void buildUi() {
        FormLayout form = new FormLayout("0dlu:grow(0.5),pref,2dlu,pref,0dlu:grow(0.5)", "pref,0dlu,pref,0dlu:grow");
        CellConstraints cc = form.createCellConstraints();
        this.setLayout((Layout)form);
        this.context = new DrawContext();
        final Panel iconPanel = new Panel((UiContainer)this);
        iconPanel.setBorder(BorderFactory.createLineBorder((Color)Color.GRAY));
        FormLayout lay = new FormLayout("0dlu:grow(0.5),center:pref,0dlu:grow(0.5)", "0dlu:grow(0.5),center:pref,0dlu:grow(0.5)");
        iconPanel.setLayout((Layout)lay);
        this.iconLabel = Label.create((UiContainer)iconPanel);
        iconPanel.add((UiComponent)this.iconLabel, (Object)lay.createCellConstraints(2, 2));
        this.populateValues();
        iconPanel.setMinimumSize(Dimension.valueOf(102, 80));
        iconPanel.setPreferredSize(Dimension.valueOf(102, 80));
        this.add((UiComponent)iconPanel, cc.xyw(1, 1, 5));
        Button browseButton = Button.createBrowse((UiContainer)this);
        browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String result = AbstractStudioWorkbench.getInstance().browseForImage((UiComponent)iconPanel);
                if (result != null) {
                    CustomizedImageFeature feature = (CustomizedImageFeature)FlowNodeImagePanel.this.flowNode.getFeature(CustomizedImageFeature.class);
                    feature.setValue(result);
                    FlowNodeImagePanel.this.updateIcon(FlowNodeImagePanel.this.iconLabel, (FlowElement)FlowNodeImagePanel.this.flowNode, FlowNodeImagePanel.this.context);
                }
            }
        });
        this.add((UiComponent)browseButton, cc.xy(2, 3));
        Button clearButton = Button.createIconic((UiContainer)this, (Msg)UIMsg.CLEAR);
        clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CustomizedImageFeature feature = (CustomizedImageFeature)FlowNodeImagePanel.this.flowNode.getFeature(CustomizedImageFeature.class);
                feature.setValue(null);
                FlowNodeImagePanel.this.updateIcon(FlowNodeImagePanel.this.iconLabel, (FlowElement)FlowNodeImagePanel.this.flowNode, FlowNodeImagePanel.this.context);
            }
        });
        this.add((UiComponent)clearButton, cc.xy(4, 3));
    }

    private void updateIcon(Label iconLabel, FlowElement a, DrawContext context) {
        Image image = FlowElementImageRenderer.getNormalImage((FlowElement)a, (DrawContext)context);
        iconLabel.setIcon(image);
    }
}

