/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.designer.DesignerResources;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.panels.builder.EditableComponent;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.text.TextArea;
import oracle.bpm.ui.text.TextHolder;

public class FlowNodeDescriptionPanel
extends Panel
implements EditableComponent<FlowNode> {
    private LocaleStringMap clonedDescription;
    private TextArea descriptionArea;
    private FlowNode flowNode;

    public FlowNodeDescriptionPanel(UiContainer parent, FlowNode flowNode) {
        super(parent);
        this.flowNode = flowNode;
        this.buildUi();
    }

    @Override
    public void validateEditor() throws ProjectException {
    }

    @Override
    public void applyChanges() {
        if (this.clonedDescription != null) {
            LocaleStringMap localeStringMap = this.flowNode.getDescriptionMap();
            localeStringMap.clear();
            localeStringMap.putAll(this.clonedDescription);
        }
        this.flowNode.setDefaultDescription(this.descriptionArea.getText());
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public void setElement(FlowNode element) {
        this.flowNode = element;
    }

    @Override
    public void populateValues() {
        this.loadValues();
    }

    @Override
    public void loadValues() {
        String desc = this.flowNode.getDefaultDescription();
        if (desc != null) {
            this.descriptionArea.setText(desc);
        }
    }

    @Override
    public UiComponent getUiComponent() {
        return this;
    }

    @Override
    public FlowNode getElement() {
        return this.flowNode;
    }

    private void buildUi() {
        this.setLayout((Layout)new MigLayout("fillx, gapx 5, ins 0"));
        this.descriptionArea = new TextArea((UiContainer)this);
        this.descriptionArea.setLineWrap(true);
        this.descriptionArea.setRows(4);
        this.descriptionArea.setWrapStyleWord(true);
        this.populateValues();
        DesignerResources.LocalizationProvider localizationProvider = new DesignerResources.LocalizationProvider(){

            @Override
            public LocaleStringMap getLocaleStringMap() {
                return FlowNodeDescriptionPanel.this.clonedDescription;
            }

            @Override
            public TextHolder getTextHolder() {
                return FlowNodeDescriptionPanel.this.descriptionArea;
            }
        };
        DesignerResources.LocalizationButton localizationButton = DesignerResources.buildLocalizationButton(this.flowNode.getProject(), (UiContainer)this, localizationProvider, DesignerMsg.LOCALIZE_DESCRIPTION.getString(), true);
        Button.fixSize((Button)localizationButton);
        LocaleStringMap description = this.flowNode.getDescriptionMap();
        this.clonedDescription = description.clone();
        this.add((UiComponent)this.descriptionArea, "growx");
        this.add((UiComponent)localizationButton, "aligny top");
    }
}

