/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.designer.flowpanels.AbstractFlowNodePropertiesPanel;
import oracle.bpm.designer.flowpanels.AllowsInterruptionsEditor;
import oracle.bpm.designer.flowpanels.AssociationTaskEditor;
import oracle.bpm.designer.flowpanels.BoundaryEventEditor;
import oracle.bpm.designer.flowpanels.ConversationalEditor;
import oracle.bpm.designer.flowpanels.CorrelationsEditor;
import oracle.bpm.designer.flowpanels.ErrorEventEditor;
import oracle.bpm.designer.flowpanels.EventChangeTypeEditor;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesEditor;
import oracle.bpm.designer.flowpanels.ImplementationEditor;
import oracle.bpm.designer.flowpanels.LogHandlersEditor;
import oracle.bpm.designer.flowpanels.MessageHeadersEditor;
import oracle.bpm.designer.flowpanels.MultipleLinksPropertiesEditor;
import oracle.bpm.designer.flowpanels.ServicePropertiesEditor;
import oracle.bpm.designer.flowpanels.SignalEventEditor;
import oracle.bpm.designer.flowpanels.TimerEventEditor;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.DataAssociationEnabled;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.StartEvent;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.processes.conversational.Conversational;
import oracle.bpm.project.model.processes.correlations.CorrelationsEnabled;
import oracle.bpm.project.model.processes.loghandlers.Loggable;
import oracle.bpm.project.model.processes.messageheaders.MessageHeadersEnabled;
import oracle.bpm.project.model.processes.serviceproperties.ServicePropertiesEnabled;
import org.jetbrains.annotations.NotNull;

class EventImplementationEditor
extends ImplementationEditor {
    private EventImplementationEditor(Event event, AbstractFlowNodePropertiesPanel.ChangeTypeListener changeTypeListener) {
        super((FlowNode)event, changeTypeListener);
    }

    public static EventImplementationEditor create(Event event, AbstractFlowNodePropertiesPanel.ChangeTypeListener changeTypeListener) {
        return new EventImplementationEditor(event, changeTypeListener);
    }

    @Override
    protected List<FlowNodePropertiesEditor> buildEditors() {
        Event event = this.getEvent();
        ArrayList<FlowNodePropertiesEditor> editors = new ArrayList<FlowNodePropertiesEditor>();
        editors.add(EventChangeTypeEditor.create((FlowNode)event, this.getChangeTypeListener()));
        EventTriggerType eventType = event.getEventTriggerType();
        boolean isBoundary = event.isCatchEvent() && event.asCatchEvent().isBoundaryEvent();
        MultipleLinksPropertiesEditor linksEditor = new MultipleLinksPropertiesEditor();
        if (EventTriggerType.ERROR.equals((Object)eventType)) {
            editors.add(new ErrorEventEditor(event));
            linksEditor.addLinkEditor(new AssociationTaskEditor((DataAssociationEnabled)event));
            linksEditor.addLinkEditor(new LogHandlersEditor((Loggable)event));
        } else if (EventTriggerType.TIMER.equals((Object)eventType)) {
            if (isBoundary) {
                editors.add(new BoundaryEventEditor((BoundaryEvent)event.asAnyNode(BoundaryEvent.class)));
            }
            if (this.isEventSubprocessStartEvent(event)) {
                editors.add(new AllowsInterruptionsEditor((StartEvent)event.asAnyNode(StartEvent.class)));
            }
            editors.add(new TimerEventEditor(event));
        } else if (EventTriggerType.SIGNAL.equals((Object)eventType)) {
            if (isBoundary) {
                editors.add(new BoundaryEventEditor((BoundaryEvent)event.asAnyNode(BoundaryEvent.class)));
            }
            if (this.isEventSubprocessStartEvent(event)) {
                editors.add(new AllowsInterruptionsEditor((StartEvent)event.asAnyNode(StartEvent.class)));
            }
            editors.add(new SignalEventEditor(event));
            linksEditor.addLinkEditor(new AssociationTaskEditor((DataAssociationEnabled)event));
            linksEditor.addLinkEditor(new CorrelationsEditor((CorrelationsEnabled)event));
            linksEditor.addLinkEditor(new LogHandlersEditor((Loggable)event));
        } else if (EventTriggerType.MESSAGE.equals((Object)eventType)) {
            if (isBoundary) {
                editors.add(new BoundaryEventEditor((BoundaryEvent)event.asAnyNode(BoundaryEvent.class)));
            }
            if (this.isEventSubprocessStartEvent(event)) {
                editors.add(new AllowsInterruptionsEditor((StartEvent)event.asAnyNode(StartEvent.class)));
            }
            ConversationalEditor conversationalEditor = new ConversationalEditor((Conversational)event);
            editors.add(conversationalEditor);
            linksEditor.addLinkEditor(new AssociationTaskEditor((DataAssociationEnabled)event));
            linksEditor.addLinkEditor(new CorrelationsEditor((CorrelationsEnabled)event));
            linksEditor.addLinkEditor(new LogHandlersEditor((Loggable)event));
            linksEditor.addLinkEditor(new MessageHeadersEditor((MessageHeadersEnabled)event));
            linksEditor.addLinkEditor(new ServicePropertiesEditor((ServicePropertiesEnabled)event));
        } else if (EventTriggerType.NONE.equals((Object)eventType) && event.getParentObject() == event.getProcess() && event.getProcess().isCallableSubprocess() && (event.isStart() || event.isEnd())) {
            linksEditor.addLinkEditor(new AssociationTaskEditor((DataAssociationEnabled)event));
        }
        if (linksEditor.hasEditors()) {
            editors.add(linksEditor);
        }
        return editors;
    }

    private boolean isEventSubprocessStartEvent(@NotNull Event event) {
        NodeContainer container = event.getParentObject();
        return event.isStart() && container instanceof Subprocess && ((Subprocess)container).isTriggeredByEvent();
    }

    private Event getEvent() {
        return (Event)this.getFlowNode().asAnyNode(Event.class);
    }
}

