/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.designer.flowpanels.AbstractChangeTypeEditor;
import oracle.bpm.designer.flowpanels.AbstractFlowNodePropertiesPanel;
import oracle.bpm.draw.figure.FlowFigureType;
import oracle.bpm.draw.figure.FlowFigureUtils;
import oracle.bpm.project.command.design.ChangeTriggerTypeCommand;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.FlowNode;

class EventChangeTypeEditor
extends AbstractChangeTypeEditor {
    private EventChangeTypeEditor(FlowNode flowNode, AbstractFlowNodePropertiesPanel.ChangeTypeListener changeTypeListener) {
        super(flowNode, changeTypeListener);
    }

    public static EventChangeTypeEditor create(FlowNode flowNode, AbstractFlowNodePropertiesPanel.ChangeTypeListener changeTypeListener) {
        return new EventChangeTypeEditor(flowNode, changeTypeListener);
    }

    @Override
    protected AbstractChangeTypeEditor.ChangeTypeBuilder createBuilder(FlowNode flowNode, AbstractFlowNodePropertiesPanel.ChangeTypeListener changeTypeListener) {
        return new EventChangeTypeBuilder(flowNode, changeTypeListener);
    }

    private static class EventChangeTypeBuilder
    extends AbstractChangeTypeEditor.ChangeTypeBuilder<EventTriggerType> {
        EventChangeTypeBuilder(FlowNode flowNode, AbstractFlowNodePropertiesPanel.ChangeTypeListener changeTypeListener) {
            super(flowNode, changeTypeListener);
        }

        @Override
        protected List<EventTriggerType> getValues() {
            return new ArrayList<EventTriggerType>(ChangeTriggerTypeCommand.getAllPosibleChanges((Event)this.getEvent()));
        }

        @Override
        protected EventTriggerType getValue() {
            return this.getEvent().getEventTriggerType();
        }

        @Override
        protected void applyChange(EventTriggerType newValue) {
            this.getEvent().setEventTriggerType(newValue);
        }

        @Override
        protected FlowFigureType getFlowFigureType(EventTriggerType value) {
            return value != null ? FlowFigureUtils.fromEvent((BpmnType)this.getEvent().getBpmnType(), (EventTriggerType)value) : null;
        }

        private Event getEvent() {
            return (Event)this.getFlowNode().asAnyNode(Event.class);
        }
    }
}

