/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.designer.flowpanels.DefaultEditorBuilder;
import oracle.bpm.designer.flowpanels.DefaultRowEditorBuilder;
import oracle.bpm.designer.flowpanels.EditorBuilder;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesEditor;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.processes.EventBasedGateway;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;

class EventBasedGatewayEditor
extends FlowNodePropertiesEditor {
    private EventBasedGatewayEditorBuilder builder;

    public EventBasedGatewayEditor(EventBasedGateway gateway) {
        this.builder = new EventBasedGatewayEditorBuilder(gateway);
    }

    @Override
    public void applyChanges() {
        this.builder.applyChanges();
    }

    @Override
    public EditorBuilder getEditorBuilder() {
        return this.builder;
    }

    private static class EventBasedGatewayEditorBuilder
    extends DefaultEditorBuilder {
        private List<EditorBuilder.RowBuilder> builders;
        private EventBasedGateway complexGateway;
        private CheckBox isInstantianteCheck;

        public EventBasedGatewayEditorBuilder(final EventBasedGateway complexGateway) {
            this.complexGateway = complexGateway;
            this.builders = new ArrayList<EditorBuilder.RowBuilder>();
            this.builders.add(new DefaultRowEditorBuilder(DesignerMsg.IS_INSTANTIATE){

                @Override
                public UiComponent createEditor(UiContainer parent) {
                    EventBasedGatewayEditorBuilder.this.isInstantianteCheck = CheckBox.create((UiContainer)parent);
                    EventBasedGatewayEditorBuilder.this.isInstantianteCheck.setSelected(complexGateway.isInstantiate());
                    return EventBasedGatewayEditorBuilder.this.isInstantianteCheck;
                }
            });
        }

        @Override
        public List<EditorBuilder.RowBuilder> getBuilders() {
            return this.builders;
        }

        public void applyChanges() {
            this.getComplexGateway().setInstantiate(this.isInstantianteCheck.isSelected());
        }

        private EventBasedGateway getComplexGateway() {
            return this.complexGateway;
        }
    }
}

