/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.designer.action.NewExceptionAction;
import oracle.bpm.designer.flowpanels.CatalogObjectAddRowEditorBuilder;
import oracle.bpm.designer.flowpanels.DefaultEditorBuilder;
import oracle.bpm.designer.flowpanels.DefaultRowEditorBuilder;
import oracle.bpm.designer.flowpanels.EditorBuilder;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesEditor;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.navigator.NavigatorActions;
import oracle.bpm.designer.navigator.ProjectNavigatorBuilder;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.CatalogModule;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.catalog.ErrorObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.ErrorEventDefinition;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.EventDefinition;
import oracle.bpm.project.view.filter.ProjectFilter;
import oracle.bpm.project.view.filter.ProjectFilters;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;

class ErrorEventEditor
extends FlowNodePropertiesEditor {
    private final ErrorEventEditorBuilder builder;

    ErrorEventEditor(Event event) {
        this.builder = new ErrorEventEditorBuilder(event);
    }

    @Override
    public void applyChanges() {
        this.builder.applyChanges();
    }

    @Override
    public EditorBuilder getEditorBuilder() {
        return this.builder;
    }

    private static class ErrorEventEditorBuilder
    extends DefaultEditorBuilder {
        private final List<EditorBuilder.RowBuilder> builders;
        private CheckBox catchAllBusinessExceptionsCheckBox;
        private CheckBox catchAllSystemExceptionsCheckBox;
        private ErrorObject errorObject;
        private final Event event;

        private ErrorEventEditorBuilder(Event event) {
            this.event = event;
            this.errorObject = this.getErrorEventDefinition().getError();
            this.builders = new ArrayList<EditorBuilder.RowBuilder>();
            final boolean isCatchAllBusinessExceptions = event.isCatchEvent() && this.getErrorEventDefinition().isCatchAll();
            final boolean isCatchAllSystemExceptions = event.isCatchEvent() && this.getErrorEventDefinition().isCatchAllSystemExceptions();
            final ProjectFilters.ErrorObjectFilter errorObjectFilter = ProjectFilters.ErrorObjectFilter.create((boolean)event.isCatchEvent());
            final CatalogObjectAddRowEditorBuilder<ErrorObject> catalogObjectEditor = new CatalogObjectAddRowEditorBuilder<ErrorObject>(ProjectModelMsg.EXCEPTION, event.getProject(), (ProjectFilter)errorObjectFilter, this.errorObject){

                @Override
                public UiComponent createEditor(UiContainer parent) {
                    UiComponent editor = super.createEditor(parent);
                    this.setEnabled(!isCatchAllBusinessExceptions && !isCatchAllSystemExceptions);
                    return editor;
                }

                @Override
                protected void change(ErrorObject newValue) {
                    ErrorEventEditorBuilder.this.errorObject = newValue;
                    ErrorEventEditorBuilder.this.applyChanges();
                }

                @Override
                protected Msg getBrowseTitle() {
                    return DesignerMsg.BROWSE_EXCEPTIONS;
                }

                @Override
                protected ProjectNavigatorBuilder createProjectNavigatorBuilder() {
                    ProjectNavigatorBuilder pnb = new ProjectNavigatorBuilder((ProjectObject)this.getProject().getCatalogRoot(), this.getBrowseTitle()){

                        @Override
                        protected ToolBar buildToolBarPanel(UiContainer parent, List<BaseAction> actions, final NavigatorActions navigatorActions) {
                            ToolBar toolBar = new ToolBar(parent);
                            CheckBox checkBox = CheckBox.create((UiContainer)toolBar, (Msg)DesignerMsg.SHOW_SYSTEM_FAULTS, (boolean)errorObjectFilter.isShowSystemFault());
                            checkBox.addItemListener(new ItemListener(){

                                public void itemStateChanged(ItemEvent e) {
                                    errorObjectFilter.setShowSystemFault(e.isStateSelected());
                                    navigatorActions.refresh();
                                }
                            });
                            toolBar.add((UiComponent)checkBox);
                            return toolBar;
                        }
                    };
                    pnb.filter(this.getProjectFilter()).initialSelection((ProjectObject)this.getValue()).hideRoot();
                    return pnb;
                }

                @Override
                protected void addAction(UiWindow parent) {
                    CatalogModule moduleRoot = this.getProject().getCatalogRoot();
                    try {
                        ErrorObject newErrorObject = NewExceptionAction.createException(parent, (CatalogObject)moduleRoot);
                        if (newErrorObject != null) {
                            this.changeValue(newErrorObject);
                        }
                    }
                    catch (ProjectException e) {
                        MessageDialog.showError((UiContainer)parent, (Throwable)e);
                    }
                }
            };
            if (event.isCatchEvent()) {
                final ItemListener itemListener = new ItemListener(){

                    public void itemStateChanged(ItemEvent e) {
                        ErrorEventEditorBuilder.this.getErrorEventDefinition().setCatchAllSystemExceptions(ErrorEventEditorBuilder.this.catchAllSystemExceptionsCheckBox.isSelected());
                        ErrorEventEditorBuilder.this.getErrorEventDefinition().setCatchAll(ErrorEventEditorBuilder.this.catchAllBusinessExceptionsCheckBox.isSelected());
                        boolean isDisabled = ErrorEventEditorBuilder.this.catchAllBusinessExceptionsCheckBox.isSelected() || ErrorEventEditorBuilder.this.catchAllSystemExceptionsCheckBox.isSelected();
                        catalogObjectEditor.setEnabled(!isDisabled);
                        if (isDisabled) {
                            catalogObjectEditor.changeValue(null);
                        }
                    }
                };
                this.builders.add(new DefaultRowEditorBuilder(null){

                    @Override
                    public UiComponent createEditor(UiContainer parent) {
                        ErrorEventEditorBuilder.this.catchAllBusinessExceptionsCheckBox = CheckBox.create((UiContainer)parent, (Msg)ProjectModelMsg.CATCH_ALL_BUSINESS_EXCEPTIONS);
                        ErrorEventEditorBuilder.this.catchAllBusinessExceptionsCheckBox.setSelected(isCatchAllBusinessExceptions);
                        ErrorEventEditorBuilder.this.catchAllBusinessExceptionsCheckBox.addItemListener(itemListener);
                        return ErrorEventEditorBuilder.this.catchAllBusinessExceptionsCheckBox;
                    }
                });
                this.builders.add(new DefaultRowEditorBuilder(null){

                    @Override
                    public UiComponent createEditor(UiContainer parent) {
                        ErrorEventEditorBuilder.this.catchAllSystemExceptionsCheckBox = CheckBox.create((UiContainer)parent, (Msg)ProjectModelMsg.CATCH_ALL_SYSTEM_EXCEPTIONS);
                        ErrorEventEditorBuilder.this.catchAllSystemExceptionsCheckBox.setSelected(isCatchAllSystemExceptions);
                        ErrorEventEditorBuilder.this.catchAllSystemExceptionsCheckBox.addItemListener(itemListener);
                        return ErrorEventEditorBuilder.this.catchAllSystemExceptionsCheckBox;
                    }
                });
            }
            this.builders.add(catalogObjectEditor);
        }

        @Override
        public List<EditorBuilder.RowBuilder> getBuilders() {
            return this.builders;
        }

        public void applyChanges() {
            ErrorEventDefinition errorEvent = this.getErrorEventDefinition();
            boolean isCatchAll = false;
            if (this.event.isCatchEvent()) {
                boolean isCatchAllBusinessExceptions = this.catchAllBusinessExceptionsCheckBox.isSelected();
                errorEvent.setCatchAll(isCatchAllBusinessExceptions);
                boolean isCatchAllSystemExceptions = this.catchAllSystemExceptionsCheckBox.isSelected();
                errorEvent.setCatchAllSystemExceptions(isCatchAllSystemExceptions);
                isCatchAll = isCatchAllBusinessExceptions || isCatchAllSystemExceptions;
            }
            errorEvent.setError(isCatchAll ? null : this.errorObject);
        }

        private ErrorEventDefinition getErrorEventDefinition() {
            EventDefinition eventDefinition = this.getEvent().getEventDefinition();
            assert (eventDefinition != null);
            return (ErrorEventDefinition)eventDefinition.as(ErrorEventDefinition.class);
        }

        private Event getEvent() {
            return this.event;
        }
    }
}

