/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Link;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.msg.UIMsg;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ElementsLinkEditor
extends Panel {
    private Link actionLink;
    private Button clearButton;
    private Label iconLabel;

    public ElementsLinkEditor(@NotNull UiContainer parent, @NotNull Msg label, @Nullable Image icon) {
        super(parent);
        this.init(label, icon);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.iconLabel != null) {
            this.iconLabel.setEnabled(this.hasElements() && enabled);
        }
        this.actionLink.setEnabled(enabled);
        this.clearButton.setEnabled(enabled);
    }

    public void initialize() {
        this.update();
    }

    protected abstract boolean hasElements();

    protected abstract void clearElements();

    protected abstract void editElements();

    private void init(@NotNull Msg label, @Nullable Image icon) {
        this.setLayout((Layout)new MigLayout("ins 0, gap 5, hidemode 0"));
        if (icon != null) {
            this.iconLabel = Label.create((UiContainer)this, (Image)icon);
            this.add((UiComponent)this.iconLabel);
        }
        BaseAction action = new BaseAction(label){

            public void run() {
                ElementsLinkEditor.this.editElements();
                ElementsLinkEditor.this.update();
            }
        };
        this.actionLink = new Link((UiContainer)this, action);
        this.add((UiComponent)this.actionLink);
        this.clearButton = Button.createIconic((UiContainer)this, (Msg)UIMsg.CLEAR);
        this.clearButton.setAction(new BaseAction(){

            public void run() {
                ElementsLinkEditor.this.clearElements();
                ElementsLinkEditor.this.update();
            }
        });
        this.add((UiComponent)this.clearButton);
    }

    private void update() {
        if (this.iconLabel != null) {
            this.iconLabel.setEnabled(this.hasElements());
        }
        this.clearButton.setVisible(this.hasElements());
    }
}

